/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDropToFrame;
import org.eclipse.debug.internal.ui.actions.AbstractListenerActionDelegate;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;

public class DropToFrameActionDelegate
extends AbstractListenerActionDelegate {
    private UpdateJob fUpdateJob = new UpdateJob();

    public DropToFrameActionDelegate() {
        this.fUpdateJob.setSystem(true);
    }

    protected void doAction(Object element) throws DebugException {
        IDropToFrame dropToFrame;
        if (element instanceof IDropToFrame && (dropToFrame = (IDropToFrame)element).canDropToFrame()) {
            dropToFrame.dropToFrame();
        }
    }

    protected boolean isRunInBackground() {
        return true;
    }

    protected boolean isEnabledFor(Object element) {
        return element instanceof IDropToFrame && ((IDropToFrame)element).canDropToFrame();
    }

    protected void update(IAction action, ISelection selection) {
        this.fUpdateJob.setAction(action);
        this.fUpdateJob.setSelection(selection);
        this.fUpdateJob.schedule();
    }

    class UpdateJob
    extends Job {
        IAction fAction;
        ISelection fSelection;

        UpdateJob() {
            super("Update Action Enablement");
        }

        void setAction(IAction action) {
            this.fAction = action;
        }

        void setSelection(ISelection selection) {
            this.fSelection = selection;
        }

        protected IStatus run(IProgressMonitor monitor) {
            DropToFrameActionDelegate.super.update(this.fAction, this.fSelection);
            return Status.OK_STATUS;
        }
    }
}

