/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.search.internal.ui.util.ListContentProvider;
import org.eclipse.search.internal.ui.util.SWTUtil;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search2.internal.ui.InternalSearchUI;
import org.eclipse.search2.internal.ui.SearchMessages;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.dialogs.SelectionDialog;

public class SearchesDialog
extends SelectionDialog {
    private static final int REMOVE_ID = 1025;
    private static final int WIDTH_IN_CHARACTERS = 55;
    private List fInput;
    private TableViewer fViewer;
    private Button fRemoveButton;

    public SearchesDialog(Shell parent, List input) {
        super(parent);
        this.setTitle(SearchMessages.SearchesDialog_title);
        this.setMessage(SearchMessages.SearchesDialog_message);
        this.fInput = input;
    }

    protected Label createMessageArea(Composite composite) {
        Label label = new Label(composite, 64);
        label.setText(this.getMessage());
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(55);
        label.setLayoutData((Object)gd);
        SearchesDialog.applyDialogFont((Control)label);
        return label;
    }

    public void create() {
        super.create();
        List initialSelection = this.getInitialElementSelections();
        if (initialSelection != null) {
            this.fViewer.setSelection((ISelection)new StructuredSelection(initialSelection));
        }
        this.validateDialogState();
    }

    protected Control createDialogArea(Composite container) {
        Composite ancestor = (Composite)super.createDialogArea(container);
        this.createMessageArea(ancestor);
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        this.fViewer = new TableViewer(parent, 68354);
        this.fViewer.setContentProvider((IContentProvider)new ListContentProvider());
        Table table = this.fViewer.getTable();
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                SearchesDialog.this.okPressed();
            }
        });
        this.fViewer.setLabelProvider((IBaseLabelProvider)new SearchesLabelProvider());
        GridData gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(15);
        gd.widthHint = this.convertWidthInCharsToPixels(55);
        table.setLayoutData((Object)gd);
        this.fRemoveButton = new Button(parent, 8);
        this.fRemoveButton.setText(SearchMessages.SearchesDialog_remove_label);
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SearchesDialog.this.buttonPressed(1025);
            }
        });
        this.fRemoveButton.setLayoutData((Object)new GridData(1, 1, false, false));
        SWTUtil.setButtonDimensionHint(this.fRemoveButton);
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SearchesDialog.this.validateDialogState();
            }
        });
        SearchesDialog.applyDialogFont((Control)ancestor);
        this.fViewer.setInput((Object)this.fInput);
        return table;
    }

    protected final void validateDialogState() {
        IStructuredSelection sel = (IStructuredSelection)this.fViewer.getSelection();
        int elementsSelected = sel.toList().size();
        this.fRemoveButton.setEnabled(elementsSelected > 0);
        Button okButton = this.getOkButton();
        if (okButton != null) {
            okButton.setEnabled(elementsSelected == 1);
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1025) {
            IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
            Iterator searchResults = selection.iterator();
            while (searchResults.hasNext()) {
                ISearchResult result = (ISearchResult)searchResults.next();
                InternalSearchUI.getInstance().removeQuery(result.getQuery());
                this.fInput.remove(result);
                this.fViewer.remove((Object)result);
            }
            if (this.fViewer.getSelection().isEmpty() && !this.fInput.isEmpty()) {
                this.fViewer.setSelection((ISelection)new StructuredSelection(this.fInput.get(0)));
            }
            return;
        }
        super.buttonPressed(buttonId);
    }

    protected void okPressed() {
        ISelection selection = this.fViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            this.setResult(((IStructuredSelection)this.fViewer.getSelection()).toList());
        }
        super.okPressed();
    }

    private static final class SearchesLabelProvider
    extends LabelProvider {
        private ArrayList fImages = new ArrayList();

        SearchesLabelProvider() {
        }

        public String getText(Object element) {
            return ((ISearchResult)element).getLabel();
        }

        public Image getImage(Object element) {
            ImageDescriptor imageDescriptor = ((ISearchResult)element).getImageDescriptor();
            if (imageDescriptor == null) {
                return null;
            }
            Image image = imageDescriptor.createImage();
            this.fImages.add(image);
            return image;
        }

        public void dispose() {
            Iterator iter = this.fImages.iterator();
            while (iter.hasNext()) {
                ((Image)iter.next()).dispose();
            }
            this.fImages = null;
        }
    }
}

