/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.tags;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.tags.SingleFolderTagSource;
import org.eclipse.team.internal.ccvs.ui.tags.TagSource;

public class LocalProjectTagSource
extends TagSource {
    private ICVSRemoteFolder seedFolder;
    private ICVSRemoteFolder[] remoteFolders;

    public static TagSource create(IProject seedProject) {
        try {
            ICVSRemoteFolder seedFolder = (ICVSRemoteFolder)CVSWorkspaceRoot.getRemoteResourceFor((IResource)seedProject);
            ICVSRemoteFolder[] remoteFolders = LocalProjectTagSource.getProjectRemoteFolders();
            if (remoteFolders.length == 1) {
                return null;
            }
            return new LocalProjectTagSource(seedFolder, remoteFolders);
        }
        catch (CVSException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
            return null;
        }
    }

    private LocalProjectTagSource(ICVSRemoteFolder seedFolder, ICVSRemoteFolder[] remoteFolders) {
        this.seedFolder = seedFolder;
        this.remoteFolders = remoteFolders;
    }

    private static ICVSRemoteFolder[] getProjectRemoteFolders() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<ICVSRemoteFolder> result = new ArrayList<ICVSRemoteFolder>();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            try {
                ICVSRemoteFolder remote;
                if (project.isAccessible() && RepositoryProvider.isShared((IProject)project) && (remote = (ICVSRemoteFolder)CVSWorkspaceRoot.getRemoteResourceFor((IResource)project)) != null) {
                    result.add(remote);
                }
            }
            catch (CVSException e) {
                CVSUIPlugin.log((CoreException)((Object)e));
            }
            ++i;
        }
        return result.toArray(new ICVSRemoteFolder[result.size()]);
    }

    public CVSTag[] refresh(boolean bestEffort, IProgressMonitor monitor) throws TeamException {
        return new CVSTag[0];
    }

    public ICVSRepositoryLocation getLocation() {
        return this.seedFolder.getRepository();
    }

    public String getShortDescription() {
        return NLS.bind((String)CVSUIMessages.LocalProjectTagSource_0, (Object[])new String[]{Integer.toString(this.remoteFolders.length)});
    }

    public void commit(CVSTag[] tags, boolean replace, IProgressMonitor monitor) throws CVSException {
    }

    public ICVSResource[] getCVSResources() {
        return this.remoteFolders;
    }

    public CVSTag[] getTags(int type) {
        if (type == 0 || type == -1) {
            return super.getTags(type);
        }
        HashSet<CVSTag> allTags = new HashSet<CVSTag>();
        int i = 0;
        while (i < this.remoteFolders.length) {
            ICVSRemoteFolder folder = this.remoteFolders[i];
            CVSTag[] tags = SingleFolderTagSource.getTags((ICVSFolder)folder, type);
            allTags.addAll(Arrays.asList(tags));
            ++i;
        }
        CVSTag[] tags = SingleFolderTagSource.getTags((ICVSFolder)this.seedFolder, type);
        allTags.removeAll(Arrays.asList(tags));
        return allTags.toArray(new CVSTag[allTags.size()]);
    }
}

