/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.subscriber;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSSyncInfo;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;
import org.eclipse.team.internal.ccvs.ui.CVSDecoration;
import org.eclipse.team.internal.ccvs.ui.CVSLightweightDecorator;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class CVSParticipantLabelDecorator
extends LabelProvider
implements IPropertyChangeListener,
ILabelDecorator {
    private ISynchronizePageConfiguration configuration;

    public CVSParticipantLabelDecorator(ISynchronizePageConfiguration configuration) {
        this.configuration = configuration;
        CVSUIPlugin.addPropertyChangeListener(this);
        TeamUI.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public String decorateText(String input, Object element) {
        try {
            IResource resource;
            String text = input;
            if (element instanceof ISynchronizeModelElement && (resource = ((ISynchronizeModelElement)element).getResource()) != null && resource.getType() != 8) {
                CVSDecoration decoration = this.getDecoration(resource);
                decoration.setRevision(this.getRevisionNumber((ISynchronizeModelElement)element));
                decoration.compute();
                StringBuffer output = new StringBuffer(25);
                if (decoration.getPrefix() != null) {
                    output.append(decoration.getPrefix());
                }
                output.append(text);
                if (decoration.getSuffix() != null) {
                    output.append(decoration.getSuffix());
                }
                return output.toString();
            }
            return text;
        }
        catch (CVSException cVSException) {
            return input;
        }
    }

    protected CVSDecoration getDecoration(IResource resource) throws CVSException {
        return CVSLightweightDecorator.decorate(resource, false);
    }

    public Image decorateImage(Image base, Object element) {
        return base;
    }

    public void propertyChange(PropertyChangeEvent event) {
        Viewer viewer;
        if (this.needsRefresh(event) && (viewer = this.configuration.getPage().getViewer()) instanceof StructuredViewer && !viewer.getControl().isDisposed()) {
            ((StructuredViewer)viewer).refresh(true);
        }
    }

    protected boolean needsRefresh(PropertyChangeEvent event) {
        String property = event.getProperty();
        return property.equals("org.eclipse.team.cvs.ui.P_DECORATORS_CHANGED") || property.equals("org.eclipse.team.uiglobal_file_types_changed");
    }

    public void dispose() {
        CVSUIPlugin.removePropertyChangeListener(this);
        TeamUI.removePropertyChangeListener((IPropertyChangeListener)this);
    }

    protected String getRevisionNumber(ISynchronizeModelElement element) {
        SyncInfo info;
        if (element instanceof SyncInfoModelElement && (info = ((SyncInfoModelElement)element).getSyncInfo()) != null && info.getLocal().getType() == 1 && info instanceof CVSSyncInfo) {
            ICVSRemoteFile local;
            CVSSyncInfo cvsInfo = (CVSSyncInfo)info;
            ICVSRemoteResource remote = (ICVSRemoteResource)cvsInfo.getRemote();
            try {
                local = (ICVSRemoteFile)CVSWorkspaceRoot.getRemoteResourceFor((IResource)info.getLocal());
            }
            catch (CVSException cVSException) {
                local = null;
            }
            if (local == null) {
                local = (ICVSRemoteResource)info.getBase();
            }
            StringBuffer revisionString = new StringBuffer();
            String remoteRevision = this.getRevisionString(remote);
            String localRevision = this.getRevisionString((ICVSRemoteResource)local);
            if (localRevision != null) {
                revisionString.append(localRevision);
            }
            if (remoteRevision != null) {
                revisionString.append(String.valueOf(localRevision != null ? " - " : "") + remoteRevision);
            }
            return revisionString.toString();
        }
        return null;
    }

    private String getRevisionString(ICVSRemoteResource remoteFile) {
        if (remoteFile instanceof RemoteFile) {
            return ((RemoteFile)remoteFile).getRevision();
        }
        return null;
    }
}

