/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.subscriber;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.ComparePreferencePage;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.subscriber.CVSChangeSetCapability;
import org.eclipse.team.internal.ccvs.ui.subscriber.CVSParticipantLabelDecorator;
import org.eclipse.team.internal.ui.synchronize.ChangeSetCapability;
import org.eclipse.team.internal.ui.synchronize.IChangeSetProvider;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.SubscriberParticipant;

public class CVSParticipant
extends SubscriberParticipant
implements IChangeSetProvider {
    private CVSChangeSetCapability capability;
    static /* synthetic */ Class class$0;

    protected void initializeConfiguration(ISynchronizePageConfiguration configuration) {
        super.initializeConfiguration(configuration);
        CVSParticipantLabelDecorator labelDecorator = new CVSParticipantLabelDecorator(configuration);
        configuration.addLabelDecorator((ILabelDecorator)labelDecorator);
    }

    public void prepareCompareInput(ISynchronizeModelElement element, CompareConfiguration config, IProgressMonitor monitor) throws TeamException {
        monitor.beginTask(null, 100);
        CVSParticipant.deriveBaseContentsFromLocal(element, Policy.subMonitorFor(monitor, 10));
        super.prepareCompareInput(element, config, Policy.subMonitorFor(monitor, 80));
        CVSParticipant.updateLabelsForCVS(element, config, Policy.subMonitorFor(monitor, 10));
        monitor.done();
    }

    protected static void updateLabelsForCVS(ISynchronizeModelElement element, CompareConfiguration config, IProgressMonitor monitor) {
        SyncInfo info;
        if (CVSUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_show_author_in_editor") && (info = CVSParticipant.getSyncInfo(element)) != null) {
            IResourceVariant remote = info.getRemote();
            IResourceVariant base = info.getBase();
            String remoteAuthor = null;
            if (remote != null && !remote.isContainer()) {
                try {
                    ILogEntry entry = ((ICVSRemoteFile)remote).getLogEntry(monitor);
                    remoteAuthor = entry.getAuthor();
                    config.setRightLabel(NLS.bind((String)CVSUIMessages.CVSParticipant_0, (Object[])new String[]{remote.getContentIdentifier(), remoteAuthor}));
                }
                catch (TeamException e) {
                    CVSUIPlugin.log((CoreException)((Object)e));
                }
            }
            if (base != null && !base.isContainer()) {
                try {
                    String baseAuthor;
                    if (remoteAuthor != null && remote.getContentIdentifier().equals(base.getContentIdentifier())) {
                        baseAuthor = remoteAuthor;
                    } else {
                        ILogEntry entry = ((ICVSRemoteFile)base).getLogEntry(monitor);
                        baseAuthor = entry.getAuthor();
                    }
                    config.setAncestorLabel(NLS.bind((String)CVSUIMessages.CVSParticipant_1, (Object[])new String[]{base.getContentIdentifier(), baseAuthor}));
                }
                catch (TeamException e) {
                    CVSUIPlugin.log((CoreException)((Object)e));
                }
            }
        }
    }

    protected static SyncInfo getSyncInfo(ISynchronizeModelElement element) {
        if (element instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.team.core.synchronize.SyncInfo");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (SyncInfo)iAdaptable.getAdapter((Class)clazz);
        }
        return null;
    }

    public static void deriveBaseContentsFromLocal(ISynchronizeModelElement element, IProgressMonitor monitor) throws TeamException {
        SyncInfo info = CVSParticipant.getSyncInfo(element);
        if (info == null) {
            return;
        }
        IResource local = info.getLocal();
        IResourceVariant base = info.getBase();
        if (base == null || base.isContainer() || local.getType() != 1 || !local.exists()) {
            return;
        }
        if ((info.getKind() & 0xC) != 8) {
            return;
        }
        try {
            RemoteFile remoteFile = (RemoteFile)base;
            if (!remoteFile.isContentsCached()) {
                remoteFile.setContents((IFile)local, monitor);
            }
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 368) {
                return;
            }
            throw CVSException.wrapException((CoreException)e);
        }
    }

    public PreferencePage[] getPreferencePages() {
        return CVSParticipant.addCVSPreferencePages(super.getPreferencePages());
    }

    public static PreferencePage[] addCVSPreferencePages(PreferencePage[] inheritedPages) {
        PreferencePage[] pages = new PreferencePage[inheritedPages.length + 1];
        int i = 0;
        while (i < inheritedPages.length) {
            pages[i] = inheritedPages[i];
            ++i;
        }
        pages[pages.length - 1] = new ComparePreferencePage();
        pages[pages.length - 1].setTitle(CVSUIMessages.CVSParticipant_2);
        return pages;
    }

    public ChangeSetCapability getChangeSetCapability() {
        if (this.capability == null) {
            this.capability = this.createChangeSetCapability();
        }
        return this.capability;
    }

    protected CVSChangeSetCapability createChangeSetCapability() {
        return new CVSChangeSetCapability();
    }

    protected boolean isViewerContributionsSupported() {
        return true;
    }
}

