/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.internal.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.actions.WorkspaceTraversalAction;
import org.eclipse.team.internal.ccvs.ui.subscriber.WorkspaceSynchronizeParticipant;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.actions.OpenInCompareAction;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ISynchronizeScope;
import org.eclipse.team.ui.synchronize.ResourceScope;
import org.eclipse.team.ui.synchronize.SubscriberParticipant;
import org.eclipse.team.ui.synchronize.SyncInfoCompareInput;
import org.eclipse.team.ui.synchronize.WorkingSetScope;
import org.eclipse.team.ui.synchronize.WorkspaceScope;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;

public class SyncAction
extends WorkspaceTraversalAction {
    public void execute(IAction action) throws InvocationTargetException {
        IResource[] resources = this.getResourcesToCompare(this.getWorkspaceSubscriber());
        if (resources == null || resources.length == 0) {
            return;
        }
        if (SyncAction.isSingleFile(resources)) {
            SyncAction.showSingleFileComparison(this.getShell(), (Subscriber)CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber(), resources[0], this.getTargetPage());
        } else {
            WorkspaceSynchronizeParticipant participant = (WorkspaceSynchronizeParticipant)SubscriberParticipant.getMatchingParticipant((String)"org.eclipse.team.cvs.ui.cvsworkspace-participant", (IResource[])resources);
            if (participant == null) {
                IWorkingSet[] sets;
                Object scope = this.includesAllCVSProjects(resources) ? new WorkspaceScope() : ((sets = this.getSelectedWorkingSets()) != null ? new WorkingSetScope(sets) : new ResourceScope(resources));
                participant = new WorkspaceSynchronizeParticipant((ISynchronizeScope)scope);
                TeamUI.getSynchronizeManager().addSynchronizeParticipants(new ISynchronizeParticipant[]{participant});
            }
            participant.refresh(resources, this.getTargetPart().getSite());
        }
    }

    private IWorkingSet[] getSelectedWorkingSets() {
        ResourceMapping[] mappings = this.getCVSResourceMappings();
        ArrayList<IWorkingSet> sets = new ArrayList<IWorkingSet>();
        int i = 0;
        while (i < mappings.length) {
            ResourceMapping mapping = mappings[i];
            if (!(mapping.getModelObject() instanceof IWorkingSet)) {
                return null;
            }
            IWorkingSet set = (IWorkingSet)mapping.getModelObject();
            sets.add(set);
            ++i;
        }
        if (sets.isEmpty()) {
            return null;
        }
        return sets.toArray(new IWorkingSet[sets.size()]);
    }

    private boolean includesAllCVSProjects(IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource.getType() != 4) {
                return false;
            }
            ++i;
        }
        IProject[] cvsProjects = this.getAllCVSProjects();
        return cvsProjects.length == resources.length;
    }

    private IProject[] getAllCVSProjects() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        HashSet<IProject> cvsProjects = new HashSet<IProject>();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            if (RepositoryProvider.isShared((IProject)project) && RepositoryProvider.getProvider((IProject)project, (String)CVSProviderPlugin.getTypeId()) != null) {
                cvsProjects.add(project);
            }
            ++i;
        }
        return cvsProjects.toArray(new IProject[cvsProjects.size()]);
    }

    public static void showSingleFileComparison(final Shell shell, final Subscriber subscriber, final IResource resource, final IWorkbenchPage page) {
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        subscriber.refresh(new IResource[]{resource}, 0, monitor);
                    }
                    catch (TeamException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
            final SyncInfo info = subscriber.getSyncInfo(resource);
            if (info == null) {
                return;
            }
            shell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    if (info.getKind() == 0) {
                        MessageDialog.openInformation((Shell)shell, (String)CVSUIMessages.SyncAction_noChangesTitle, (String)CVSUIMessages.SyncAction_noChangesMessage);
                    } else {
                        SyncInfoCompareInput input = new SyncInfoCompareInput(subscriber.getName(), info);
                        OpenInCompareAction.openCompareEditor((SyncInfoCompareInput)input, (IWorkbenchPage)page);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            Utils.handle((Throwable)e);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (TeamException e) {
            Utils.handle((Throwable)e);
        }
    }

    public static boolean isSingleFile(IResource[] resources) {
        return resources.length == 1 && resources[0].getType() == 1;
    }

    protected boolean isEnabledForCVSResource(ICVSResource cvsResource) throws CVSException {
        return super.isEnabledForCVSResource(cvsResource) || cvsResource.getParent().isCVSFolder() && !cvsResource.isIgnored();
    }

    public String getId() {
        return "org.eclipse.team.ui.synchronizeLast";
    }
}

