/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.factory;

import java.net.URL;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.spi.ObjectFactory;
import tyrex.tm.DomainConfigurationException;
import tyrex.tm.RecoveryException;
import tyrex.tm.TransactionDomain;

public abstract class TyrexFactory
implements ObjectFactory {
    protected TransactionDomain getTransactionDomain() throws NamingException {
        TransactionDomain domain = null;
        InitialContext initCtx = new InitialContext();
        String config = initCtx.lookup("java:comp/env/tyrexDomainConfig").toString();
        String name = initCtx.lookup("java:comp/env/tyrexDomainName").toString();
        if (config != null && name != null) {
            try {
                domain = TransactionDomain.getDomain((String)name);
            }
            catch (Throwable t) {
                this.log("Error loading Tyrex TransactionDomain", t);
                throw new NamingException("Exception loading TransactionDomain: " + t.getMessage());
            }
            if (domain == null || domain.getState() == 3) {
                URL configURL = Thread.currentThread().getContextClassLoader().getResource(config);
                if (configURL == null) {
                    throw new NamingException("Could not load Tyrex domain config file");
                }
                try {
                    domain = TransactionDomain.createDomain((String)configURL.toString());
                }
                catch (DomainConfigurationException dce) {
                    throw new NamingException("Could not create TransactionDomain: " + dce.getMessage());
                }
            }
        } else {
            throw new NamingException("Specified config file or domain name parameters are invalid.");
        }
        if (domain.getState() == 0) {
            try {
                domain.recover();
            }
            catch (RecoveryException re) {
                throw new NamingException("Could not activate TransactionDomain: " + re.getMessage());
            }
        }
        return domain;
    }

    private void log(String message) {
        System.out.print("TyrexFactory:  ");
        System.out.println(message);
    }

    private void log(String message, Throwable exception) {
        this.log(message);
        exception.printStackTrace(System.out);
    }
}

