/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.junit.Messages;
import org.eclipse.jdt.internal.junit.ui.CounterPanel;
import org.eclipse.jdt.internal.junit.ui.FailureTrace;
import org.eclipse.jdt.internal.junit.ui.ITestRunListener3;
import org.eclipse.jdt.internal.junit.ui.JUnitCopyAction;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jdt.internal.junit.ui.JUnitPreferencesConstants;
import org.eclipse.jdt.internal.junit.ui.JUnitProgressBar;
import org.eclipse.jdt.internal.junit.ui.OpenTestAction;
import org.eclipse.jdt.internal.junit.ui.ProgressImages;
import org.eclipse.jdt.internal.junit.ui.RemoteTestRunnerClient;
import org.eclipse.jdt.internal.junit.ui.ScrollLockAction;
import org.eclipse.jdt.internal.junit.ui.ShowNextFailureAction;
import org.eclipse.jdt.internal.junit.ui.ShowPreviousFailureAction;
import org.eclipse.jdt.internal.junit.ui.TabFolderLayout;
import org.eclipse.jdt.internal.junit.ui.TestRunInfo;
import org.eclipse.jdt.internal.junit.ui.TestRunTab;
import org.eclipse.jdt.junit.ITestRunListener;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.progress.UIJob;

public class TestRunnerViewPart
extends ViewPart
implements ITestRunListener3 {
    public static final String NAME = "org.eclipse.jdt.junit.ResultView";
    public static final String ID_EXTENSION_POINT_TESTRUN_TABS = "org.eclipse.jdt.junit.internal_testRunTabs";
    static final int REFRESH_INTERVAL = 200;
    protected volatile int fExecutedTests;
    protected volatile int fErrorCount;
    protected volatile int fFailureCount;
    protected volatile int fTestCount;
    protected boolean fAutoScroll = true;
    private int fOrientation = 2;
    private int fCurrentOrientation;
    private Map fTestInfos = new HashMap();
    private List fFailures = new ArrayList();
    private List fTreeEntryQueue = new ArrayList();
    private boolean fQueueDrainRequestOutstanding;
    private boolean fTestIsRunning = false;
    protected JUnitProgressBar fProgressBar;
    protected ProgressImages fProgressImages;
    protected Image fViewImage;
    protected CounterPanel fCounterPanel;
    protected boolean fShowOnErrorOnly = false;
    protected Clipboard fClipboard;
    protected volatile String fStatus;
    private FailureTrace fFailureTrace;
    protected Vector fTestRunTabs = new Vector();
    private TestRunTab fActiveRunTab;
    private boolean fIsDisposed = false;
    private IJavaProject fTestProject;
    private String fLaunchMode;
    private ILaunch fLastLaunch;
    private Action fRerunLastTestAction;
    private Action fRerunLastFailedFirstAction;
    private ScrollLockAction fScrollLockAction;
    private ToggleOrientationAction[] fToggleOrientationActions;
    private ActivateOnErrorAction fActivateOnErrorAction;
    private IMenuListener fViewMenuListener;
    private RemoteTestRunnerClient fTestRunnerClient;
    final Image fStackViewIcon = TestRunnerViewPart.createImage("eview16/stackframe.gif");
    final Image fTestRunOKIcon = TestRunnerViewPart.createImage("eview16/junitsucc.gif");
    final Image fTestRunFailIcon = TestRunnerViewPart.createImage("eview16/juniterr.gif");
    final Image fTestRunOKDirtyIcon = TestRunnerViewPart.createImage("eview16/junitsuccq.gif");
    final Image fTestRunFailDirtyIcon = TestRunnerViewPart.createImage("eview16/juniterrq.gif");
    static final String TAG_PAGE = "page";
    static final String TAG_RATIO = "ratio";
    static final String TAG_TRACEFILTER = "tracefilter";
    static final String TAG_ORIENTATION = "orientation";
    static final String TAG_SCROLL = "scroll";
    static final int VIEW_ORIENTATION_VERTICAL = 0;
    static final int VIEW_ORIENTATION_HORIZONTAL = 1;
    static final int VIEW_ORIENTATION_AUTOMATIC = 2;
    private IMemento fMemento;
    Image fOriginalViewImage;
    IElementChangedListener fDirtyListener;
    private CTabFolder fTabFolder;
    private SashForm fSashForm;
    private Action fNextAction;
    private Action fPreviousAction;
    private Composite fCounterComposite;
    private Composite fParent;
    private UpdateUIJob fUpdateJob;
    private JUnitIsRunningJob fJUnitIsRunningJob;
    private ILock fJUnitIsRunningLock;
    public static final Object FAMILY_JUNIT_RUN = new Object();
    private StopAction fStopAction;
    protected boolean fPartIsVisible = false;
    private IPartListener2 fPartListener = new IPartListener2(){

        public void partActivated(IWorkbenchPartReference ref) {
        }

        public void partBroughtToTop(IWorkbenchPartReference ref) {
        }

        public void partInputChanged(IWorkbenchPartReference ref) {
        }

        public void partClosed(IWorkbenchPartReference ref) {
        }

        public void partDeactivated(IWorkbenchPartReference ref) {
        }

        public void partOpened(IWorkbenchPartReference ref) {
        }

        public void partVisible(IWorkbenchPartReference ref) {
            if (TestRunnerViewPart.this.getSite().getId().equals(ref.getId())) {
                TestRunnerViewPart.this.fPartIsVisible = true;
            }
        }

        public void partHidden(IWorkbenchPartReference ref) {
            if (TestRunnerViewPart.this.getSite().getId().equals(ref.getId())) {
                TestRunnerViewPart.this.fPartIsVisible = false;
            }
        }
    };
    private JUnitCopyAction fCopyAction;
    static /* synthetic */ Class class$0;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.fMemento = memento;
        IWorkbenchSiteProgressService progressService = this.getProgressService();
        if (progressService != null) {
            progressService.showBusyForFamily(FAMILY_JUNIT_RUN);
        }
    }

    private IWorkbenchSiteProgressService getProgressService() {
        Object siteService;
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((siteService = iWorkbenchPartSite.getAdapter((Class)clazz)) != null) {
            return (IWorkbenchSiteProgressService)siteService;
        }
        return null;
    }

    private void restoreLayoutState(IMemento memento) {
        Integer orientation;
        Integer ratio;
        Integer page = memento.getInteger(TAG_PAGE);
        if (page != null) {
            int p = page;
            this.fTabFolder.setSelection(p);
            this.fActiveRunTab = (TestRunTab)this.fTestRunTabs.get(p);
        }
        if ((ratio = memento.getInteger(TAG_RATIO)) != null) {
            this.fSashForm.setWeights(new int[]{ratio, 1000 - ratio});
        }
        if ((orientation = memento.getInteger(TAG_ORIENTATION)) != null) {
            this.fOrientation = orientation;
        }
        this.computeOrientation();
        String scrollLock = memento.getString(TAG_SCROLL);
        if (scrollLock != null) {
            this.fScrollLockAction.setChecked(scrollLock.equals("true"));
            this.setAutoScroll(!this.fScrollLockAction.isChecked());
        }
    }

    public void stopTest() {
        if (this.fTestRunnerClient != null) {
            this.fTestRunnerClient.stopTest();
        }
        this.stopUpdateJobs();
    }

    public void rerunTestRun() {
        if (this.lastLaunchIsKeptAlive() && MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)JUnitMessages.TestRunnerViewPart_terminate_title, (String)JUnitMessages.TestRunnerViewPart_terminate_message) && this.fTestRunnerClient != null) {
            this.fTestRunnerClient.stopTest();
        }
        if (this.fLastLaunch != null && this.fLastLaunch.getLaunchConfiguration() != null) {
            ILaunchConfiguration configuration = this.prepareLaunchConfigForRelaunch(this.fLastLaunch.getLaunchConfiguration());
            DebugUITools.launch((ILaunchConfiguration)configuration, (String)this.fLastLaunch.getLaunchMode());
        }
    }

    private ILaunchConfiguration prepareLaunchConfigForRelaunch(ILaunchConfiguration configuration) {
        try {
            String attribute = configuration.getAttribute("org.eclipse.jdt.junit.FAILURENAMES", "");
            if (attribute.length() != 0) {
                String configName = Messages.format(JUnitMessages.TestRunnerViewPart_configName, configuration.getName());
                ILaunchConfigurationWorkingCopy tmp = configuration.copy(configName);
                tmp.setAttribute("org.eclipse.jdt.junit.FAILURENAMES", "");
                return tmp;
            }
        }
        catch (CoreException coreException) {}
        return configuration;
    }

    public void rerunTestFailedFirst() {
        if (this.lastLaunchIsKeptAlive() && MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)JUnitMessages.TestRunnerViewPart_terminate_title, (String)JUnitMessages.TestRunnerViewPart_terminate_message) && this.fTestRunnerClient != null) {
            this.fTestRunnerClient.stopTest();
        }
        if (this.fLastLaunch != null && this.fLastLaunch.getLaunchConfiguration() != null) {
            ILaunchConfiguration launchConfiguration = this.fLastLaunch.getLaunchConfiguration();
            if (launchConfiguration != null) {
                try {
                    String name = JUnitMessages.TestRunnerViewPart_rerunLaunchConfigName;
                    String configName = Messages.format(JUnitMessages.TestRunnerViewPart_configName, name);
                    ILaunchConfigurationWorkingCopy tmp = launchConfiguration.copy(configName);
                    tmp.setAttribute("org.eclipse.jdt.junit.FAILURENAMES", this.createFailureNamesFile());
                    tmp.launch(this.fLastLaunch.getLaunchMode(), null);
                    return;
                }
                catch (CoreException e) {
                    ErrorDialog.openError((Shell)this.getSite().getShell(), (String)JUnitMessages.TestRunnerViewPart_error_cannotrerun, (String)e.getMessage(), (IStatus)e.getStatus());
                }
            }
            MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)JUnitMessages.TestRunnerViewPart_cannotrerun_title, (String)JUnitMessages.TestRunnerViewPart_cannotrerurn_message);
        }
    }

    /*
     * Exception decompiling
     */
    private String createFailureNamesFile() throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [1 : 104->107)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setAutoScroll(boolean scroll) {
        this.fAutoScroll = scroll;
    }

    public boolean isAutoScroll() {
        return this.fAutoScroll;
    }

    public void testRunStarted(int testCount) {
        this.reset(testCount);
        this.fShowOnErrorOnly = TestRunnerViewPart.getShowOnErrorOnly();
        ++this.fExecutedTests;
        this.stopUpdateJobs();
        this.fUpdateJob = new UpdateUIJob(JUnitMessages.TestRunnerViewPart_jobName);
        this.fJUnitIsRunningJob = new JUnitIsRunningJob(JUnitMessages.TestRunnerViewPart_wrapperJobName);
        this.fJUnitIsRunningLock = Platform.getJobManager().newLock();
        this.fJUnitIsRunningLock.acquire();
        this.getProgressService().schedule((Job)this.fJUnitIsRunningJob);
        this.fUpdateJob.schedule(200L);
        this.fRerunLastTestAction.setEnabled(true);
    }

    public void selectNextFailure() {
        this.fActiveRunTab.selectNext();
    }

    public void selectPreviousFailure() {
        this.fActiveRunTab.selectPrevious();
    }

    public void showTest(TestRunInfo test) {
        this.fActiveRunTab.setSelectedTest(test.getTestId());
        this.handleTestSelected(test.getTestId());
        new OpenTestAction(this, test.getClassName(), test.getTestMethodName(), false).run();
    }

    public void reset() {
        this.reset(0);
        this.setContentDescription(" ");
        this.clearStatus();
        this.resetViewIcon();
    }

    public void testRunEnded(long elapsedTime) {
        --this.fExecutedTests;
        Object[] keys = new String[]{this.elapsedTimeAsString(elapsedTime)};
        String msg = Messages.format(JUnitMessages.TestRunnerViewPart_message_finish, keys);
        if (this.hasErrorsOrFailures()) {
            this.postError(msg);
        } else {
            this.setInfoMessage(msg);
        }
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (TestRunnerViewPart.this.isDisposed()) {
                    return;
                }
                TestRunnerViewPart.this.fStopAction.setEnabled(TestRunnerViewPart.this.lastLaunchIsKeptAlive());
                TestRunnerViewPart.this.fRerunLastFailedFirstAction.setEnabled(TestRunnerViewPart.this.hasErrorsOrFailures());
                if (TestRunnerViewPart.this.fFailures.size() > 0) {
                    TestRunnerViewPart.this.selectFirstFailure();
                }
                TestRunnerViewPart.this.updateViewIcon();
                if (TestRunnerViewPart.this.fDirtyListener == null) {
                    TestRunnerViewPart.this.fDirtyListener = new DirtyListener();
                    JavaCore.addElementChangedListener((IElementChangedListener)TestRunnerViewPart.this.fDirtyListener);
                }
                Enumeration e = TestRunnerViewPart.this.fTestRunTabs.elements();
                while (e.hasMoreElements()) {
                    TestRunTab v = (TestRunTab)e.nextElement();
                    v.aboutToEnd();
                }
                TestRunnerViewPart.this.warnOfContentChange();
            }
        });
        this.stopUpdateJobs();
    }

    private void stopUpdateJobs() {
        if (this.fUpdateJob != null) {
            this.fUpdateJob.stop();
            this.fUpdateJob = null;
        }
        if (this.fJUnitIsRunningJob != null && this.fJUnitIsRunningLock != null) {
            this.fJUnitIsRunningLock.release();
            this.fJUnitIsRunningJob = null;
        }
    }

    protected void selectFirstFailure() {
        TestRunInfo firstFailure = (TestRunInfo)this.fFailures.get(0);
        if (firstFailure != null && this.fActiveRunTab.getSelectedTestId() == null) {
            this.fActiveRunTab.setSelectedTest(firstFailure.getTestId());
            this.handleTestSelected(firstFailure.getTestId());
        }
    }

    private void updateViewIcon() {
        this.fViewImage = this.hasErrorsOrFailures() ? this.fTestRunFailIcon : this.fTestRunOKIcon;
        this.firePropertyChange(1);
    }

    private boolean hasErrorsOrFailures() {
        return this.fErrorCount + this.fFailureCount > 0;
    }

    private String elapsedTimeAsString(long runTime) {
        return NumberFormat.getInstance().format((double)runTime / 1000.0);
    }

    public void testRunStopped(long elapsedTime) {
        String msg = JUnitMessages.TestRunnerViewPart_message_stopped;
        this.setInfoMessage(msg);
        this.handleStopped();
    }

    private void handleStopped() {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (TestRunnerViewPart.this.isDisposed()) {
                    return;
                }
                TestRunnerViewPart.this.resetViewIcon();
                TestRunnerViewPart.this.fStopAction.setEnabled(false);
                TestRunnerViewPart.this.fRerunLastFailedFirstAction.setEnabled(TestRunnerViewPart.this.hasErrorsOrFailures());
                TestRunnerViewPart.this.fProgressBar.stopped();
            }
        });
        this.stopUpdateJobs();
    }

    private void resetViewIcon() {
        this.fViewImage = this.fOriginalViewImage;
        this.firePropertyChange(1);
    }

    public void testRunTerminated() {
        String msg = JUnitMessages.TestRunnerViewPart_message_terminated;
        this.showMessage(msg);
        this.handleStopped();
    }

    private void showMessage(String msg) {
        this.postError(msg);
    }

    public void testStarted(String testId, String testName) {
        TestRunInfo testInfo;
        this.fTestIsRunning = true;
        this.postStartTest(testId, testName);
        if (!this.fShowOnErrorOnly && this.fExecutedTests == 1) {
            this.postShowTestResultsView();
        }
        if ((testInfo = this.getTestInfo(testId)) == null) {
            testInfo = new TestRunInfo(testId, testName);
            this.fTestInfos.put(testId, testInfo);
        }
        String className = testInfo.getClassName();
        String method = testInfo.getTestMethodName();
        String status = Messages.format(JUnitMessages.TestRunnerViewPart_message_started, new String[]{className, method});
        this.setInfoMessage(status);
    }

    public void testEnded(String testId, String testName) {
        this.postEndTest(testId, testName);
        ++this.fExecutedTests;
    }

    public void testFailed(int status, String testId, String testName, String trace) {
        this.testFailed(status, testId, testName, trace, null, null);
    }

    public void testFailed(int status, String testId, String testName, String trace, String expected, String actual) {
        TestRunInfo testInfo = this.getTestInfo(testId);
        if (testInfo == null) {
            testInfo = new TestRunInfo(testId, testName);
            this.fTestInfos.put(testId, testInfo);
        }
        testInfo.setTrace(trace);
        testInfo.setStatus(status);
        if (expected != null && expected.length() != 0) {
            testInfo.setExpected(expected.substring(0, expected.length() - 1));
        }
        if (actual != null && actual.length() != 0) {
            testInfo.setActual(actual.substring(0, actual.length() - 1));
        }
        if (status == 1) {
            ++this.fErrorCount;
        } else {
            ++this.fFailureCount;
        }
        this.fFailures.add(testInfo);
        if (this.fShowOnErrorOnly && this.fErrorCount + this.fFailureCount == 1) {
            this.postShowTestResultsView();
        }
        if (!this.fTestIsRunning) {
            this.fTestIsRunning = false;
            this.testEnded(testId, testName);
        }
    }

    public void testReran(final String testId, String className, String testName, int status, String trace) {
        String msg;
        if (status == 1) {
            msg = Messages.format(JUnitMessages.TestRunnerViewPart_message_error, new String[]{testName, className});
            this.postError(msg);
        } else if (status == 2) {
            msg = Messages.format(JUnitMessages.TestRunnerViewPart_message_failure, new String[]{testName, className});
            this.postError(msg);
        } else {
            msg = Messages.format(JUnitMessages.TestRunnerViewPart_message_success, new String[]{testName, className});
            this.setInfoMessage(msg);
        }
        TestRunInfo info = this.getTestInfo(testId);
        this.updateTest(info, status);
        this.postSyncRunnable(new Runnable(){

            public void run() {
                TestRunnerViewPart.this.refreshCounters();
                Enumeration e = TestRunnerViewPart.this.fTestRunTabs.elements();
                while (e.hasMoreElements()) {
                    TestRunTab v = (TestRunTab)e.nextElement();
                    v.endRerunTest(testId);
                }
            }
        });
        if (info.getTrace() == null || !info.getTrace().equals(trace)) {
            info.setTrace(trace);
            this.showFailure(info);
        }
    }

    public void testReran(String testId, String className, String testName, int statusCode, String trace, String expectedResult, String actualResult) {
        this.testReran(testId, className, testName, statusCode, trace);
        TestRunInfo info = this.getTestInfo(testId);
        info.setActual(actualResult);
        info.setExpected(expectedResult);
        this.fFailureTrace.updateEnablement(info);
    }

    private void updateTest(final TestRunInfo info, int status) {
        if (status == info.getStatus()) {
            return;
        }
        if (info.getStatus() == 0) {
            if (status == 2) {
                ++this.fFailureCount;
            } else if (status == 1) {
                ++this.fErrorCount;
            }
        } else if (info.getStatus() == 1) {
            if (status == 0) {
                --this.fErrorCount;
            } else if (status == 2) {
                --this.fErrorCount;
                ++this.fFailureCount;
            }
        } else if (info.getStatus() == 2) {
            if (status == 0) {
                --this.fFailureCount;
            } else if (status == 1) {
                --this.fFailureCount;
                ++this.fErrorCount;
            }
        }
        info.setStatus(status);
        this.postSyncRunnable(new Runnable(){

            public void run() {
                Enumeration e = TestRunnerViewPart.this.fTestRunTabs.elements();
                while (e.hasMoreElements()) {
                    TestRunTab v = (TestRunTab)e.nextElement();
                    v.testStatusChanged(info);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTreeEntry(String treeEntry) {
        List list = this.fTreeEntryQueue;
        synchronized (list) {
            this.fTreeEntryQueue.add(treeEntry);
            if (!this.fQueueDrainRequestOutstanding) {
                this.fQueueDrainRequestOutstanding = true;
                if (!this.isDisposed()) {
                    this.getDisplay().asyncExec((Runnable)new TreeEntryQueueDrainer());
                }
            }
        }
    }

    public void startTestRunListening(IJavaElement type, int port, ILaunch launch) {
        this.fTestProject = type.getJavaProject();
        this.fLaunchMode = launch.getLaunchMode();
        this.aboutToLaunch();
        if (this.fTestRunnerClient != null) {
            this.stopTest();
        }
        this.fTestRunnerClient = new RemoteTestRunnerClient();
        ITestRunListener[] listenerArray = this.getListenerArray();
        this.fTestRunnerClient.startListening(listenerArray, port);
        this.fLastLaunch = launch;
        this.setContentDescription(MessageFormat.format(JUnitMessages.TestRunnerViewPart_Launching, launch.getLaunchConfiguration().getName()));
        if (type instanceof IType) {
            this.setTitleToolTip(((IType)type).getFullyQualifiedName('.'));
        } else {
            this.setTitleToolTip(type.getElementName());
        }
    }

    protected ITestRunListener[] getListenerArray() {
        List listeners = JUnitPlugin.getDefault().getTestRunListeners();
        ITestRunListener[] listenerArray = new ITestRunListener[listeners.size() + 1];
        listeners.toArray(listenerArray);
        System.arraycopy(listenerArray, 0, listenerArray, 1, listenerArray.length - 1);
        listenerArray[0] = this;
        return listenerArray;
    }

    protected void aboutToLaunch() {
        String msg = JUnitMessages.TestRunnerViewPart_message_launching;
        this.setInfoMessage(msg);
        this.fViewImage = this.fOriginalViewImage;
        this.firePropertyChange(1);
    }

    public synchronized void dispose() {
        this.fIsDisposed = true;
        this.stopTest();
        if (this.fProgressImages != null) {
            this.fProgressImages.dispose();
        }
        this.getViewSite().getPage().removePartListener(this.fPartListener);
        this.fTestRunOKIcon.dispose();
        this.fTestRunFailIcon.dispose();
        this.fStackViewIcon.dispose();
        this.fTestRunOKDirtyIcon.dispose();
        this.fTestRunFailDirtyIcon.dispose();
        if (this.fClipboard != null) {
            this.fClipboard.dispose();
        }
        if (this.fViewMenuListener != null) {
            this.getViewSite().getActionBars().getMenuManager().removeMenuListener(this.fViewMenuListener);
        }
    }

    protected void start(int total) {
        this.resetProgressBar(total);
        this.fCounterPanel.setTotal(total);
        this.fCounterPanel.setRunValue(0);
    }

    private void resetProgressBar(int total) {
        this.fProgressBar.reset();
        this.fProgressBar.setMaximum(total);
    }

    private void postSyncRunnable(Runnable r) {
        if (!this.isDisposed()) {
            this.getDisplay().syncExec(r);
        }
    }

    private void aboutToStart() {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (!TestRunnerViewPart.this.isDisposed()) {
                    Enumeration e = TestRunnerViewPart.this.fTestRunTabs.elements();
                    while (e.hasMoreElements()) {
                        TestRunTab v = (TestRunTab)e.nextElement();
                        v.aboutToStart();
                    }
                    TestRunnerViewPart.this.fNextAction.setEnabled(false);
                    TestRunnerViewPart.this.fPreviousAction.setEnabled(false);
                }
            }
        });
    }

    private void postEndTest(final String testId, String testName) {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (TestRunnerViewPart.this.isDisposed()) {
                    return;
                }
                TestRunnerViewPart.this.handleEndTest();
                Enumeration e = TestRunnerViewPart.this.fTestRunTabs.elements();
                while (e.hasMoreElements()) {
                    TestRunTab v = (TestRunTab)e.nextElement();
                    v.endTest(testId);
                }
                if (TestRunnerViewPart.this.fFailureCount + TestRunnerViewPart.this.fErrorCount > 0) {
                    TestRunnerViewPart.this.fNextAction.setEnabled(true);
                    TestRunnerViewPart.this.fPreviousAction.setEnabled(true);
                }
            }
        });
    }

    private void postStartTest(final String testId, String testName) {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (TestRunnerViewPart.this.isDisposed()) {
                    return;
                }
                Enumeration e = TestRunnerViewPart.this.fTestRunTabs.elements();
                while (e.hasMoreElements()) {
                    TestRunTab v = (TestRunTab)e.nextElement();
                    v.startTest(testId);
                }
            }
        });
    }

    private void handleEndTest() {
        this.fTestIsRunning = false;
        this.fProgressBar.step(this.fFailureCount + this.fErrorCount);
        if (!this.fPartIsVisible) {
            this.updateViewTitleProgress();
        }
    }

    private void updateViewTitleProgress() {
        Image progress = this.fProgressImages.getImage(this.fExecutedTests, this.fTestCount, this.fErrorCount, this.fFailureCount);
        if (progress != this.fViewImage) {
            this.fViewImage = progress;
            this.firePropertyChange(1);
        }
    }

    private void refreshCounters() {
        this.fCounterPanel.setErrorValue(this.fErrorCount);
        this.fCounterPanel.setFailureValue(this.fFailureCount);
        this.fCounterPanel.setRunValue(this.fExecutedTests);
        this.fProgressBar.refresh(this.fErrorCount + this.fFailureCount > 0);
    }

    protected void postShowTestResultsView() {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (TestRunnerViewPart.this.isDisposed()) {
                    return;
                }
                TestRunnerViewPart.this.showTestResultsView();
            }
        });
    }

    public void showTestResultsView() {
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        TestRunnerViewPart testRunner = null;
        if (page != null) {
            try {
                testRunner = (TestRunnerViewPart)page.findView(NAME);
                if (testRunner == null) {
                    IWorkbenchPart activePart = page.getActivePart();
                    testRunner = (TestRunnerViewPart)page.showView(NAME);
                    page.activate(activePart);
                } else {
                    page.bringToTop((IWorkbenchPart)testRunner);
                }
            }
            catch (PartInitException pie) {
                JUnitPlugin.log(pie);
            }
        }
    }

    protected void doShowStatus() {
        this.setContentDescription(this.fStatus);
    }

    protected void setInfoMessage(String message) {
        this.fStatus = message;
    }

    protected void postError(String message) {
        this.fStatus = message;
    }

    protected void showInformation(final String info) {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (!TestRunnerViewPart.this.isDisposed()) {
                    TestRunnerViewPart.this.fFailureTrace.setInformation(info);
                }
            }
        });
    }

    protected CTabFolder createTestRunTabs(Composite parent) {
        CTabFolder tabFolder = new CTabFolder(parent, 128);
        tabFolder.setLayoutData((Object)new GridData(1808));
        this.loadTestRunTabs(tabFolder);
        tabFolder.setSelection(0);
        this.fActiveRunTab = (TestRunTab)this.fTestRunTabs.firstElement();
        tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TestRunnerViewPart.this.testTabChanged(event);
            }
        });
        return tabFolder;
    }

    private void loadTestRunTabs(CTabFolder tabFolder) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(ID_EXTENSION_POINT_TESTRUN_TABS);
        if (extensionPoint == null) {
            return;
        }
        IConfigurationElement[] configs = extensionPoint.getConfigurationElements();
        MultiStatus status = new MultiStatus("org.eclipse.jdt.junit", 0, "Could not load some testRunTabs extension points", null);
        int i = 0;
        while (i < configs.length) {
            try {
                TestRunTab testRunTab = (TestRunTab)configs[i].createExecutableExtension("class");
                testRunTab.createTabControl(tabFolder, this.fClipboard, this);
                this.fTestRunTabs.addElement(testRunTab);
            }
            catch (CoreException e) {
                status.add(e.getStatus());
            }
            ++i;
        }
        if (!status.isOK()) {
            JUnitPlugin.log((IStatus)status);
        }
    }

    private void testTabChanged(SelectionEvent event) {
        Enumeration e = this.fTestRunTabs.elements();
        while (e.hasMoreElements()) {
            TestRunTab v = (TestRunTab)e.nextElement();
            if (((CTabFolder)event.widget).getSelection().getText() != v.getName()) continue;
            v.setSelectedTest(this.fActiveRunTab.getSelectedTestId());
            this.fActiveRunTab = v;
            this.fActiveRunTab.activate();
        }
    }

    private SashForm createSashForm(Composite parent) {
        this.fSashForm = new SashForm(parent, 512);
        ViewForm top = new ViewForm((Composite)this.fSashForm, 0);
        this.fTabFolder = this.createTestRunTabs((Composite)top);
        this.fTabFolder.setLayoutData((Object)new TabFolderLayout());
        top.setContent((Control)this.fTabFolder);
        ViewForm bottom = new ViewForm((Composite)this.fSashForm, 0);
        CLabel label = new CLabel((Composite)bottom, 0);
        label.setText(JUnitMessages.TestRunnerViewPart_label_failure);
        label.setImage(this.fStackViewIcon);
        bottom.setTopLeft((Control)label);
        ToolBar failureToolBar = new ToolBar((Composite)bottom, 0x800040);
        bottom.setTopCenter((Control)failureToolBar);
        this.fFailureTrace = new FailureTrace((Composite)bottom, this.fClipboard, this, failureToolBar);
        bottom.setContent((Control)this.fFailureTrace.getComposite());
        this.fSashForm.setWeights(new int[]{50, 50});
        return this.fSashForm;
    }

    private void reset(final int testCount) {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (TestRunnerViewPart.this.isDisposed()) {
                    return;
                }
                TestRunnerViewPart.this.fCounterPanel.reset();
                TestRunnerViewPart.this.fFailureTrace.clear();
                TestRunnerViewPart.this.fProgressBar.reset();
                TestRunnerViewPart.this.fStopAction.setEnabled(true);
                TestRunnerViewPart.this.clearStatus();
                TestRunnerViewPart.this.start(testCount);
            }
        });
        this.fExecutedTests = 0;
        this.fFailureCount = 0;
        this.fErrorCount = 0;
        this.fTestCount = testCount;
        this.aboutToStart();
        this.fTestInfos.clear();
        this.fFailures = new ArrayList();
    }

    private void clearStatus() {
        this.getStatusLine().setMessage(null);
        this.getStatusLine().setErrorMessage(null);
    }

    public void setFocus() {
        if (this.fActiveRunTab != null) {
            this.fActiveRunTab.setFocus();
        }
    }

    public void createPartControl(Composite parent) {
        this.fParent = parent;
        this.addResizeListener(parent);
        this.fClipboard = new Clipboard(parent.getDisplay());
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        parent.setLayout((Layout)gridLayout);
        this.configureToolBar();
        this.fCounterComposite = this.createProgressCountPanel(parent);
        this.fCounterComposite.setLayoutData((Object)new GridData(768));
        SashForm sashForm = this.createSashForm(parent);
        sashForm.setLayoutData((Object)new GridData(1808));
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.fCopyAction = new JUnitCopyAction(this.fFailureTrace, this.fClipboard);
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.fCopyAction);
        this.fOriginalViewImage = this.getTitleImage();
        this.fProgressImages = new ProgressImages();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.jdt.junit.results_view_context");
        this.getViewSite().getPage().addPartListener(this.fPartListener);
        if (this.fMemento != null) {
            this.restoreLayoutState(this.fMemento);
        }
        this.fMemento = null;
    }

    private void addResizeListener(Composite parent) {
        parent.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                TestRunnerViewPart.this.computeOrientation();
            }
        });
    }

    void computeOrientation() {
        if (this.fOrientation != 2) {
            this.fCurrentOrientation = this.fOrientation;
            this.setOrientation(this.fCurrentOrientation);
        } else {
            Point size = this.fParent.getSize();
            if (size.x != 0 && size.y != 0) {
                if (size.x > size.y) {
                    this.setOrientation(1);
                } else {
                    this.setOrientation(0);
                }
            }
        }
    }

    public void saveState(IMemento memento) {
        if (this.fSashForm == null) {
            if (this.fMemento != null) {
                memento.putMemento(this.fMemento);
            }
            return;
        }
        int activePage = this.fTabFolder.getSelectionIndex();
        memento.putInteger(TAG_PAGE, activePage);
        memento.putString(TAG_SCROLL, this.fScrollLockAction.isChecked() ? "true" : "false");
        int[] weigths = this.fSashForm.getWeights();
        int ratio = weigths[0] * 1000 / (weigths[0] + weigths[1]);
        memento.putInteger(TAG_RATIO, ratio);
        memento.putInteger(TAG_ORIENTATION, this.fOrientation);
    }

    private void configureToolBar() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBar = actionBars.getToolBarManager();
        IMenuManager viewMenu = actionBars.getMenuManager();
        this.fRerunLastTestAction = new RerunLastAction();
        this.fRerunLastFailedFirstAction = new RerunLastFailedFirstAction();
        this.fScrollLockAction = new ScrollLockAction(this);
        this.fToggleOrientationActions = new ToggleOrientationAction[]{new ToggleOrientationAction(this, 0), new ToggleOrientationAction(this, 1), new ToggleOrientationAction(this, 2)};
        this.fNextAction = new ShowNextFailureAction(this);
        this.fPreviousAction = new ShowPreviousFailureAction(this);
        this.fStopAction = new StopAction();
        this.fNextAction.setEnabled(false);
        this.fPreviousAction.setEnabled(false);
        this.fStopAction.setEnabled(false);
        actionBars.setGlobalActionHandler(ActionFactory.NEXT.getId(), (IAction)this.fNextAction);
        actionBars.setGlobalActionHandler(ActionFactory.PREVIOUS.getId(), (IAction)this.fPreviousAction);
        toolBar.add((IAction)this.fNextAction);
        toolBar.add((IAction)this.fPreviousAction);
        toolBar.add((IAction)this.fStopAction);
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IAction)this.fRerunLastTestAction);
        toolBar.add((IAction)this.fRerunLastFailedFirstAction);
        toolBar.add((IAction)this.fScrollLockAction);
        int i = 0;
        while (i < this.fToggleOrientationActions.length) {
            viewMenu.add((IAction)this.fToggleOrientationActions[i]);
            ++i;
        }
        viewMenu.add((IContributionItem)new Separator());
        this.fActivateOnErrorAction = new ActivateOnErrorAction();
        viewMenu.add((IAction)this.fActivateOnErrorAction);
        this.fViewMenuListener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TestRunnerViewPart.this.fActivateOnErrorAction.update();
            }
        };
        viewMenu.addMenuListener(this.fViewMenuListener);
        this.fScrollLockAction.setChecked(!this.fAutoScroll);
        actionBars.updateActionBars();
    }

    private IStatusLineManager getStatusLine() {
        IEditorPart activeEditorPart;
        IEditorActionBarContributor contributor;
        IViewSite site = this.getViewSite();
        IWorkbenchPage page = site.getPage();
        IWorkbenchPart activePart = page.getActivePart();
        if (activePart instanceof IViewPart) {
            IViewPart activeViewPart = (IViewPart)activePart;
            IViewSite activeViewSite = activeViewPart.getViewSite();
            return activeViewSite.getActionBars().getStatusLineManager();
        }
        if (activePart instanceof IEditorPart && (contributor = (activeEditorPart = (IEditorPart)activePart).getEditorSite().getActionBarContributor()) instanceof EditorActionBarContributor) {
            return ((EditorActionBarContributor)contributor).getActionBars().getStatusLineManager();
        }
        return this.getViewSite().getActionBars().getStatusLineManager();
    }

    protected Composite createProgressCountPanel(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        this.setCounterColumns(layout);
        this.fCounterPanel = new CounterPanel(composite);
        this.fCounterPanel.setLayoutData(new GridData(768));
        this.fProgressBar = new JUnitProgressBar(composite);
        this.fProgressBar.setLayoutData(new GridData(768));
        return composite;
    }

    public TestRunInfo getTestInfo(String testId) {
        if (testId == null) {
            return null;
        }
        return (TestRunInfo)this.fTestInfos.get(testId);
    }

    public void handleTestSelected(String testId) {
        this.handleTestSelected(this.getTestInfo(testId));
    }

    public void handleTestSelected(TestRunInfo testInfo) {
        if (testInfo == null) {
            this.showFailure(null);
        } else {
            this.showFailure(testInfo);
        }
        this.fCopyAction.handleTestSelected(testInfo);
    }

    private void showFailure(final TestRunInfo failure) {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (!TestRunnerViewPart.this.isDisposed()) {
                    TestRunnerViewPart.this.fFailureTrace.showFailure(failure);
                }
            }
        });
    }

    public IJavaProject getLaunchedProject() {
        return this.fTestProject;
    }

    public ILaunch getLastLaunch() {
        return this.fLastLaunch;
    }

    public static Image createImage(String path) {
        try {
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)JUnitPlugin.makeIconFileURL(path));
            return id.createImage();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private boolean isDisposed() {
        return this.fIsDisposed || this.fCounterPanel.isDisposed();
    }

    private Display getDisplay() {
        return this.getViewSite().getShell().getDisplay();
    }

    public Image getTitleImage() {
        if (this.fOriginalViewImage == null) {
            this.fOriginalViewImage = super.getTitleImage();
        }
        if (this.fViewImage == null) {
            return super.getTitleImage();
        }
        return this.fViewImage;
    }

    void codeHasChanged() {
        if (this.fDirtyListener != null) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this.fDirtyListener);
            this.fDirtyListener = null;
        }
        if (this.fViewImage == this.fTestRunOKIcon) {
            this.fViewImage = this.fTestRunOKDirtyIcon;
        } else if (this.fViewImage == this.fTestRunFailIcon) {
            this.fViewImage = this.fTestRunFailDirtyIcon;
        }
        Runnable r = new Runnable(){

            public void run() {
                if (TestRunnerViewPart.this.isDisposed()) {
                    return;
                }
                TestRunnerViewPart.this.firePropertyChange(1);
            }
        };
        if (!this.isDisposed()) {
            this.getDisplay().asyncExec(r);
        }
    }

    boolean isCreated() {
        return this.fCounterPanel != null;
    }

    public void rerunTest(String testId, String className, String testName, String launchMode) {
        DebugUITools.saveAndBuildBeforeLaunch();
        this.postRerunTest(testId);
        if (this.lastLaunchIsKeptAlive()) {
            this.fTestRunnerClient.rerunTest(testId, className, testName);
        } else if (this.fLastLaunch != null) {
            ILaunchConfiguration launchConfiguration = this.fLastLaunch.getLaunchConfiguration();
            if (launchConfiguration != null) {
                try {
                    String name = className;
                    if (testName != null) {
                        name = String.valueOf(name) + "." + testName;
                    }
                    String configName = Messages.format(JUnitMessages.TestRunnerViewPart_configName, name);
                    ILaunchConfigurationWorkingCopy tmp = launchConfiguration.copy(configName);
                    tmp.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, className);
                    tmp.setAttribute("org.eclipse.jdt.junit.CONTAINER", "");
                    if (testName != null) {
                        tmp.setAttribute("org.eclipse.jdt.junit.TESTNAME", testName);
                    }
                    tmp.launch(launchMode, null);
                    return;
                }
                catch (CoreException e) {
                    ErrorDialog.openError((Shell)this.getSite().getShell(), (String)JUnitMessages.TestRunnerViewPart_error_cannotrerun, (String)e.getMessage(), (IStatus)e.getStatus());
                }
            }
            MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)JUnitMessages.TestRunnerViewPart_cannotrerun_title, (String)JUnitMessages.TestRunnerViewPart_cannotrerurn_message);
        }
    }

    private void postRerunTest(final String testId) {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (TestRunnerViewPart.this.isDisposed()) {
                    return;
                }
                Enumeration e = TestRunnerViewPart.this.fTestRunTabs.elements();
                while (e.hasMoreElements()) {
                    TestRunTab v = (TestRunTab)e.nextElement();
                    v.rerunTest(testId);
                }
            }
        });
    }

    public void warnOfContentChange() {
        IWorkbenchSiteProgressService service = this.getProgressService();
        if (service != null) {
            service.warnOfContentChange();
        }
    }

    public boolean lastLaunchIsKeptAlive() {
        return this.fTestRunnerClient != null && this.fTestRunnerClient.isRunning() && "debug".equals(this.fLaunchMode);
    }

    private void setOrientation(int orientation) {
        if (this.fSashForm == null || this.fSashForm.isDisposed()) {
            return;
        }
        boolean horizontal = orientation == 1;
        this.fSashForm.setOrientation(horizontal ? 256 : 512);
        int i = 0;
        while (i < this.fToggleOrientationActions.length) {
            this.fToggleOrientationActions[i].setChecked(this.fOrientation == this.fToggleOrientationActions[i].getOrientation());
            ++i;
        }
        this.fCurrentOrientation = orientation;
        GridLayout layout = (GridLayout)this.fCounterComposite.getLayout();
        this.setCounterColumns(layout);
        this.fParent.layout();
    }

    private void setCounterColumns(GridLayout layout) {
        layout.numColumns = this.fCurrentOrientation == 1 ? 2 : 1;
    }

    private static boolean getShowOnErrorOnly() {
        IPreferenceStore store = JUnitPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(JUnitPreferencesConstants.SHOW_ON_ERROR_ONLY);
    }

    private class StopAction
    extends Action {
        public StopAction() {
            this.setText(JUnitMessages.TestRunnerViewPart_stopaction_text);
            this.setToolTipText(JUnitMessages.TestRunnerViewPart_stopaction_tooltip);
            this.setDisabledImageDescriptor(JUnitPlugin.getImageDescriptor("dlcl16/stop.gif"));
            this.setHoverImageDescriptor(JUnitPlugin.getImageDescriptor("elcl16/stop.gif"));
            this.setImageDescriptor(JUnitPlugin.getImageDescriptor("elcl16/stop.gif"));
        }

        public void run() {
            TestRunnerViewPart.this.stopTest();
            this.setEnabled(false);
        }
    }

    private class RerunLastAction
    extends Action {
        public RerunLastAction() {
            this.setText(JUnitMessages.TestRunnerViewPart_rerunaction_label);
            this.setToolTipText(JUnitMessages.TestRunnerViewPart_rerunaction_tooltip);
            this.setDisabledImageDescriptor(JUnitPlugin.getImageDescriptor("dlcl16/relaunch.gif"));
            this.setHoverImageDescriptor(JUnitPlugin.getImageDescriptor("elcl16/relaunch.gif"));
            this.setImageDescriptor(JUnitPlugin.getImageDescriptor("elcl16/relaunch.gif"));
            this.setEnabled(false);
        }

        public void run() {
            TestRunnerViewPart.this.rerunTestRun();
        }
    }

    private class RerunLastFailedFirstAction
    extends Action {
        public RerunLastFailedFirstAction() {
            this.setText(JUnitMessages.TestRunnerViewPart_rerunfailuresaction_label);
            this.setToolTipText(JUnitMessages.TestRunnerViewPart_rerunfailuresaction_tooltip);
            this.setDisabledImageDescriptor(JUnitPlugin.getImageDescriptor("dlcl16/relaunchf.gif"));
            this.setHoverImageDescriptor(JUnitPlugin.getImageDescriptor("elcl16/relaunchf.gif"));
            this.setImageDescriptor(JUnitPlugin.getImageDescriptor("elcl16/relaunchf.gif"));
            this.setEnabled(false);
        }

        public void run() {
            TestRunnerViewPart.this.rerunTestFailedFirst();
        }
    }

    private class ToggleOrientationAction
    extends Action {
        private final int fActionOrientation;

        public ToggleOrientationAction(TestRunnerViewPart v, int orientation) {
            super("", 8);
            if (orientation == 1) {
                this.setText(JUnitMessages.TestRunnerViewPart_toggle_horizontal_label);
                this.setImageDescriptor(JUnitPlugin.getImageDescriptor("elcl16/th_horizontal.gif"));
            } else if (orientation == 0) {
                this.setText(JUnitMessages.TestRunnerViewPart_toggle_vertical_label);
                this.setImageDescriptor(JUnitPlugin.getImageDescriptor("elcl16/th_vertical.gif"));
            } else if (orientation == 2) {
                this.setText(JUnitMessages.TestRunnerViewPart_toggle_automatic_label);
                this.setImageDescriptor(JUnitPlugin.getImageDescriptor("elcl16/th_automatic.gif"));
            }
            this.fActionOrientation = orientation;
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.junit.results_view_toggle_call_mode_action_context");
        }

        public int getOrientation() {
            return this.fActionOrientation;
        }

        public void run() {
            if (this.isChecked()) {
                TestRunnerViewPart.this.fOrientation = this.fActionOrientation;
                TestRunnerViewPart.this.computeOrientation();
            }
        }
    }

    private class DirtyListener
    implements IElementChangedListener {
        DirtyListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            this.processDelta(event.getDelta());
        }

        private boolean processDelta(IJavaElementDelta delta) {
            int kind = delta.getKind();
            int details = delta.getFlags();
            int type = delta.getElement().getElementType();
            switch (type) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    if (kind == 4 && details == 8) break;
                    TestRunnerViewPart.this.codeHasChanged();
                    return false;
                }
                case 5: {
                    if ((details & 0x10000) != 0) {
                        return true;
                    }
                    TestRunnerViewPart.this.codeHasChanged();
                    return false;
                }
                case 6: {
                    return true;
                }
                default: {
                    TestRunnerViewPart.this.codeHasChanged();
                    return false;
                }
            }
            IJavaElementDelta[] affectedChildren = delta.getAffectedChildren();
            if (affectedChildren == null) {
                return true;
            }
            int i = 0;
            while (i < affectedChildren.length) {
                if (!this.processDelta(affectedChildren[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    private class TreeEntryQueueDrainer
    implements Runnable {
        TreeEntryQueueDrainer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block3: while (true) {
                String treeEntry;
                List list = TestRunnerViewPart.this.fTreeEntryQueue;
                synchronized (list) {
                    if (TestRunnerViewPart.this.fTreeEntryQueue.isEmpty() || TestRunnerViewPart.this.isDisposed()) {
                        TestRunnerViewPart.this.fQueueDrainRequestOutstanding = false;
                        return;
                    }
                    treeEntry = (String)TestRunnerViewPart.this.fTreeEntryQueue.remove(0);
                }
                Enumeration e = TestRunnerViewPart.this.fTestRunTabs.elements();
                while (true) {
                    if (!e.hasMoreElements()) continue block3;
                    TestRunTab v = (TestRunTab)e.nextElement();
                    v.newTreeEntry(treeEntry);
                }
                break;
            }
        }
    }

    private class ActivateOnErrorAction
    extends Action {
        public ActivateOnErrorAction() {
            super(JUnitMessages.TestRunnerViewPart_activate_on_failure_only, 2);
            try {
                this.setImageDescriptor(ImageDescriptor.createFromURL((URL)JUnitPlugin.makeIconFileURL("obj16/failures.gif")));
            }
            catch (MalformedURLException malformedURLException) {}
            this.update();
        }

        public void update() {
            this.setChecked(TestRunnerViewPart.getShowOnErrorOnly());
        }

        public void run() {
            boolean checked;
            TestRunnerViewPart.this.fShowOnErrorOnly = checked = this.isChecked();
            IPreferenceStore store = JUnitPlugin.getDefault().getPreferenceStore();
            store.setValue(JUnitPreferencesConstants.SHOW_ON_ERROR_ONLY, checked);
        }
    }

    class UpdateUIJob
    extends UIJob {
        private boolean fRunning = true;

        public UpdateUIJob(String name) {
            super(name);
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (!TestRunnerViewPart.this.isDisposed()) {
                TestRunnerViewPart.this.doShowStatus();
                TestRunnerViewPart.this.refreshCounters();
            }
            this.schedule(200L);
            return Status.OK_STATUS;
        }

        public void stop() {
            this.fRunning = false;
        }

        public boolean shouldSchedule() {
            return this.fRunning;
        }
    }

    class JUnitIsRunningJob
    extends Job {
        public JUnitIsRunningJob(String name) {
            super(name);
            this.setSystem(true);
        }

        public IStatus run(IProgressMonitor monitor) {
            TestRunnerViewPart.this.fJUnitIsRunningLock.acquire();
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return family == FAMILY_JUNIT_RUN;
        }
    }
}

