/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.osgi.internal.module.BundleConstraint;
import org.eclipse.osgi.internal.module.ResolverExport;
import org.eclipse.osgi.internal.module.ResolverImpl;
import org.eclipse.osgi.internal.module.ResolverImport;
import org.eclipse.osgi.internal.module.VersionSupplier;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.osgi.framework.Version;

public class ResolverBundle
implements VersionSupplier {
    public static final int UNRESOLVED = 0;
    public static final int RESOLVING = 1;
    public static final int RESOLVED = 2;
    private BundleDescription bundle;
    private Long bundleID;
    private BundleConstraint host;
    private ResolverImport[] imports;
    private ResolverExport[] exports;
    private BundleConstraint[] requires;
    private ArrayList fragments;
    private HashMap fragmentExports;
    private HashMap fragmentImports;
    private HashMap fragmentRequires;
    private boolean resolvable = true;
    private int state = 0;
    private ArrayList cyclicDependencies = new ArrayList();
    private ResolverImpl resolver;
    private boolean newFragmentExports;

    ResolverBundle(BundleDescription bundle, ResolverImpl resolver) {
        this.bundle = bundle;
        this.bundleID = new Long(bundle.getBundleId());
        this.resolver = resolver;
        this.initialize(bundle.isResolved());
    }

    void initialize(boolean useSelectedExports) {
        if (this.bundle.getHost() != null) {
            this.host = new BundleConstraint(this, this.bundle.getHost());
            this.exports = new ResolverExport[0];
            this.imports = new ResolverImport[0];
            this.requires = new BundleConstraint[0];
            return;
        }
        ImportPackageSpecification[] actualImports = this.bundle.getImportPackages();
        ArrayList<ResolverImport> importList = new ArrayList<ResolverImport>(actualImports.length);
        int i = actualImports.length - 1;
        while (i >= 0) {
            if ("optional".equals(actualImports[i].getDirective("resolution"))) {
                importList.add(new ResolverImport(this, actualImports[i]));
            } else {
                importList.add(0, new ResolverImport(this, actualImports[i]));
            }
            --i;
        }
        this.imports = importList.toArray(new ResolverImport[importList.size()]);
        ExportPackageDescription[] actualExports = useSelectedExports ? this.bundle.getSelectedExports() : this.bundle.getExportPackages();
        this.exports = new ResolverExport[actualExports.length];
        int i2 = 0;
        while (i2 < actualExports.length) {
            this.exports[i2] = new ResolverExport(this, actualExports[i2]);
            ++i2;
        }
        BundleSpecification[] actualRequires = this.bundle.getRequiredBundles();
        this.requires = new BundleConstraint[actualRequires.length];
        int i3 = 0;
        while (i3 < this.requires.length) {
            this.requires[i3] = new BundleConstraint(this, actualRequires[i3]);
            ++i3;
        }
        this.fragments = null;
        this.fragmentExports = null;
        this.fragmentImports = null;
        this.fragmentRequires = null;
    }

    boolean isExported(ResolverExport exp) {
        ResolverExport[] exports = this.getExportPackages();
        int i = 0;
        while (i < exports.length) {
            if (exp == exports[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    ResolverImport getImport(ResolverExport exp) {
        ResolverImport[] imports = this.getImportPackages();
        int i = 0;
        while (i < imports.length) {
            if (exp.getName().equals(imports[i].getName())) {
                return imports[i];
            }
            ++i;
        }
        return null;
    }

    ResolverExport getExport(ResolverImport imp) {
        ResolverExport[] exports = this.getExportPackages();
        int i = 0;
        while (i < exports.length) {
            if (imp.getName().equals(exports[i].getName()) && exports[i].getExportPackageDescription().isRoot()) {
                return exports[i];
            }
            ++i;
        }
        return null;
    }

    ResolverExport getExport(String name) {
        ResolverExport[] exports = this.getExportPackages();
        int i = 0;
        while (i < exports.length) {
            if (name.equals(exports[i].getName())) {
                return exports[i];
            }
            ++i;
        }
        return null;
    }

    boolean isFullyWired() {
        if (this.host != null && this.host.foundMatchingBundles()) {
            return false;
        }
        ResolverImport[] imports = this.getImportPackages();
        int i = 0;
        while (i < imports.length) {
            if (imports[i].getMatchingExport() == null && !imports[i].isOptional() && !imports[i].isDynamic()) {
                return false;
            }
            ++i;
        }
        BundleConstraint[] requires = this.getRequires();
        int i2 = 0;
        while (i2 < requires.length) {
            if (requires[i2].getMatchingBundle() == null && !requires[i2].isOptional()) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    void clearWires() {
        ResolverImport[] allImports = this.getImportPackages();
        int i = 0;
        while (i < allImports.length) {
            allImports[i].setMatchingExport(null);
            ++i;
        }
        if (this.host != null) {
            this.host.removeAllMatchingBundles();
        }
        BundleConstraint[] allRequires = this.getRequires();
        int i2 = 0;
        while (i2 < allRequires.length) {
            allRequires[i2].setMatchingBundle(null);
            ++i2;
        }
    }

    boolean isResolved() {
        return this.getState() == 2;
    }

    boolean isFragment() {
        return this.host != null;
    }

    int getState() {
        return this.state;
    }

    void setState(int state) {
        this.state = state;
    }

    ResolverImport[] getImportPackages() {
        if (this.isFragment()) {
            return new ResolverImport[0];
        }
        if (this.fragments == null || this.fragments.size() == 0) {
            return this.imports;
        }
        ArrayList<ResolverImport> resultList = new ArrayList<ResolverImport>(this.imports.length);
        int i = 0;
        while (i < this.imports.length) {
            resultList.add(this.imports[i]);
            ++i;
        }
        Iterator iter = this.fragments.iterator();
        while (iter.hasNext()) {
            ResolverBundle fragment = (ResolverBundle)iter.next();
            ArrayList fragImports = (ArrayList)this.fragmentImports.get(fragment.bundleID);
            if (fragImports == null) continue;
            resultList.addAll(fragImports);
        }
        return resultList.toArray(new ResolverImport[resultList.size()]);
    }

    ResolverExport[] getExportPackages() {
        if (this.isFragment()) {
            return new ResolverExport[0];
        }
        if (this.fragments == null || this.fragments.size() == 0) {
            return this.exports;
        }
        ArrayList<ResolverExport> resultList = new ArrayList<ResolverExport>(this.exports.length);
        int i = 0;
        while (i < this.exports.length) {
            resultList.add(this.exports[i]);
            ++i;
        }
        Iterator iter = this.fragments.iterator();
        while (iter.hasNext()) {
            ResolverBundle fragment = (ResolverBundle)iter.next();
            ArrayList fragExports = (ArrayList)this.fragmentExports.get(fragment.bundleID);
            if (fragExports == null) continue;
            resultList.addAll(fragExports);
        }
        return resultList.toArray(new ResolverExport[resultList.size()]);
    }

    ResolverExport[] getSelectedExports() {
        ResolverExport[] exports = this.getExportPackages();
        ArrayList<ResolverExport> removedList = null;
        int i = 0;
        while (i < exports.length) {
            ResolverImport imp = this.getImport(exports[i].getName());
            if (imp != null && imp.getMatchingExport() != exports[i] && exports[i].getExportPackageDescription().isRoot()) {
                if (removedList == null) {
                    removedList = new ArrayList<ResolverExport>(1);
                }
                removedList.add(exports[i]);
            }
            ++i;
        }
        if (removedList == null) {
            return exports;
        }
        ResolverExport[] selectedExports = new ResolverExport[exports.length - removedList.size()];
        ResolverExport[] removedExports = removedList.toArray(new ResolverExport[removedList.size()]);
        int index = 0;
        int i2 = 0;
        while (i2 < exports.length) {
            boolean removed = false;
            int j = 0;
            while (j < removedExports.length) {
                if (exports[i2] == removedExports[j]) {
                    removed = true;
                    break;
                }
                ++j;
            }
            if (!removed) {
                selectedExports[index] = exports[i2];
                ++index;
            }
            ++i2;
        }
        return selectedExports;
    }

    BundleConstraint getHost() {
        return this.host;
    }

    BundleConstraint[] getRequires() {
        if (this.isFragment()) {
            return new BundleConstraint[0];
        }
        if (this.fragments == null || this.fragments.size() == 0) {
            return this.requires;
        }
        ArrayList<BundleConstraint> resultList = new ArrayList<BundleConstraint>(this.requires.length);
        int i = 0;
        while (i < this.requires.length) {
            resultList.add(this.requires[i]);
            ++i;
        }
        Iterator iter = this.fragments.iterator();
        while (iter.hasNext()) {
            ResolverBundle fragment = (ResolverBundle)iter.next();
            ArrayList fragRequires = (ArrayList)this.fragmentRequires.get(fragment.bundleID);
            if (fragRequires == null) continue;
            resultList.addAll(fragRequires);
        }
        return resultList.toArray(new BundleConstraint[resultList.size()]);
    }

    BundleConstraint getRequire(String name) {
        BundleConstraint[] requires = this.getRequires();
        int i = 0;
        while (i < requires.length) {
            if (requires[i].getVersionConstraint().getName().equals(name)) {
                return requires[i];
            }
            ++i;
        }
        return null;
    }

    boolean isDependentOnCycle() {
        return this.cyclicDependencies.size() > 0;
    }

    void recordCyclicDependency(ResolverBundle dependentOn) {
        if (!this.cyclicDependencies.contains(dependentOn)) {
            this.cyclicDependencies.add(dependentOn);
        }
    }

    ArrayList getCyclicDependencies() {
        return this.cyclicDependencies;
    }

    boolean cyclicDependencyResolved(ResolverBundle dependentOn) {
        int i = 0;
        while (i < this.cyclicDependencies.size()) {
            if (dependentOn == this.cyclicDependencies.get(i)) {
                this.cyclicDependencies.remove(i);
            }
            ++i;
        }
        return !this.isDependentOnCycle();
    }

    void cyclicDependencyFailed(ResolverBundle dependentOn) {
        this.cyclicDependencies = new ArrayList();
        this.detachAllFragments();
        ResolverImport[] imports = this.getImportPackages();
        int i = 0;
        while (i < imports.length) {
            imports[i].clearUnresolvableWirings();
            ++i;
        }
    }

    public BundleDescription getBundle() {
        return this.bundle;
    }

    ResolverImport getImport(String name) {
        ResolverImport[] imports = this.getImportPackages();
        int i = 0;
        while (i < imports.length) {
            if (imports[i].getName().equals(name)) {
                return imports[i];
            }
            ++i;
        }
        return null;
    }

    public String toString() {
        return "[" + this.bundle + "]";
    }

    public Version getVersion() {
        return this.bundle.getVersion();
    }

    public String getName() {
        return this.bundle.getName();
    }

    private void initFragments() {
        if (this.fragments == null) {
            this.fragments = new ArrayList(1);
        }
        if (this.fragmentExports == null) {
            this.fragmentExports = new HashMap(1);
        }
        if (this.fragmentImports == null) {
            this.fragmentImports = new HashMap(1);
        }
        if (this.fragmentRequires == null) {
            this.fragmentRequires = new HashMap(1);
        }
    }

    private boolean isImported(String packageName) {
        ResolverImport[] imports = this.getImportPackages();
        int i = 0;
        while (i < imports.length) {
            if (packageName.equals(imports[i].getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isExported(String packageName) {
        ResolverExport[] exports = this.getExportPackages();
        int i = 0;
        while (i < exports.length) {
            if (packageName.equals(exports[i].getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isRequired(String bundleName) {
        BundleConstraint[] requires = this.getRequires();
        int i = 0;
        while (i < requires.length) {
            if (bundleName.equals(requires[i].getVersionConstraint().getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    ResolverExport[] attachFragment(ResolverBundle fragment, boolean addExports) {
        int i;
        if (this.isFragment()) {
            return new ResolverExport[0];
        }
        if (!this.bundle.attachFragments() || this.isResolved() && !this.bundle.dynamicFragments()) {
            return new ResolverExport[0];
        }
        if (fragment.getHost().getMatchingBundles() != null && !((HostSpecification)fragment.getHost().getVersionConstraint()).isMultiHost()) {
            return new ResolverExport[0];
        }
        ImportPackageSpecification[] newImports = fragment.getBundle().getImportPackages();
        BundleSpecification[] newRequires = fragment.getBundle().getRequiredBundles();
        ExportPackageDescription[] newExports = fragment.getBundle().getExportPackages();
        if (this.constraintsConflict(newImports, newRequires)) {
            return new ResolverExport[0];
        }
        if (this.isResolved() && newExports.length > 0) {
            fragment.setNewFragmentExports(true);
        }
        this.initFragments();
        if (this.fragments.contains(fragment)) {
            return new ResolverExport[0];
        }
        this.fragments.add(fragment);
        fragment.getHost().addMatchingBundle(this);
        if (newImports.length > 0) {
            ArrayList<ResolverImport> hostImports = new ArrayList<ResolverImport>(newImports.length);
            i = 0;
            while (i < newImports.length) {
                if (!this.isImported(newImports[i].getName())) {
                    hostImports.add(new ResolverImport(this, newImports[i]));
                }
                ++i;
            }
            this.fragmentImports.put(fragment.bundleID, hostImports);
        }
        if (newRequires.length > 0) {
            ArrayList<BundleConstraint> hostRequires = new ArrayList<BundleConstraint>(newRequires.length);
            i = 0;
            while (i < newRequires.length) {
                if (!this.isRequired(newRequires[i].getName())) {
                    hostRequires.add(new BundleConstraint(this, newRequires[i]));
                }
                ++i;
            }
            this.fragmentRequires.put(fragment.bundleID, hostRequires);
        }
        ArrayList<ResolverExport> hostExports = new ArrayList<ResolverExport>(newExports.length);
        if (newExports.length > 0 && addExports) {
            StateObjectFactory factory = this.resolver.getState().getFactory();
            int i2 = 0;
            while (i2 < newExports.length) {
                if (!this.isExported(newExports[i2].getName())) {
                    ExportPackageDescription hostExport = factory.createExportPackageDescription(newExports[i2].getName(), newExports[i2].getVersion(), newExports[i2].getDirectives(), newExports[i2].getAttributes(), newExports[i2].isRoot(), this.bundle);
                    hostExports.add(new ResolverExport(this, hostExport));
                }
                ++i2;
            }
            this.fragmentExports.put(fragment.bundleID, hostExports);
        }
        return hostExports.toArray(new ResolverExport[hostExports.size()]);
    }

    private boolean constraintsConflict(ImportPackageSpecification[] newImports, BundleSpecification[] newRequires) {
        int i = 0;
        while (i < newImports.length) {
            ResolverImport importPkg = this.getImport(newImports[i].getName());
            if (importPkg == null && this.isResolved()) {
                return true;
            }
            if (importPkg != null && !newImports[i].getVersionRange().equals(importPkg.getImportPackageSpecification().getVersionRange())) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < newRequires.length) {
            BundleConstraint constraint = this.getRequire(newRequires[i].getName());
            if (constraint == null && this.isResolved()) {
                return true;
            }
            if (constraint != null && !newRequires[i].getVersionRange().equals(constraint.getVersionConstraint().getVersionRange())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void setNewFragmentExports(boolean newFragmentExports) {
        this.newFragmentExports = newFragmentExports;
    }

    boolean isNewFragmentExports() {
        return this.newFragmentExports;
    }

    ResolverExport[] detachFragment(ResolverBundle fragment) {
        if (this.isFragment()) {
            return new ResolverExport[0];
        }
        this.initFragments();
        if (!this.fragments.remove(fragment)) {
            return new ResolverExport[0];
        }
        fragment.getHost().removeMatchingBundle(this);
        this.fragmentImports.remove(fragment.bundleID);
        this.fragmentRequires.remove(fragment.bundleID);
        ArrayList removedExports = (ArrayList)this.fragmentExports.remove(fragment.bundleID);
        return removedExports == null ? new ResolverExport[]{} : removedExports.toArray(new ResolverExport[removedExports.size()]);
    }

    void detachAllFragments() {
        if (this.fragments == null) {
            return;
        }
        ResolverBundle[] allFragments = this.fragments.toArray(new ResolverBundle[this.fragments.size()]);
        int i = 0;
        while (i < allFragments.length) {
            this.detachFragment(allFragments[i]);
            ++i;
        }
    }

    boolean isDependentOnUnresolvedFragment(ResolverBundle dependent) {
        ResolverImport[] imports = dependent.getImportPackages();
        int i = 0;
        while (i < imports.length) {
            ResolverExport exp = imports[i].getMatchingExport();
            if (exp != null && exp.getExporter() == this && !this.isExported(exp)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean isResolvable() {
        return this.resolvable;
    }

    void setResolvable(boolean resolvable) {
        this.resolvable = resolvable;
    }

    void addExport(ResolverExport re) {
        ResolverExport[] newExports = new ResolverExport[this.exports.length + 1];
        int i = 0;
        while (i < this.exports.length) {
            newExports[i] = this.exports[i];
            ++i;
        }
        newExports[this.exports.length] = re;
        this.exports = newExports;
    }

    ResolverImpl getResolver() {
        return this.resolver;
    }
}

