/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.part.services;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.SubCoolBarManager;
import org.eclipse.jface.action.SubMenuManager;
import org.eclipse.jface.action.SubToolBarManager;
import org.eclipse.ui.internal.components.framework.ComponentException;
import org.eclipse.ui.internal.components.framework.IDisposable;
import org.eclipse.ui.internal.components.framework.IServiceProvider;
import org.eclipse.ui.internal.part.Part;
import org.eclipse.ui.internal.part.components.services.IPartActionBars;
import org.eclipse.ui.internal.part.multiplexer.INestedComponent;
import org.eclipse.ui.internal.part.multiplexer.ISharedContext;

public class ChildPartActionBars
implements IPartActionBars,
INestedComponent,
IDisposable {
    private IPartActionBars parent;
    private Map actionHandlers;
    private boolean active = false;
    private IMenuManager partMenuMgr;
    private IMenuManager menuBarMgr;
    private SubToolBarManager toolBarMgr;
    private SubCoolBarManager subCbm;
    static /* synthetic */ Class class$0;

    public ChildPartActionBars(IServiceProvider childContainer, ISharedContext shared) throws ComponentException {
        IServiceProvider sharedContainer = shared.getSharedComponents();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.internal.part.components.services.IPartActionBars");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.parent = (IPartActionBars)sharedContainer.getService(clazz);
    }

    public void clearGlobalActionHandlers() {
        if (this.actionHandlers != null) {
            if (this.active) {
                this.unregisterAllHandlers();
            }
            this.actionHandlers.clear();
        }
    }

    private void unregisterAllHandlers() {
        Set keySet = this.actionHandlers.keySet();
        Iterator iter = keySet.iterator();
        while (iter.hasNext()) {
            String handler = (String)iter.next();
            this.parent.setGlobalActionHandler(handler, null);
        }
    }

    private void registerAllHandlers() {
        Set keySet = this.actionHandlers.keySet();
        Iterator iter = keySet.iterator();
        while (iter.hasNext()) {
            String handler = (String)iter.next();
            this.parent.setGlobalActionHandler(handler, (IAction)this.actionHandlers.get(handler));
        }
    }

    public IAction getGlobalActionHandler(String actionId) {
        if (this.actionHandlers == null) {
            return null;
        }
        return (IAction)this.actionHandlers.get(actionId);
    }

    protected SubMenuManager createSubMenuManager(IMenuManager parent) {
        return new SubMenuManager(parent);
    }

    public IMenuManager getPartMenuManager() {
        if (this.partMenuMgr == null) {
            this.partMenuMgr = this.createSubMenuManager(this.parent.getPartMenuManager());
            this.partMenuMgr.setVisible(this.active);
        }
        return this.partMenuMgr;
    }

    public IMenuManager getMenuBarManager() {
        if (this.menuBarMgr == null) {
            this.menuBarMgr = this.createSubMenuManager(this.parent.getPartMenuManager());
            this.menuBarMgr.setVisible(this.active);
        }
        return this.menuBarMgr;
    }

    protected SubToolBarManager createSubToolBarManager(IToolBarManager parent) {
        return new SubToolBarManager(parent);
    }

    public IToolBarManager getToolBarManager() {
        if (this.toolBarMgr == null) {
            this.toolBarMgr = this.createSubToolBarManager(this.parent.getToolBarManager());
            this.toolBarMgr.setVisible(this.active);
        }
        return this.toolBarMgr;
    }

    public ICoolBarManager getCoolBarManager() {
        if (this.subCbm == null) {
            this.subCbm = new SubCoolBarManager(this.parent.getCoolBarManager());
            this.subCbm.setVisible(this.active);
        }
        return this.subCbm;
    }

    public void setGlobalActionHandler(String actionID, IAction handler) {
        if (handler != null) {
            if (this.actionHandlers == null) {
                this.actionHandlers = new HashMap(11);
            }
            this.actionHandlers.put(actionID, handler);
        } else if (this.actionHandlers != null) {
            this.actionHandlers.remove(actionID);
        }
        if (this.active) {
            this.parent.setGlobalActionHandler(actionID, handler);
        }
    }

    public void updateActionBars() {
        if (this.active) {
            this.parent.updateActionBars();
        }
    }

    public void activate(Part newActivePart) {
        this.setActive(true);
    }

    public void deactivate(Object newActive) {
        this.setActive(false);
    }

    private void setActive(boolean isActive) {
        if (isActive == this.active) {
            return;
        }
        this.active = isActive;
        if (this.partMenuMgr != null) {
            this.partMenuMgr.setVisible(isActive);
        }
        if (this.menuBarMgr != null) {
            this.menuBarMgr.setVisible(isActive);
        }
        if (this.toolBarMgr != null) {
            this.toolBarMgr.setVisible(isActive);
        }
        if (this.actionHandlers != null) {
            if (this.active) {
                this.registerAllHandlers();
            } else {
                this.unregisterAllHandlers();
            }
            this.parent.updateActionBars();
        }
        if (this.subCbm != null) {
            this.subCbm.setVisible(isActive);
        }
    }

    public void dispose() {
        if (this.actionHandlers != null) {
            this.actionHandlers.clear();
        }
    }
}

