/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.PatternFilter;
import org.eclipse.ui.internal.dialogs.PreferenceNodeFilter;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.WorkbenchJob;

public class FilteredTree
extends Composite {
    private Text filterText;
    private ToolBarManager filterToolBar;
    private TreeViewer treeViewer;
    private Composite filterParent;
    private PatternFilter patternFilter;
    private PreferenceNodeFilter preferenceFilter;
    private FocusListener listener;
    private static final String CLEAR_ICON = "org.eclipse.ui.internal.dialogs.CLEAR_ICON";
    private static final String DCLEAR_ICON = "org.eclipse.ui.internal.dialogs.DCLEAR_ICON";
    protected String initialText = "";
    private String cachedTitle;
    private Job refreshJob;

    static {
        ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin("org.eclipse.ui", "$nl$/icons/full/etool16/clear_co.gif");
        if (descriptor != null) {
            JFaceResources.getImageRegistry().put(CLEAR_ICON, descriptor);
        }
        if ((descriptor = AbstractUIPlugin.imageDescriptorFromPlugin("org.eclipse.ui", "$nl$/icons/full/dtool16/clear_co.gif")) != null) {
            JFaceResources.getImageRegistry().put(DCLEAR_ICON, descriptor);
        }
    }

    public FilteredTree(Composite parent, int treeStyle) {
        this(parent, treeStyle, new PatternFilter());
    }

    public FilteredTree(Composite parent, int treeStyle, PatternFilter filter) {
        super(parent, 0);
        this.patternFilter = filter;
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.filterParent = new Composite((Composite)this, 0);
        GridLayout filterLayout = new GridLayout();
        filterLayout.numColumns = 2;
        filterLayout.marginHeight = 0;
        filterLayout.marginWidth = 0;
        this.filterParent.setLayout((Layout)filterLayout);
        this.filterParent.setFont(parent.getFont());
        this.filterParent.setLayoutData((Object)new GridData(768));
        this.createFilterControl(this.filterParent);
        this.getFilterControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    if (!(FilteredTree.this.getFilterControl() instanceof Combo)) {
                        FilteredTree.this.treeViewer.getTree().setFocus();
                    }
                } else {
                    FilteredTree.this.textChanged();
                }
            }
        });
        GridData data = new GridData(768);
        this.getFilterControl().setLayoutData((Object)data);
        ToolBar toolBar = new ToolBar(this.filterParent, 0x800100);
        this.filterToolBar = new ToolBarManager(toolBar);
        this.createClearText(this.filterToolBar);
        this.filterToolBar.update(false);
        this.filterToolBar.getControl().setVisible(false);
        this.treeViewer = new TreeViewer((Composite)this, treeStyle);
        data = new GridData(1808);
        this.treeViewer.getControl().setLayoutData((Object)data);
        this.treeViewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FilteredTree.this.refreshJob.cancel();
            }
        });
        this.treeViewer.addFilter((ViewerFilter)this.patternFilter);
        this.createRefreshJob();
    }

    private void createRefreshJob() {
        this.refreshJob = new WorkbenchJob("Refresh Filter"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                boolean initial;
                if (FilteredTree.this.treeViewer.getControl().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                String filterText = FilteredTree.this.getFilterControlText();
                boolean bl = initial = FilteredTree.this.initialText != null && filterText.equals(FilteredTree.this.initialText);
                if (initial) {
                    FilteredTree.this.patternFilter.setPattern(null);
                } else {
                    FilteredTree.this.patternFilter.setPattern(FilteredTree.this.getFilterControlText());
                }
                FilteredTree.this.treeViewer.getControl().setRedraw(false);
                FilteredTree.this.treeViewer.refresh(true);
                FilteredTree.this.treeViewer.getControl().setRedraw(true);
                if (filterText.length() > 0 && !initial) {
                    FilteredTree.this.treeViewer.expandAll();
                    FilteredTree.this.filterToolBar.getControl().setVisible(true);
                } else {
                    FilteredTree.this.filterToolBar.getControl().setVisible(FilteredTree.this.preferenceFilter != null);
                }
                return Status.OK_STATUS;
            }
        };
        this.refreshJob.setSystem(true);
    }

    protected void createFilterControl(Composite parent) {
        this.filterText = new Text(parent, 2052);
        this.filterText.getAccessible().addAccessibleListener((AccessibleListener)this.getAccessibleListener());
    }

    protected AccessibleAdapter getAccessibleListener() {
        return new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                String filterTextString = FilteredTree.this.getFilterText();
                e.result = filterTextString.length() == 0 ? FilteredTree.this.initialText : filterTextString;
            }
        };
    }

    protected String getFilterText() {
        return this.filterText.getText();
    }

    protected void textChanged() {
        this.refreshJob.schedule(200L);
    }

    protected String getFilterControlText() {
        return this.filterText.getText();
    }

    public void setBackground(Color background) {
        super.setBackground(background);
        this.filterParent.setBackground(background);
        this.getFilterControl().setBackground(background);
        this.filterToolBar.getControl().setBackground(background);
    }

    private void createClearText(ToolBarManager filterToolBar) {
        Action clearTextAction = new Action("", 1){

            public void run() {
                FilteredTree.this.clearText();
            }
        };
        clearTextAction.setToolTipText(WorkbenchMessages.FilteredTree_ClearToolTip);
        clearTextAction.setImageDescriptor(JFaceResources.getImageRegistry().getDescriptor(CLEAR_ICON));
        clearTextAction.setDisabledImageDescriptor(JFaceResources.getImageRegistry().getDescriptor(DCLEAR_ICON));
        filterToolBar.add((IAction)clearTextAction);
    }

    protected void clearText() {
        this.setFilterText("");
        if (this.preferenceFilter != null) {
            this.getViewer().removeFilter((ViewerFilter)this.preferenceFilter);
            this.preferenceFilter = null;
            this.getShell().setText(this.cachedTitle);
        }
        this.textChanged();
    }

    protected void setFilterText(String string) {
        this.filterText.setText(string);
        this.selectAll();
    }

    public TreeViewer getViewer() {
        return this.treeViewer;
    }

    public Control getFilterControl() {
        return this.filterText;
    }

    public void setInitialText(String text) {
        this.initialText = text;
        this.setFilterText(this.initialText);
        this.textChanged();
        this.listener = new FocusListener(){

            public void focusGained(FocusEvent event) {
                FilteredTree.this.selectAll();
                FilteredTree.this.getFilterControl().removeFocusListener(FilteredTree.this.listener);
            }

            public void focusLost(FocusEvent e) {
            }
        };
        this.getFilterControl().addFocusListener(this.listener);
    }

    protected void selectAll() {
        this.filterText.selectAll();
    }

    protected String getInitialText() {
        return this.initialText;
    }

    public void addFilter(PreferenceNodeFilter filter) {
        this.preferenceFilter = filter;
        this.getViewer().addFilter((ViewerFilter)filter);
        this.setInitialText(WorkbenchMessages.FilteredTree_FilteredMessage);
        if (this.getFilterControl() != null) {
            this.setFilterText(WorkbenchMessages.FilteredTree_FilteredMessage);
            this.textChanged();
        }
        this.cachedTitle = this.getShell().getText();
        this.getShell().setText(NLS.bind((String)WorkbenchMessages.FilteredTree_FilteredDialogTitle, (Object)this.cachedTitle));
    }
}

