/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.components.registry;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.internal.components.ExecutableExtensionFactory;
import org.eclipse.ui.internal.components.framework.ClassIdentifier;
import org.eclipse.ui.internal.components.registry.ComponentRegistry;
import org.eclipse.ui.internal.components.registry.ExtensionPointManager;
import org.eclipse.ui.internal.components.registry.IExtensionPointMonitor;
import org.eclipse.ui.internal.components.registry.ScopeDefinition;
import org.eclipse.ui.internal.components.registry.SymbolicScopeReference;

public class ServiceExtensionPoint {
    private static final String ATT_IMPLEMENTATION = "class";
    private static final String ATT_COMPONENT = "component";
    private static final String ATT_INTERFACE = "interface";
    private static final String ATT_INTERFACES = "services";
    private IExtensionPointMonitor extensionPointMonitor = new IExtensionPointMonitor(){

        public void added(IExtension newExtension) {
            ServiceExtensionPoint.this.processExtension(newExtension, true);
        }

        public void removed(IExtension oldExtension) {
            ServiceExtensionPoint.this.processExtension(oldExtension, false);
        }
    };
    private Map services = new HashMap();
    private ComponentRegistry registry;
    private ExtensionPointManager manager;

    public ServiceExtensionPoint(ExtensionPointManager manager, ComponentRegistry scope) {
        this.manager = manager;
        this.registry = scope;
        manager.addMonitor(ATT_INTERFACES, this.extensionPointMonitor);
    }

    public void dispose() {
        this.manager.removeMonitor(ATT_INTERFACES, this.extensionPointMonitor);
    }

    private ClassIdentifier getType(IConfigurationElement element, String attributeName) {
        return new ClassIdentifier(element.getNamespace(), element.getAttribute(attributeName));
    }

    private void processExtension(IExtension extension, boolean added) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (element.getName().equals(ATT_COMPONENT)) {
                this.getType(element, ATT_IMPLEMENTATION);
                ClassIdentifier interfaceName = this.getType(element, ATT_INTERFACE);
                String scopeId = element.getAttribute("scope");
                new Path(scopeId);
                if (added) {
                    ExecutableExtensionFactory factory = new ExecutableExtensionFactory(element, ATT_IMPLEMENTATION);
                    this.registry.addType(scopeId, interfaceName, factory);
                } else {
                    this.registry.removeType(scopeId, interfaceName);
                }
            } else if (element.getName().equals("scope")) {
                String id = element.getAttribute("id");
                if (added) {
                    ScopeDefinition def = new ScopeDefinition();
                    IConfigurationElement[] children = element.getChildren();
                    int j = 0;
                    while (j < children.length) {
                        String scopeName;
                        IConfigurationElement child = children[j];
                        String name = child.getName();
                        if (name.equals("requiresScope")) {
                            scopeName = child.getAttribute("id");
                            def.addExtends(new SymbolicScopeReference(scopeName, 0));
                        } else if (name.equals("extendsScope")) {
                            scopeName = child.getAttribute("id");
                            def.addExtends(new SymbolicScopeReference(scopeName, 0));
                        } else if (name.equals("requiresInterface")) {
                            String typeName = child.getAttribute("id");
                            def.addDependency(new ClassIdentifier(extension.getNamespace(), typeName));
                        }
                        ++j;
                    }
                    this.registry.loadScope(id, def);
                } else {
                    this.registry.unloadScope(id);
                }
            }
            ++i;
        }
    }
}

