/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.AbstractSourceProvider;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.contexts.IContextService;

public final class ActiveShellSourceProvider
extends AbstractSourceProvider {
    private final Display display;
    private Shell lastActiveShell = null;
    private Shell lastActiveWorkbenchWindow = null;
    private final Listener listener = new Listener(){

        public final void handleEvent(Event event) {
            boolean windowChanged;
            if (!(event.widget instanceof Shell)) {
                return;
            }
            Map currentState = ActiveShellSourceProvider.this.getCurrentState();
            Shell newActiveShell = (Shell)currentState.get("activeShell");
            Shell newActiveWorkbenchWindowShell = (Shell)currentState.get("activeWorkbenchWindow");
            boolean shellChanged = newActiveShell != ActiveShellSourceProvider.this.lastActiveShell;
            boolean bl = windowChanged = newActiveWorkbenchWindowShell != ActiveShellSourceProvider.this.lastActiveWorkbenchWindow;
            if (shellChanged && windowChanged) {
                HashMap<String, Shell> sourceValuesByName = new HashMap<String, Shell>(4);
                sourceValuesByName.put("activeShell", newActiveShell);
                sourceValuesByName.put("activeWorkbenchWindow", newActiveWorkbenchWindowShell);
                ActiveShellSourceProvider.this.fireSourceChanged(17408, sourceValuesByName);
            } else if (shellChanged) {
                ActiveShellSourceProvider.this.fireSourceChanged(1024, "activeShell", newActiveShell);
            } else if (windowChanged) {
                ActiveShellSourceProvider.this.fireSourceChanged(16384, "activeWorkbenchWindow", newActiveWorkbenchWindowShell);
            }
            ActiveShellSourceProvider.this.lastActiveShell = newActiveShell;
            ActiveShellSourceProvider.this.lastActiveWorkbenchWindow = newActiveWorkbenchWindowShell;
        }
    };
    private final IWorkbench workbench;
    static /* synthetic */ Class class$0;

    public ActiveShellSourceProvider(IWorkbench workbench) {
        this.workbench = workbench;
        this.display = workbench.getDisplay();
        this.display.addFilter(26, this.listener);
    }

    public final void dispose() {
        this.display.removeFilter(26, this.listener);
    }

    public final Map getCurrentState() {
        IContextService contextService;
        int shellType;
        HashMap<String, Shell> currentState = new HashMap<String, Shell>(4);
        Shell newActiveShell = this.display.getActiveShell();
        currentState.put("activeShell", newActiveShell);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.contexts.IContextService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((shellType = (contextService = (IContextService)this.workbench.getAdapter(clazz)).getShellType(newActiveShell)) != 0) {
            IWorkbenchWindow newActiveWorkbenchWindow = this.workbench.getActiveWorkbenchWindow();
            Shell newActiveWorkbenchWindowShell = newActiveWorkbenchWindow == null ? null : newActiveWorkbenchWindow.getShell();
            currentState.put("activeWorkbenchWindow", newActiveWorkbenchWindowShell);
        }
        return currentState;
    }
}

