/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ui.AbstractSourceProvider;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.util.Util;

public class ActivePartSourceProvider
extends AbstractSourceProvider {
    private String lastActivePartId = null;
    private IWorkbenchPartSite lastActivePartSite = null;
    private final IPartListener partListener = new IPartListener(){

        public final void partActivated(IWorkbenchPart part) {
            ActivePartSourceProvider.this.checkActivePart();
        }

        public final void partBroughtToTop(IWorkbenchPart part) {
            ActivePartSourceProvider.this.checkActivePart();
        }

        public final void partClosed(IWorkbenchPart part) {
            ActivePartSourceProvider.this.checkActivePart();
        }

        public final void partDeactivated(IWorkbenchPart part) {
            ActivePartSourceProvider.this.checkActivePart();
        }

        public final void partOpened(IWorkbenchPart part) {
            ActivePartSourceProvider.this.checkActivePart();
        }
    };
    private final IWindowListener windowListener = new IWindowListener(){

        public final void windowActivated(IWorkbenchWindow window) {
            if (window != null) {
                window.getPartService().addPartListener(ActivePartSourceProvider.this.partListener);
            }
            ActivePartSourceProvider.this.checkActivePart();
        }

        public final void windowClosed(IWorkbenchWindow window) {
            if (window != null) {
                window.getPartService().removePartListener(ActivePartSourceProvider.this.partListener);
            }
            ActivePartSourceProvider.this.checkActivePart();
        }

        public final void windowDeactivated(IWorkbenchWindow window) {
            if (window != null) {
                window.getPartService().removePartListener(ActivePartSourceProvider.this.partListener);
            }
            ActivePartSourceProvider.this.checkActivePart();
        }

        public final void windowOpened(IWorkbenchWindow window) {
            if (window != null) {
                window.getPartService().addPartListener(ActivePartSourceProvider.this.partListener);
            }
            ActivePartSourceProvider.this.checkActivePart();
        }
    };
    private final IWorkbench workbench;

    public ActivePartSourceProvider(IWorkbench workbench) {
        this.workbench = workbench;
        workbench.addWindowListener(this.windowListener);
    }

    private final void checkActivePart() {
        Object newActivePartSite;
        Map currentState = this.getCurrentState();
        int sources = 0;
        Object newActivePartId = currentState.get("activePartId");
        if (!Util.equals(newActivePartId, this.lastActivePartId)) {
            sources |= 0x400000;
            this.lastActivePartId = (String)newActivePartId;
        }
        if (!Util.equals(newActivePartSite = currentState.get("activeSite"), this.lastActivePartSite)) {
            sources |= 0x4000000;
            this.lastActivePartSite = (IWorkbenchPartSite)newActivePartSite;
        }
        if (sources != 0) {
            this.fireSourceChanged(sources, currentState);
        }
    }

    public final void dispose() {
        this.workbench.removeWindowListener(this.windowListener);
    }

    public final Map getCurrentState() {
        IWorkbenchPart activeWorkbenchPart;
        IWorkbenchPage activeWorkbenchPage;
        HashMap<String, Object> currentState = new HashMap<String, Object>(4);
        currentState.put("activeSite", null);
        currentState.put("activePartId", null);
        IWorkbenchWindow activeWorkbenchWindow = this.workbench.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null && (activeWorkbenchPage = activeWorkbenchWindow.getActivePage()) != null && (activeWorkbenchPart = activeWorkbenchPage.getActivePart()) != null) {
            IWorkbenchPartSite activeWorkbenchPartSite = activeWorkbenchPart.getSite();
            currentState.put("activeSite", activeWorkbenchPartSite);
            if (activeWorkbenchPartSite != null) {
                String newActivePartId = activeWorkbenchPartSite.getId();
                currentState.put("activePartId", newActivePartId);
            }
        }
        return currentState;
    }
}

