/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.internal.operation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.uml2.NamedElement;
import org.eclipse.uml2.Namespace;
import org.eclipse.uml2.UML2Package;
import org.eclipse.uml2.UML2Plugin;
import org.eclipse.uml2.internal.operation.UML2Operations;

public final class NamedElementOperations
extends UML2Operations {
    private NamedElementOperations() {
    }

    public static List allNamespaces(NamedElement namedElement) {
        ArrayList<Namespace> allNamespaces = new ArrayList<Namespace>();
        if (namedElement.getNamespace() != null) {
            allNamespaces.addAll(namedElement.getNamespace().allNamespaces());
            allNamespaces.add(0, namedElement.getNamespace());
        }
        return allNamespaces;
    }

    public static boolean isDistinguishableFrom(NamedElement namedElement, NamedElement n, Namespace ns) {
        if (n.eClass().isSuperTypeOf(namedElement.eClass()) || namedElement.eClass().isSuperTypeOf(n.eClass())) {
            Iterator namesOfMember = ns.getNamesOfMember(namedElement).iterator();
            while (namesOfMember.hasNext()) {
                if (!ns.getNamesOfMember(n).contains(namesOfMember.next())) continue;
                return false;
            }
        }
        return true;
    }

    public static String qualifiedName(NamedElement namedElement) {
        if (UML2Operations.isEmpty(namedElement.getName())) {
            return "";
        }
        String qualifiedName = namedElement.getName();
        Iterator allNamespaces = namedElement.allNamespaces().iterator();
        while (allNamespaces.hasNext()) {
            Namespace namespace = (Namespace)allNamespaces.next();
            if (UML2Operations.isEmpty(namespace.getName())) {
                return "";
            }
            qualifiedName = String.valueOf(namespace.getName()) + namedElement.separator() + qualifiedName;
        }
        return qualifiedName;
    }

    public static String separator(NamedElement namedElement) {
        return "::";
    }

    public static boolean validateNoName(NamedElement namedElement, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        if (UML2Operations.isEmpty(namedElement.getName())) {
            result = UML2Operations.isEmpty(namedElement.qualifiedName());
        } else {
            Iterator allNamespaces = namedElement.allNamespaces().iterator();
            while (allNamespaces.hasNext()) {
                if (!UML2Operations.isEmpty(((Namespace)allNamespaces.next()).getName())) continue;
                result = UML2Operations.isEmpty(namedElement.qualifiedName());
                break;
            }
        }
        if (!result && diagnostics != null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.uml2", 8, UML2Plugin.INSTANCE.getString("_UI_NamedElement_NoName_diagnostic", UML2Operations.getMessageSubstitutions(context, namedElement)), new Object[]{namedElement}));
        }
        return result;
    }

    public static boolean validateQualifiedName(NamedElement namedElement, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        if (!UML2Operations.isEmpty(namedElement.getName())) {
            StringBuffer qualifiedName = new StringBuffer(namedElement.getName());
            Iterator allNamespaces = namedElement.allNamespaces().iterator();
            while (allNamespaces.hasNext()) {
                Namespace namespace = (Namespace)allNamespaces.next();
                if (UML2Operations.isEmpty(namespace.getName())) {
                    return result;
                }
                qualifiedName.insert(0, namedElement.separator());
                qualifiedName.insert(0, namespace.getName());
            }
            if (!qualifiedName.toString().equals(namedElement.qualifiedName())) {
                result = false;
                if (diagnostics != null) {
                    diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.uml2", 8, UML2Plugin.INSTANCE.getString("_UI_NamedElement_QualifiedName_diagnostic", UML2Operations.getMessageSubstitutions(context, namedElement)), new Object[]{namedElement}));
                }
            }
        }
        return result;
    }

    public static boolean validateVisibilityNeedsOwnership(NamedElement namedElement, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        if (namedElement.getNamespace() == null && namedElement.eIsSet((EStructuralFeature)UML2Package.eINSTANCE.getNamedElement_Visibility())) {
            result = false;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2", 10, UML2Plugin.INSTANCE.getString("_UI_NamedElement_VisibilityNeedsOwnership_diagnostic", UML2Operations.getMessageSubstitutions(context, namedElement)), new Object[]{namedElement}));
            }
        }
        return result;
    }
}

