;;; latin-euro-latin8.el --- Define language environment -*- coding: iso-2022-8 -*-

;; Copyright (C) 2002 Free Software Foundation, Inc

;; Author: Stephen J. Turnbull
;; Keywords: mule, charsets
;; Created: 2002 October 24 (as latin-unity-latin8.el)
;; Last-modified: 2005 February 7

;; This file is part of XEmacs.

;; XEmacs is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; XEmacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with XEmacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.


;;; Commentary:

;; Provides the latin-8 language environment, character set and coding
;; system.

;;; Code:

;; define ISO-8859-14 for XEmacs 21.4 and earlier
;;;###autoload
(unless (find-charset 'latin-iso8859-14)
  ;; Create character set
  (make-charset
   'latin-iso8859-14 "ISO8859-14 (Latin 8)"
   ;; sheesh, what we do for backward compatibility
   ;; #### this test and the similar one below probably should be
   ;; reformulated to use condition-case
   (append (if (emacs-version>= 21 4)
	       '(short-name "Latin-8"
		 long-name "ISO8859-16 (Latin 8)")
	     nil)
	   '(registry "iso8859-14"
	     dimension 1
	     columns 1
	     chars 96
	     final ?_			; octet 05/15; cf ISO-IR 199
	     graphic 1
	     direction l2r)))
  ;; For syntax of Latin-8 characters.
  (require 'cl)
  (load "cl-macs" nil t)
  (loop for c from 32 to 127
    do (modify-syntax-entry (make-char 'latin-iso8859-14 c) "w"))
  (mapc (lambda (c)
	  (modify-syntax-entry (make-char 'latin-iso8859-14 c) "_"))
	'(#xA3 #xA7 #xA9 #xAD #xAE #xB6))
  )

;;;###autoload
(unless (find-coding-system 'iso-8859-14)
  ;; Create coding system
  (make-coding-system
   'iso-8859-14 'iso2022 "MIME ISO-8859-14"
   '(charset-g0 ascii
     charset-g1 latin-iso8859-14
     charset-g2 t			; grrr
     charset-g3 t			; grrr
     mnemonic "MIME/Ltn-8")))

;;;###autoload
(unless (assoc "Latin-8" language-info-alist)
  (defun setup-latin8-environment ()
    "Set up multilingual environment (MULE) for European Latin-8 users."
    (interactive)
    (set-language-environment "Latin-8"))

  ;; sheesh, what we do for backward compatibility
  (apply #'set-language-info-alist
	 (append `("Latin-8"
		   ((charset ascii latin-iso8859-14)
		    (coding-system iso-8859-14)
		    (coding-priority iso-8859-14)
		    (input-method . "latin-8-prefix")
		    (sample-text
		     ,(apply 'format "\
Following is the first paragraph of Myles na gCopaleen's An B%cal Bocht, %c
Eibhl%cn N%c Nuall%cin, 1941, 1999.  The first asterisked word is a rendering
of \"diversions\" in Irish orthography, and the second \"adventures\":

\"T%c na nithe at%c luaithe agam sa scr%cbhinn seo %c gcur agam ann de %cr%c go
%cfuil an saol eile ag druidim liom go sciobtha -- i %cfad uainn go l%cir an
drochrud agus n%cr aithn%c an t-ainspiorad mar %cr%cthair m%c -- agus f%cs 'mar
n%c beidh %cr leith%cid%c ar%cs ann.' Is c%cir cu%c go gcuirf%c ar f%cil don %cuintir
a leanann sinn faisn%cis %cigin ar na dibheairseans* agus na haidbhintiurs** a
bh%c ann len%cr linn mar nach mbeidh %cr sampla%c ar%cs ann go br%cch agus mar
nach mbeidh aon saol d againne nach %cfuil anois ann. \"

* scl%cip
** eachtra%c" (mapcar '(lambda (code) (make-char 'latin-iso8859-14 code))
		     '(105 41 109 109 97 97 97 109 97 34 109 34 34 105 97 
		       109 34 97 105 115 97 97 105 109 109 115 109 109 97 
		       53 105 105 109 97 97 109 109 97 34 105 109))))
		    (documentation . "\
This is a generic language environment for Latin-8 (ISO-8859-14).  It
supports Celtic and most Western European languages.")))
		 (if (emacs-version>= 21 1 15)
		     '(("European"))
		   nil))))

(provide 'latin-euro-latin8)

;; The above sample text format string was generated using this code and the
;; text following it; 
;; 
;; (let ((res ()))
;;   (while (re-search-forward 
;; 	  (format "[%c-%c]" 
;; 		  (make-char 'latin-iso8859-14 32)
;; 		  (make-char 'latin-iso8859-14 127)) nil t)
;;     (push (cadr (split-char (elt (match-string 0) 0))) res)
;;     (replace-match "%c"))
;;   (nreverse res))
;; 
;; "Following is the first paragraph of Myles na gCopaleen's An B-_al Bocht, -A
;; Eibhl-_n N Nuallin, 1941, 1999.  The first asterisked word is a rendering-A
;; of \"diversions\" in Irish orthography, and the second \"adventures\":
;; 
;; \"T-_ na nithe at luaithe agam sa scrbhinn seo  gcur agam ann de r go-A
;; -_fuil an saol eile ag druidim liom go sciobtha -- i fad uainn go lir an-A
;; drochrud agus n-_r aithn an t-ainspiorad mar rthair m -- agus fs 'mar-A
;; n-_ beidh r leithid ars ann.' Is cir cu go gcuirf ar fil don uintir-A
;; a leanann sinn faisn-_is igin ar na dibheairseans* agus na haidbhintiurs** a-A
;; bh-_ ann lenr linn mar nach mbeidh r sampla ars ann go brch agus mar-A
;; nach mbeidh aon saol d againne nach -_fuil anois ann. \"-A
;; 
;; * scl-_ip-A
;; ** eachtra-_-A
;; "

;;; end of latin-euro-latin8.el
