#ifdef __cplusplus
extern "C" {
#endif

/*
    This software may only be used by you under license from AT&T Corp.
    ("AT&T").  A copy of AT&T's Source Code Agreement is available at
    AT&T's Internet website having the URL:
    <http://www.research.att.com/sw/tools/graphviz/license/source.html>
    If you received this software without first entering into a license
    with AT&T, you have an infringing copy of this software and cannot use
    it without violating AT&T's intellectual property rights.
*/


#ifndef _BFS_H_
#define _BFS_H_

#include "defs.h"

#ifdef __cplusplus
class Queue {
private:	
	int * data;
	int queueSize;
	int end;
	int start;
public:
	Queue(int size) {data=new int[size]; queueSize=size; start=0; end=0;}
	~Queue() {delete [] data;}
	void initQueue(int startVertex) {
		data[0]=startVertex;
		start=0; end=1;
	}

	bool dequeue(int & vertex) {
		
		if (start>=end)
			return false; /* underflow */

		vertex=data[start++];
		return true;

	}

	bool enqueue(int vertex) {
		if (end>=queueSize)
			return false; /* overflow */
		data[end++]=vertex;
		return true;
	}
};


void bfs(int vertex, vtx_data * graph, int n, DistType * dist, Queue & Q);
void bfs_bounded(int vertex, vtx_data * graph, int n, DistType * dist, Queue & Q,
				 int bound, int * visited_nodes, int & num_visited_nodes);
#else
typedef struct {
	int * data;
	int queueSize;
	int end;
	int start;
} Queue;

extern void mkQueue(Queue*, int);
extern void freeQueue(Queue*);
extern void initQueue(Queue*, int startVertex);
extern bool deQueue(Queue*,int*);
extern bool enQueue(Queue*,int);

extern void bfs(int, vtx_data *, int, DistType *, Queue *);
extern int bfs_bounded(int, vtx_data*, int, DistType*, Queue*, int, int*);
#endif

#endif

#ifdef __cplusplus
}
#endif
