/*
 * Decompiled with CFR 0.152.
 */
package jde.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import jde.util.DynamicClassLoader;

public class Completion {
    public static final String NIL = "nil";
    public static final String NL = "\n";
    public static final String T = "t";
    public static final String LIST = "list";
    public static final String START_PAREN = "(";
    public static final String END_PAREN = ")";
    public static final String DOUBLE_QUOTE = "\"";
    public static final String SPACE = " ";
    public static final String START_LIST;
    public static final int PUBLIC = 0;
    public static final int PROTECTED = 1;
    public static final int DEFAULT = 2;
    public static final int PRIVATE = 3;

    public static void isAncestorOf(String ancestor, String child) {
        try {
            Class<?> classAncestor = Class.forName(ancestor);
            Class<?> classChild = Class.forName(child);
            if (classAncestor.isAssignableFrom(classChild)) {
                System.out.println(T);
            } else {
                System.out.println(NIL);
            }
        }
        catch (Exception ex) {
            System.out.println(NIL);
        }
    }

    private static boolean isAccessible(int modifiers, int level) {
        switch (level) {
            case 0: {
                return Modifier.isPublic(modifiers);
            }
            case 1: {
                return Modifier.isProtected(modifiers);
            }
            case 2: {
                return !Modifier.isPublic(modifiers) && !Modifier.isProtected(modifiers) && !Modifier.isPrivate(modifiers);
            }
            case 3: {
                return Modifier.isPrivate(modifiers);
            }
        }
        throw new Error("Completion.isAccessible(int, int) called with incorrect access level parameter:" + level);
    }

    private static String printField(String name, String type) {
        StringBuffer sb = new StringBuffer(30);
        sb.append(START_LIST);
        sb.append(Completion.printWithinQuotes(name));
        sb.append(SPACE);
        sb.append(Completion.printWithinQuotes(type));
        sb.append(END_PAREN);
        return sb.toString();
    }

    private static String printConstructor(String name, Class[] params) {
        StringBuffer sb = new StringBuffer(30);
        sb.append(START_LIST);
        sb.append(Completion.printWithinQuotes(name));
        sb.append(SPACE);
        sb.append(Completion.listClassArray(params));
        sb.append(SPACE);
        return sb.toString();
    }

    private static String printMethod(String name, String returnType, Class[] args) {
        StringBuffer sb = new StringBuffer(30);
        sb.append(START_LIST);
        sb.append(Completion.printWithinQuotes(name));
        sb.append(SPACE);
        sb.append(Completion.printWithinQuotes(returnType));
        sb.append(SPACE);
        sb.append(Completion.listClassArray(args));
        sb.append(SPACE);
        return sb.toString();
    }

    private static String printClass(String name) {
        StringBuffer sb = new StringBuffer(30);
        sb.append(START_LIST);
        sb.append(Completion.printWithinQuotes(name));
        sb.append(END_PAREN);
        return sb.toString();
    }

    private static String printExceptions(Class[] exceptions) {
        StringBuffer sb = new StringBuffer(30);
        sb.append(START_LIST);
        sb.append(Completion.listClassArray(exceptions));
        sb.append(END_PAREN);
        return sb.toString();
    }

    private static String printWithinQuotes(String item) {
        StringBuffer sb = new StringBuffer(30);
        sb.append(DOUBLE_QUOTE);
        sb.append(item);
        sb.append(DOUBLE_QUOTE);
        return sb.toString();
    }

    private static void recursiveListFields(Class c, int level, StringBuffer sb) {
        if (c == null) {
            return;
        }
        Field[] fields = level == 0 ? c.getFields() : c.getDeclaredFields();
        int index = 0;
        while (index < fields.length) {
            Field field = fields[index];
            if (Completion.isAccessible(field.getModifiers(), level)) {
                String f = Completion.printField(field.getName(), Completion.className(field.getType()));
                if (sb.toString().lastIndexOf(f) == -1) {
                    sb.append(f);
                }
            }
            ++index;
        }
        if (!c.isInterface() && level != 3 && level != 0) {
            Completion.recursiveListFields(c.getSuperclass(), level, sb);
        }
    }

    private static void listConstructors(Class c, int level, StringBuffer sb) {
        Constructor<?>[] constrs = c.getDeclaredConstructors();
        int index = 0;
        while (index < constrs.length) {
            Constructor<?> constructor = constrs[index];
            if (Completion.isAccessible(constructor.getModifiers(), level)) {
                StringBuffer cons = new StringBuffer(100);
                cons.append(Completion.printConstructor(constructor.getName(), constructor.getParameterTypes()));
                Class[] exceptions = constructor.getExceptionTypes();
                if (exceptions.length > 0) {
                    cons.append(Completion.printExceptions(exceptions));
                } else {
                    cons.append(NIL);
                }
                cons.append(END_PAREN);
                if (sb.toString().lastIndexOf(cons.toString()) == -1) {
                    sb.append((Object)cons);
                }
            }
            ++index;
        }
    }

    private static void recursiveListMethods(Class c, int level, StringBuffer sb) {
        if (c == null) {
            return;
        }
        Method[] methods = level == 0 ? c.getMethods() : c.getDeclaredMethods();
        int index = 0;
        while (index < methods.length) {
            Method method = methods[index];
            if (Completion.isAccessible(method.getModifiers(), level)) {
                StringBuffer temp = new StringBuffer(100);
                temp.append(Completion.printMethod(method.getName(), Completion.className(method.getReturnType()), method.getParameterTypes()));
                Class[] exceptions = method.getExceptionTypes();
                if (exceptions.length > 0) {
                    temp.append(Completion.printExceptions(exceptions));
                } else {
                    temp.append(NIL);
                }
                temp.append(END_PAREN);
                if (sb.toString().lastIndexOf(temp.toString()) == -1) {
                    sb.append((Object)temp);
                }
            }
            ++index;
        }
        if (!c.isInterface() && level != 3 && level != 0) {
            Completion.recursiveListMethods(c.getSuperclass(), level, sb);
        }
    }

    private static void recursiveListInnerClasses(Class c, int level, StringBuffer sb) {
        if (c == null) {
            return;
        }
        Class<?>[] innerClasses = level == 0 ? c.getClasses() : c.getDeclaredClasses();
        int index = 0;
        while (index < innerClasses.length) {
            Class<?> innerClass = innerClasses[index];
            if (Completion.isAccessible(innerClass.getModifiers(), level)) {
                String clas = Completion.printClass(innerClass.getName());
                if (sb.toString().lastIndexOf(clas) == -1) {
                    sb.append(clas);
                }
            }
            ++index;
        }
        if (!c.isInterface() && level != 3 && level != 0) {
            Completion.recursiveListInnerClasses(c.getSuperclass(), level, sb);
        }
    }

    private static void listClassInfo(Class c, int level, StringBuffer sb) {
        sb.append(START_LIST);
        sb.append(START_LIST);
        Completion.recursiveListFields(c, level, sb);
        sb.append(END_PAREN);
        sb.append(NL);
        sb.append(START_LIST);
        Completion.listConstructors(c, level, sb);
        sb.append(END_PAREN);
        sb.append(NL);
        sb.append(START_LIST);
        Completion.recursiveListMethods(c, level, sb);
        sb.append(END_PAREN);
        sb.append(NL);
        sb.append(START_LIST);
        Completion.recursiveListInnerClasses(c, level, sb);
        sb.append(END_PAREN);
        sb.append(END_PAREN);
        sb.append(NL);
    }

    public static void getClassInfo(String className) {
        Completion.getClassInfo(className, 0);
    }

    public static void getClassInfo(String className, int level) {
        try {
            DynamicClassLoader dcl = new DynamicClassLoader();
            Class c = dcl.loadClass(className);
            if (c != null) {
                StringBuffer sb = new StringBuffer(3000);
                sb.append(START_LIST);
                sb.append(NL);
                Completion.listClassInfo(c, level, sb);
                sb.append(END_PAREN);
                sb.append(NL);
                BufferedWriter out = new BufferedWriter(new OutputStreamWriter(System.out));
                try {
                    out.write(sb.toString());
                    ((Writer)out).flush();
                }
                catch (IOException e) {}
            }
        }
        catch (Exception cnfe) {
            System.out.println(NIL);
        }
    }

    public static void getClassInfo(String className, String[] imports) {
        int i = 0;
        while (i < imports.length) {
            String name = imports[i] + className;
            try {
                Class<?> c = Class.forName(name);
                if (c != null) {
                    Completion.getClassInfo(name);
                }
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
            ++i;
        }
        System.out.println(NIL);
    }

    static String className(Class c) {
        if (c.isArray()) {
            return c.getComponentType().getName() + "[]";
        }
        return c.getName();
    }

    static String listClassArray(Class[] classes) {
        StringBuffer sb = new StringBuffer(100);
        int i = 0;
        while (i < classes.length) {
            sb.append(Completion.printWithinQuotes(Completion.className(classes[i])));
            if (i + 1 != classes.length) {
                sb.append(SPACE);
            }
            ++i;
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        Completion.getClassInfo("java.lang.Object", 0);
        Completion.getClassInfo("java.lang.Object", 1);
        Completion.getClassInfo("java.lang.Object", 2);
        Completion.getClassInfo("java.lang.Object", 3);
    }

    static {
        StringBuffer sb = new StringBuffer(10);
        sb.append(START_PAREN);
        sb.append(LIST);
        sb.append(SPACE);
        START_LIST = sb.toString();
    }
}

