/*
    ParaGUI - crossplatform widgetset
    Copyright (C) 2000,2001  Alexander Pipelka

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Alexander Pipelka
    pipelka@teleweb.at

    Last Update:      $Author: pipelka $
    Update Date:      $Date: 2001/06/27 18:22:16 $
    Source File:      $Source: /usr/local/CVSROOT/linux/paragui/include/pgrect.h,v $
    CVS/RCS Revision: $Revision: 1.1.2.9 $
    Status:           $State: Exp $
*/

#ifndef PG_RECT_H
#define PG_RECT_H

#ifdef SWIG
%include "swigcommon.h"
%module pgrest
%{
#include "pgrect.h"
%}
#endif

#include "paragui.h"

/**
	@author Alexander Pipelka
	@short Encapsulation of the SDL_Rect structure
*/

class DECLSPEC PG_Rect
#ifndef DOXYGEN_SKIP
: public SDL_Rect
#endif
{
public:

	/**
	Create a new PG_Rect object with give values
	@param	x	x-startposition
	@param	y	y-startposition
	@param	w	width
	@param	h	height

	Initializes the created PG_Rect object with x/y postions and width/height
	*/
	PG_Rect(int x, int y, int w, int h);

	/**
	Create an empty PG_Rect object
	Initializes the created PG_Rect object with x=y=w=h=0
	*/
	PG_Rect();

	/**
	Create a new PG_Rect from a reference
	@param	src	reference rectangle

	Initializes the created PG_Rect object with the position of the reference rectangle
	*/
	PG_Rect(const PG_Rect& src);

	/**
	Create a new PG_Rect from a SDL_Rect structure
	@param	src	source SDL_Rect structure

	Initializes the created PG_Rect object with the position of the SDL_Rect structure
	*/
	PG_Rect(const SDL_Rect& src);

	virtual ~PG_Rect();

	/**
	Set the position of the rectangle
	@param	x	x-startposition
	@param	y	y-startposition
	@param	w	width
	@param	h	height
	Moves the rectangle to the given values
	*/	
	inline void SetRect(int x, int y, int w, int h) {
		my_xpos = x;
		my_ypos = y;
		my_width = w;
		my_height = h;
	}

	/**
	*/
	PG_Rect& operator =(const PG_Rect& src);

	PG_Rect operator / (PG_Rect& b);

	/**
	Check if a given point is inside a rectangle (boxtest)

	@param	p		the point to test
	@param	r		the rectangle the point should be inside
	@return			true if the point is inside the rectangle
	*/
	static bool IsInside(const PG_Point& p, PG_Rect& r);

	/**
	Check if a given point is inside a rectangle (boxtest)

	@param	p		the point to test
	@return			true if the point is inside the rectangle
	*/
	bool IsInside(const PG_Point& p);

	/**
	Intersect two rectangles
	@param	p					reference rectangle
	@param	c					rectangle to intersect with reference
	@return						resulting intersection rectangle
	*/
	PG_Rect IntersectRect(const PG_Rect& p, const PG_Rect& c);

	/**
	Intersect two rectangles
	@param	p					rectangle to intersect with
	@return						resulting intersection rectangle
	*/
	PG_Rect IntersectRect(const PG_Rect& p);

	/**
	Return the width of the rectangle
	@return			width
	*/
	inline Uint16 Width() {
		return my_width;
	}

	/**
	Return the height of the rectangle
	@return			height
	*/
	inline Uint16 Height() {
		return my_height;
	}

	inline bool IsNull() {
		return (!Width() && !Height());
	}

	SDL_Rect* SDLRect();

	Sint16&	my_xpos;
	Sint16&	my_ypos;
	Uint16&	my_width;
	Uint16&	my_height;
};

#endif	// PG_RECT_H
