/*
    ParaGUI - crossplatform widgetset
    Copyright (C) 2000,2001  Alexander Pipelka

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Alexander Pipelka
    pipelka@teleweb.at

    Last Update:      $Author: pipelka $
    Update Date:      $Date: 2001/05/23 13:59:17 $
    Source File:      $Source: /usr/local/CVSROOT/linux/paragui/include/Attic/pgdropdown.h,v $
    CVS/RCS Revision: $Revision: 1.1.2.2 $
    Status:           $State: Exp $
*/

#ifndef PG_DROPDOWN_H
#define PG_DROPDOWN_H

#ifdef SWIG
%include "swigcommon.h"
%module pgdropdown
%{
#include "pgdropdown.h"
%}
#endif

#include "pgbutton.h"
#include "pglineedit.h"
#include "pglistbox.h"
#include "pglistboxitem.h"
#include "pgeventobject.h"

/**
	@author Alexander Pipelka
	
	@short A edit / dropdown combo item

	Basically a PG_LineEdit widget but with a button to show a dropdown list with
	predefined entries.
*/

class DECLSPEC PG_DropDown : public PG_Widget, public PG_EventObject {
public:

	/**  */
	PG_DropDown(PG_Widget* parent, int id, const PG_Rect& r, const char* style="DropDown");

	/**  */
	~PG_DropDown();

	/** */
	void LoadThemeStyle(const char* style);

	/**  */
	void AddItem(char* text);
	
	/**
	Set the item indentation
	@param	indent		number of pixels for item indentation (must be set before adding items)
	*/
	void SetIndent(int indent);

	/**
	Set if the widget is editable by the user
	@param	edit		true - widget is editable / false - widget is read only
	*/
	void SetEditable(bool edit);
	
	/**
	Check if the widget is editable by the user
	@return			true - widget is editable / false - widget is read only
	*/
	bool GetEditable();

	/**
	Get the current text string
	@return			pointer to text string
	*/
	char* GetText();

	/**
	Set the current text string
	@param	new_text	pointer to text string
	*/
	void SetText(char* new_text);

protected:

	void eventShow();

	void eventHide();

	bool eventButtonClick (int id, PG_Widget* widget);

	void eventSizeWindow(int w, int h);

	void eventMoveWindow(int x, int y);

	/** */
	virtual bool eventSelectItem(PG_ListBoxBaseItem* item);

	PG_LineEdit* my_EditBox;
	PG_Button* my_DropButton;
	PG_ListBox* my_DropList;

	PARAGUI_CALLBACK(select_handler);
};

#endif	// PG_DROPDOWN_H
