<?php // $Id: markposts.php,v 1.7 2005/05/03 16:32:25 moodler Exp $

      //  Set tracking option for the forum.

    require_once("../../config.php");
    require_once("lib.php");

    require_variable($f);                           // The forum to mark
    require_variable($mark);                        // Read or unread?
    optional_variable($d);                          // Discussion to mark.
    optional_variable($returnpage, 'index.php');    // Page to return to.

    if (! $forum = get_record("forum", "id", $f)) {
        error("Forum ID was incorrect");
    }

    if (! $course = get_record("course", "id", $forum->course)) {
        error("Forum doesn't belong to a course!");
    }

    if (!($cm = get_coursemodule_from_instance("forum", $forum->id, $course->id))) {
        $cm->id = NULL;
    }

    $user = $USER;

    require_course_login($course, false, $cm);

    if (isguest()) {   // Guests can't change forum
        $wwwroot = $CFG->wwwroot.'/login/index.php';
        if (!empty($CFG->loginhttps)) {
            $wwwroot = str_replace('http','https', $wwwroot);
        }

        $strforums = get_string('modulenameplural', 'forum');
        if ($course->category) {
            print_header($course->shortname, $course->fullname,
                 "<a href=\"../../course/view.php?id=$course->id\">$course->shortname</a> ->
                  <a href=\"../forum/index.php?id=$course->id\">$strforums</a> -> 
                  <a href=\"view.php?f=$forum->id\">".format_string($forum->name,true)."</a>", '', '', true, "", navmenu($course, $cm));
        } else {
            print_header($course->shortname, $course->fullname,
                 "<a href=\"../forum/index.php?id=$course->id\">$strforums</a> -> 
                  <a href=\"view.php?f=$forum->id\">".format_string($forum->name,true)."</a>", '', '', true, "", navmenu($course, $cm));
        }
        notice_yesno(get_string('noguesttracking', 'forum').'<br /><br />'.get_string('liketologin'),
                     $wwwroot, $_SERVER['HTTP_REFERER']);
        print_footer($course);
        exit;
    }

    if ($returnpage == 'index.php') {
        $returnto = forum_go_back_to($returnpage.'?id='.$course->id);
    } else {
        $returnto = forum_go_back_to($returnpage.'?f='.$forum->id);
    }

    $info->name  = fullname($user);
    $info->forum = format_string($forum->name);

    if ($mark == 'read') {
        if (!empty($d)) {
            if (forum_tp_mark_discussion_read($user->id, $d, $forum->id)) {
                add_to_log($course->id, "discussion", "mark read", "view.php?f=$forum->id", $d, $cm->id);
            }
        } else {
            if (forum_tp_mark_forum_read($user->id, $forum->id)) {
                add_to_log($course->id, "forum", "mark read", "view.php?f=$forum->id", $forum->id, $cm->id);
            }
        }

/// FUTURE - Add ability to mark them as unread.
//    } else { // subscribe
//        if (forum_tp_start_tracking($forum->id, $user->id)) {
//            add_to_log($course->id, "forum", "mark unread", "view.php?f=$forum->id", $forum->id, $cm->id);
//            redirect($returnto, get_string("nowtracking", "forum", $info), 1);
//        } else {
//            error("Could not start tracking that forum", $_SERVER["HTTP_REFERER"]);
//        }
    }

    redirect($returnto);

?>
