<?php
/**
 * Horde external API interface.
 *
 * This file defines Horde's external API interface. Other
 * applications can interact with Horde through this API.
 *
 * $Horde: horde/lib/api.php,v 1.43.2.2 2005/07/23 10:27:55 jan Exp $
 *
 * @package Horde
 */

$_types = array(
    '{urn:horde}stringArray' => array(array('item' => 'string')),
    'hashItem' => array('key' => 'string', 'value' => 'string'),
    'hash' => array(array('item' => '{urn:horde}hashItem')),
    'hashHashItem' => array('key' => 'string', 'value' => '{urn:horde}hash'),
    'hashHash' => array(array('item' => '{urn:horde}hashHashItem')));

$_services['admin_list'] = array(true);

$_services['removeUserData'] = array(
    'args' => array('user' => 'string')
);

/**
 * General API for deleting Horde_Links
 */
$_services['deleteLink'] = array(
    'link' => '%application%/services/links/delete.php?' .
              'link_data=|link_data|&return_url=|url|'
);

$_services['listApps'] = array(
    'args' => array('filter' => '{urn:horde}stringArray'),
    'type' => '{urn:horde}stringArray'
);

$_services['listAPIs'] = array(
    'args' => array(),
    'type' => '{urn:horde}stringArray'
);

$_services['blockTitle'] = array(
    'args' => array('app' => 'string', 'name' => 'string', 'params' => '{urn:horde}hash'),
    'type' => 'string'
);

$_services['blockContent'] = array(
    'args' => array('app' => 'string', 'name' => 'string', 'params' => '{urn:horde}hash'),
    'type' => 'string'
);

$_services['blocks'] = array(
    'args' => array(),
    'type' => '{urn:horde}hash'
);


function &_horde_block($app, $name, $params = array())
{
    global $registry;

    require_once 'Horde/Block.php';
    require_once 'Horde/Block/Collection.php';

    $result = $registry->pushApp($app);
    if (!is_a($result, 'PEAR_Error')) {
        $result = Horde_Block_Collection::getBlock($app, $name, $params);
        $registry->popApp($app);
    }
    return $result;
}

function _horde_blockTitle($app, $name, $params = array())
{
    $block = &_horde_block($app, $name, $params);
    if (is_a($block, 'PEAR_Error')) {
        return $block->getMessage();
    }
    return $block->getTitle();
}

function _horde_blockContent($app, $name, $params = array())
{
    $block = &_horde_block($app, $name, $params);
    if (is_a($block, 'PEAR_Error')) {
        return $block->getMessage();
    }
    return $block->getContent();
}

function _horde_blocks()
{
    require_once 'Horde/Block/Collection.php';
    $collection = &Horde_Block_Collection::singleton();
    if (is_a($collection, 'PEAR_Error')) {
        return $collection;
    } else {
        return $collection->getBlocksList();
    }
}

function _horde_admin_list()
{
    return array('configuration' => array(
                     'link' => '%application%/admin/setup/',
                     'name' => _("_Setup"),
                     'icon' => 'config.png'),
                 'users' => array(
                     'link' => '%application%/admin/user.php',
                     'name' => _("_Users"),
                     'icon' => 'user.png'),
                 'groups' => array(
                     'link' => '%application%/admin/groups.php',
                     'name' => _("_Groups"),
                     'icon' => 'group.png'),
                 'perms' => array(
                     'link' => '%application%/admin/perms/index.php',
                     'name' => _("_Permissions"),
                     'icon' => 'perms.png'),
                 'datatree' => array(
                     'link' => '%application%/admin/datatree.php',
                     'name' => _("_DataTree"),
                     'icon' => 'perms.png'),
                 'phpshell' => array(
                     'link' => '%application%/admin/phpshell.php',
                     'name' => _("P_HP Shell"),
                     'icon' => 'shell.png'),
                 'sqlshell' => array(
                     'link' => '%application%/admin/sqlshell.php',
                     'name' => _("S_QL Shell"),
                     'icon' => 'sql.png'),
                 'cmdshell' => array(
                     'link' => '%application%/admin/cmdshell.php',
                     'name' => _("_CLI"),
                     'icon' => 'shell.png'),
                 );
}

function _horde_removeUserData($user)
{
    global $conf;

    require_once 'Horde/Prefs.php';
    $prefs = &Prefs::singleton($conf['prefs']['driver'], null, $user);
    if (is_a($result = $prefs->clear(), 'PEAR_Error')) {
        return $result;
    }
}

function _horde_listApps($filter = null)
{
    return $GLOBALS['registry']->listApps($filter);
}

function _horde_listAPIs()
{
    return $GLOBALS['registry']->listAPIs();
}
