require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&SBP_LFM_STATUS)) {
    sub SBP_LFM_STATUS () {	0;}
}
unless(defined(&SBP_LFM_ADDR)) {
    sub SBP_LFM_ADDR () {	0;}
}
unless(defined(&SBP_LFM_DATA)) {
    sub SBP_LFM_DATA () {	1;}
}
unless(defined(&SBP_RFM_STATUS)) {
    sub SBP_RFM_STATUS () {	2;}
}
unless(defined(&SBP_RFM_ADDR)) {
    sub SBP_RFM_ADDR () {	2;}
}
unless(defined(&SBP_RFM_DATA)) {
    sub SBP_RFM_DATA () {	3;}
}
unless(defined(&SBP_FM_STATUS)) {
    sub SBP_FM_STATUS () {	8;}
}
unless(defined(&SBP_FM_ADDR)) {
    sub SBP_FM_ADDR () {	8;}
}
unless(defined(&SBP_FM_DATA)) {
    sub SBP_FM_DATA () {	9;}
}
unless(defined(&SBP_MIXER_ADDR)) {
    sub SBP_MIXER_ADDR () {	4;}
}
unless(defined(&SBP_MIXER_DATA)) {
    sub SBP_MIXER_DATA () {	5;}
}
unless(defined(&SBP_MIX_RESET)) {
    sub SBP_MIX_RESET () {	0x;}
}
unless(defined(&SBP_1335_MASTER_VOL)) {
    sub SBP_1335_MASTER_VOL () {	0x2;}
}
unless(defined(&SBP_1335_MIDI_VOL)) {
    sub SBP_1335_MIDI_VOL () {	0x6;}
}
unless(defined(&SBP_1335_CD_VOL)) {
    sub SBP_1335_CD_VOL () {	0x8;}
}
unless(defined(&SBP_1335_VOICE_VOL)) {
    sub SBP_1335_VOICE_VOL () {	0xa;}
}
unless(defined(&SBP_VOICE_VOL)) {
    sub SBP_VOICE_VOL () {	0x4;}
}
unless(defined(&SBP_MIC_VOL)) {
    sub SBP_MIC_VOL () {	0xa;}
}
unless(defined(&SBP_MASTER_VOL)) {
    sub SBP_MASTER_VOL () {	0x22;}
}
unless(defined(&SBP_MIDI_VOL)) {
    sub SBP_MIDI_VOL () {	0x26;}
}
unless(defined(&SBP_CD_VOL)) {
    sub SBP_CD_VOL () {	0x28;}
}
unless(defined(&SBP_LINE_VOL)) {
    sub SBP_LINE_VOL () {	0x2e;}
}
unless(defined(&SBP_RECORD_SOURCE)) {
    sub SBP_RECORD_SOURCE () {	0xc;}
}
unless(defined(&SBP_STEREO)) {
    sub SBP_STEREO () {	0xe;}
}
unless(defined(&SBP_PLAYMODE_STEREO)) {
    sub SBP_PLAYMODE_STEREO () {	0x2;}
}
unless(defined(&SBP_PLAYMODE_MONO)) {
    sub SBP_PLAYMODE_MONO () {	0x;}
}
unless(defined(&SBP_PLAYMODE_MASK)) {
    sub SBP_PLAYMODE_MASK () {	0x2;}
}
unless(defined(&SBP_OUTFILTER)) {
    sub SBP_OUTFILTER () {	0xe;}
}
unless(defined(&SBP_INFILTER)) {
    sub SBP_INFILTER () {	0xc;}
}
unless(defined(&SBP_RECORD_FROM)) {
    sub SBP_RECORD_FROM {
	local($src, $filteron, $high) = @_;
	eval q((($src) | ($filteron) | ($high)));
    }
}
unless(defined(&SBP_FILTER_ON)) {
    sub SBP_FILTER_ON () {	0x;}
}
unless(defined(&SBP_FILTER_OFF)) {
    sub SBP_FILTER_OFF () {	0x20;}
}
unless(defined(&SBP_IFILTER_MASK)) {
    sub SBP_IFILTER_MASK () {	0x28;}
}
unless(defined(&SBP_OFILTER_MASK)) {
    sub SBP_OFILTER_MASK () {	0x20;}
}
unless(defined(&SBP_IFILTER_LOW)) {
    sub SBP_IFILTER_LOW () {	0;}
}
unless(defined(&SBP_IFILTER_HIGH)) {
    sub SBP_IFILTER_HIGH () {	0x8;}
}
unless(defined(&SBP_FROM_MIC)) {
    sub SBP_FROM_MIC () {	0x;}
}
unless(defined(&SBP_FROM_CD)) {
    sub SBP_FROM_CD () {	0x2;}
}
unless(defined(&SBP_FROM_LINE)) {
    sub SBP_FROM_LINE () {	0x6;}
}
unless(defined(&SBP_SET_IRQ)) {
    sub SBP_SET_IRQ () {	0x80;}
}
unless(defined(&SBP_SET_DRQ)) {
    sub SBP_SET_DRQ () {	0x81;}
}
unless(defined(&SBP_IRQ_STATUS)) {
    sub SBP_IRQ_STATUS () {	0x82;}
}
unless(defined(&SBP_IRQ_MPU401)) {
    sub SBP_IRQ_MPU401 () {	0x4;}
}
unless(defined(&SBP_IRQ_DMA16)) {
    sub SBP_IRQ_DMA16 () {	0x2;}
}
unless(defined(&SBP_IRQ_DMA8)) {
    sub SBP_IRQ_DMA8 () {	0x1;}
}
unless(defined(&SB16P_MASTER_L)) {
    sub SB16P_MASTER_L () {	0x30;}
}
unless(defined(&SB16P_VOICE_L)) {
    sub SB16P_VOICE_L () {	0x32;}
}
unless(defined(&SB16P_MIDI_L)) {
    sub SB16P_MIDI_L () {	0x34;}
}
unless(defined(&SB16P_CD_L)) {
    sub SB16P_CD_L () {	0x36;}
}
unless(defined(&SB16P_LINE_L)) {
    sub SB16P_LINE_L () {	0x38;}
}
unless(defined(&SB16P_MIC_L)) {
    sub SB16P_MIC_L () {	0x3a;}
}
unless(defined(&SB16P_PCSPEAKER)) {
    sub SB16P_PCSPEAKER () {	0x3b;}
}
unless(defined(&SB16P_OSWITCH)) {
    sub SB16P_OSWITCH () {	0x3c;}
}
unless(defined(&SB16P_ISWITCH_L)) {
    sub SB16P_ISWITCH_L () {	0x3d;}
}
unless(defined(&SB16P_ISWITCH_R)) {
    sub SB16P_ISWITCH_R () {	0x3e;}
}
unless(defined(&SB16P_SW_MIC)) {
    sub SB16P_SW_MIC () {	0x1;}
}
unless(defined(&SB16P_SW_CD_R)) {
    sub SB16P_SW_CD_R () {	0x2;}
}
unless(defined(&SB16P_SW_CD_L)) {
    sub SB16P_SW_CD_L () {	0x4;}
}
unless(defined(&SB16P_SW_CD)) {
    sub SB16P_SW_CD () {	( &SB16P_SW_CD_L| &SB16P_SW_CD_R);}
}
unless(defined(&SB16P_SW_LINE_R)) {
    sub SB16P_SW_LINE_R () {	0x8;}
}
unless(defined(&SB16P_SW_LINE_L)) {
    sub SB16P_SW_LINE_L () {	0x10;}
}
unless(defined(&SB16P_SW_LINE)) {
    sub SB16P_SW_LINE () {	( &SB16P_SW_LINE_L| &SB16P_SW_LINE_R);}
}
unless(defined(&SB16P_SW_MIDI_R)) {
    sub SB16P_SW_MIDI_R () {	0x20;}
}
unless(defined(&SB16P_SW_MIDI_L)) {
    sub SB16P_SW_MIDI_L () {	0x40;}
}
unless(defined(&SB16P_SW_MIDI)) {
    sub SB16P_SW_MIDI () {	( &SB16P_SW_MIDI_L| &SB16P_SW_MIDI_R);}
}
unless(defined(&SB16P_INPUT_GAIN_L)) {
    sub SB16P_INPUT_GAIN_L () {	0x3f;}
}
unless(defined(&SB16P_OUTPUT_GAIN_L)) {
    sub SB16P_OUTPUT_GAIN_L () {	0x41;}
}
unless(defined(&SB16P_TREBLE_L)) {
    sub SB16P_TREBLE_L () {	0x44;}
}
unless(defined(&SB16P_BASS_L)) {
    sub SB16P_BASS_L () {	0x46;}
}
unless(defined(&SB16P_L_TO_R)) {
    sub SB16P_L_TO_R {
	local($l) = @_;
	eval q((($l)+1));
    }
}
unless(defined(&SB16P_AGC)) {
    sub SB16P_AGC () {	0x43;}
}
unless(defined(&SBP_RECORD_SOURCE_L)) {
    sub SBP_RECORD_SOURCE_L () {	0x3d;}
}
unless(defined(&SBP_RECORD_SOURCE_R)) {
    sub SBP_RECORD_SOURCE_R () {	0x3e;}
}
unless(defined(&SBP_MIDI_SRC_R)) {
    sub SBP_MIDI_SRC_R () {	0x20;}
}
unless(defined(&SBP_LINE_SRC_R)) {
    sub SBP_LINE_SRC_R () {	0x8;}
}
unless(defined(&SBP_CD_SRC_R)) {
    sub SBP_CD_SRC_R () {	0x2;}
}
unless(defined(&SBP_MIC_SRC)) {
    sub SBP_MIC_SRC () {	0x1;}
}
unless(defined(&SB_SRC_R_TO_L)) {
    sub SB_SRC_R_TO_L {
	local($x) = @_;
	eval q((($x) << 1));
    }
}
unless(defined(&SB_STEREO_GAIN)) {
    sub SB_STEREO_GAIN {
	local($left, $right) = @_;
	eval q((($left) | (($right) >> 4)));
    }
}
unless(defined(&SB_MIC_GAIN)) {
    sub SB_MIC_GAIN {
	local($v) = @_;
	eval q((($v) >> 5));
    }
}
unless(defined(&SB_ADJUST_MIC_GAIN)) {
    sub SB_ADJUST_MIC_GAIN {
	local($sc, $x) = @_;
	eval q( &sbdsp_adjust(($x),  &ISSB16CLASS($sc) ? 0xf8 : 0xc0));
    }
}
unless(defined(&SB_ADJUST_GAIN)) {
    sub SB_ADJUST_GAIN {
	local($sc, $x) = @_;
	eval q( &sbdsp_adjust(($x),  &ISSB16CLASS($sc) ? 0xf8 : 0xe0));
    }
}
unless(defined(&SB_ADJUST_2_GAIN)) {
    sub SB_ADJUST_2_GAIN {
	local($sc, $x) = @_;
	eval q( &sbdsp_adjust(($x), 0xc0));
    }
}
unless(defined(&SB_1335_GAIN)) {
    sub SB_1335_GAIN {
	local($x) = @_;
	eval q((($x) >> 4));
    }
}
unless(defined(&SB_1335_MASTER_GAIN)) {
    sub SB_1335_MASTER_GAIN {
	local($x) = @_;
	eval q((($x) >> 5));
    }
}
unless(defined(&SBP_DSP_RESET)) {
    sub SBP_DSP_RESET () {	6;}
}
unless(defined(&SB_MAGIC)) {
    sub SB_MAGIC () {	0xaa;}
}
unless(defined(&SBP_DSP_READ)) {
    sub SBP_DSP_READ () {	10;}
}
unless(defined(&SBP_DSP_WRITE)) {
    sub SBP_DSP_WRITE () {	12;}
}
unless(defined(&SBP_DSP_WSTAT)) {
    sub SBP_DSP_WSTAT () {	12;}
}
unless(defined(&SBP_DSP_RSTAT)) {
    sub SBP_DSP_RSTAT () {	14;}
}
unless(defined(&SB_DSP_BUSY)) {
    sub SB_DSP_BUSY () {	0x80;}
}
unless(defined(&SB_DSP_READY)) {
    sub SB_DSP_READY () {	0x80;}
}
unless(defined(&SBP_DSP_IRQACK8)) {
    sub SBP_DSP_IRQACK8 () {	14;}
}
unless(defined(&SBP_DSP_IRQACK16)) {
    sub SBP_DSP_IRQACK16 () {	15;}
}
unless(defined(&SBP_CDROM_DATA)) {
    sub SBP_CDROM_DATA () {	16;}
}
unless(defined(&SBP_CDROM_STATUS)) {
    sub SBP_CDROM_STATUS () {	17;}
}
unless(defined(&SBP_CDROM_RESET)) {
    sub SBP_CDROM_RESET () {	18;}
}
unless(defined(&SBP_CDROM_ENABLE)) {
    sub SBP_CDROM_ENABLE () {	19;}
}
unless(defined(&SBP_NPORT)) {
    sub SBP_NPORT () {	24;}
}
unless(defined(&SB_NPORT)) {
    sub SB_NPORT () {	16;}
}
unless(defined(&SB_DSP_DACWRITE)) {
    sub SB_DSP_DACWRITE () {	0x10;}
}
unless(defined(&SB_DSP_WDMA)) {
    sub SB_DSP_WDMA () {	0x14;}
}
unless(defined(&SB_DSP_WDMA_2)) {
    sub SB_DSP_WDMA_2 () {	0x16;}
}
unless(defined(&SB_DSP_WDMA_LOOP)) {
    sub SB_DSP_WDMA_LOOP () {	0x1c;}
}
unless(defined(&SB_DSP_ADCREAD)) {
    sub SB_DSP_ADCREAD () {	0x20;}
}
unless(defined(&SB_DSP_RDMA)) {
    sub SB_DSP_RDMA () {	0x24;}
}
unless(defined(&SB_DSP_RDMA_LOOP)) {
    sub SB_DSP_RDMA_LOOP () {	0x2c;}
}
unless(defined(&SB_MIDI_POLL)) {
    sub SB_MIDI_POLL () {	0x30;}
}
unless(defined(&SB_MIDI_READ)) {
    sub SB_MIDI_READ () {	0x31;}
}
unless(defined(&SB_MIDI_UART_POLL)) {
    sub SB_MIDI_UART_POLL () {	0x34;}
}
unless(defined(&SB_MIDI_UART_INTR)) {
    sub SB_MIDI_UART_INTR () {	0x35;}
}
unless(defined(&SB_MIDI_WRITE)) {
    sub SB_MIDI_WRITE () {	0x38;}
}
unless(defined(&SB_DSP_TIMECONST)) {
    sub SB_DSP_TIMECONST () {	0x40;}
}
unless(defined(&SB_DSP16_OUTPUTRATE)) {
    sub SB_DSP16_OUTPUTRATE () {	0x41;}
}
unless(defined(&SB_DSP16_INPUTRATE)) {
    sub SB_DSP16_INPUTRATE () {	0x42;}
}
unless(defined(&SB_DSP_BLOCKSIZE)) {
    sub SB_DSP_BLOCKSIZE () {	0x48;}
}
unless(defined(&SB_DSP_WDMA_4)) {
    sub SB_DSP_WDMA_4 () {	0x74;}
}
unless(defined(&SB_DSP_WDMA_2_6)) {
    sub SB_DSP_WDMA_2_6 () {	0x76;}
}
unless(defined(&SB_DSP_SILENCE)) {
    sub SB_DSP_SILENCE () {	0x80;}
}
unless(defined(&SB_DSP_HS_OUTPUT)) {
    sub SB_DSP_HS_OUTPUT () {	0x90;}
}
unless(defined(&SB_DSP_HS_INPUT)) {
    sub SB_DSP_HS_INPUT () {	0x98;}
}
unless(defined(&SB_DSP_RECORD_MONO)) {
    sub SB_DSP_RECORD_MONO () {	0xa0;}
}
unless(defined(&SB_DSP_RECORD_STEREO)) {
    sub SB_DSP_RECORD_STEREO () {	0xa8;}
}
unless(defined(&SB_DSP16_WDMA_16)) {
    sub SB_DSP16_WDMA_16 () {	0xb6;}
}
unless(defined(&SB_DSP16_RDMA_16)) {
    sub SB_DSP16_RDMA_16 () {	0xbe;}
}
unless(defined(&SB_DSP16_WDMA_8)) {
    sub SB_DSP16_WDMA_8 () {	0xc6;}
}
unless(defined(&SB_DSP16_RDMA_8)) {
    sub SB_DSP16_RDMA_8 () {	0xce;}
}
unless(defined(&SB_DSP_HALT)) {
    sub SB_DSP_HALT () {	0xd0;}
}
unless(defined(&SB_DSP_SPKR_ON)) {
    sub SB_DSP_SPKR_ON () {	0xd1;}
}
unless(defined(&SB_DSP_SPKR_OFF)) {
    sub SB_DSP_SPKR_OFF () {	0xd3;}
}
unless(defined(&SB_DSP_CONT)) {
    sub SB_DSP_CONT () {	0xd4;}
}
unless(defined(&SB_DSP_RD_SPKR)) {
    sub SB_DSP_RD_SPKR () {	0xd8;}
}
unless(defined(&SB_SPKR_OFF)) {
    sub SB_SPKR_OFF () {	0x;}
}
unless(defined(&SB_SPKR_ON)) {
    sub SB_SPKR_ON () {	0xff;}
}
unless(defined(&SB_DSP_VERSION)) {
    sub SB_DSP_VERSION () {	0xe1;}
}
unless(defined(&SB_BMODE_UNSIGNED)) {
    sub SB_BMODE_UNSIGNED () {	0x;}
}
unless(defined(&SB_BMODE_SIGNED)) {
    sub SB_BMODE_SIGNED () {	0x10;}
}
unless(defined(&SB_BMODE_STEREO)) {
    sub SB_BMODE_STEREO () {	0x20;}
}
unless(defined(&JAZZ16_READ_VER)) {
    sub JAZZ16_READ_VER () {	0xfa;}
}
unless(defined(&JAZZ16_VER_JAZZ)) {
    sub JAZZ16_VER_JAZZ () {	0x12;}
}
unless(defined(&JAZZ16_SET_DMAINTR)) {
    sub JAZZ16_SET_DMAINTR () {	0xfb;}
}
unless(defined(&JAZZ16_CONFIG_PORT)) {
    sub JAZZ16_CONFIG_PORT () {	0x201;}
}
unless(defined(&JAZZ16_WAKEUP)) {
    sub JAZZ16_WAKEUP () {	0xaf;}
}
unless(defined(&JAZZ16_SETBASE)) {
    sub JAZZ16_SETBASE () {	0x50;}
}
unless(defined(&JAZZ16_RECORD_STEREO)) {
    sub JAZZ16_RECORD_STEREO () {	0xac;}
}
unless(defined(&JAZZ16_RECORD_MONO)) {
    sub JAZZ16_RECORD_MONO () {	0xa4;}
}
unless(defined(&JAZZ16_DIR_PB)) {
    sub JAZZ16_DIR_PB () {	0x10;}
}
unless(defined(&JAZZ16_SINGLE_PB)) {
    sub JAZZ16_SINGLE_PB () {	0x14;}
}
unless(defined(&JAZZ16_SINGLE_ALAW_PB)) {
    sub JAZZ16_SINGLE_ALAW_PB () {	0x17;}
}
unless(defined(&JAZZ16_CONT_PB)) {
    sub JAZZ16_CONT_PB () {	0x1c;}
}
unless(defined(&JAZZ16_CONT_ALAW_PB)) {
    sub JAZZ16_CONT_ALAW_PB () {	0x1f;}
}
unless(defined(&JAZZ16_DIR_PCM_REC)) {
    sub JAZZ16_DIR_PCM_REC () {	0x20;}
}
unless(defined(&JAZZ16_SINGLE_REC)) {
    sub JAZZ16_SINGLE_REC () {	0x24;}
}
unless(defined(&JAZZ16_SINGLE_ALAW_REC)) {
    sub JAZZ16_SINGLE_ALAW_REC () {	0x27;}
}
unless(defined(&JAZZ16_CONT_REC)) {
    sub JAZZ16_CONT_REC () {	0x2c;}
}
unless(defined(&JAZZ16_CONT_ALAW_REC)) {
    sub JAZZ16_CONT_ALAW_REC () {	0x2f;}
}
unless(defined(&JAZZ16_SINGLE_ADPCM_PB)) {
    sub JAZZ16_SINGLE_ADPCM_PB () {	0x74;}
}
unless(defined(&JAZZ16_SINGLE_MULAW_PB)) {
    sub JAZZ16_SINGLE_MULAW_PB () {	0x77;}
}
unless(defined(&JAZZ16_CONT_ADPCM_PB)) {
    sub JAZZ16_CONT_ADPCM_PB () {	0x7c;}
}
unless(defined(&JAZZ16_SINGLE_ADPCM_REC)) {
    sub JAZZ16_SINGLE_ADPCM_REC () {	0x84;}
}
unless(defined(&JAZZ16_SINGLE_MULAW_REC)) {
    sub JAZZ16_SINGLE_MULAW_REC () {	0x87;}
}
unless(defined(&JAZZ16_CONT_ADPCM_REC)) {
    sub JAZZ16_CONT_ADPCM_REC () {	0x8c;}
}
unless(defined(&JAZZ16_CONT_MULAW_REC)) {
    sub JAZZ16_CONT_MULAW_REC () {	0x8f;}
}
unless(defined(&JAZZ16_CONT_PB_XX)) {
    sub JAZZ16_CONT_PB_XX () {	0x90;}
}
unless(defined(&JAZZ16_SINGLE_PB_XX)) {
    sub JAZZ16_SINGLE_PB_XX () {	0x91;}
}
unless(defined(&JAZZ16_SINGLE_REC_XX)) {
    sub JAZZ16_SINGLE_REC_XX () {	0x98;}
}
unless(defined(&JAZZ16_CONT_REC_XX)) {
    sub JAZZ16_CONT_REC_XX () {	0x99;}
}
unless(defined(&SB_DSP_REFERENCE)) {
    sub SB_DSP_REFERENCE () {	1;}
}
unless(defined(&SBP_IRQ_VALID)) {
    sub SBP_IRQ_VALID {
	local($irq) = @_;
	eval q((($irq) == 5|| ($irq) == 7|| ($irq) == 9|| ($irq) == 10));
    }
}
unless(defined(&SB_IRQ_VALID)) {
    sub SB_IRQ_VALID {
	local($irq) = @_;
	eval q((($irq) == 3|| ($irq) == 5|| ($irq) == 7|| ($irq) == 9));
    }
}
unless(defined(&SB16_DRQ_VALID)) {
    sub SB16_DRQ_VALID {
	local($chan) = @_;
	eval q((($chan) == 0|| ($chan) == 1|| ($chan) == 3|| ($chan) == 5|| ($chan) == 6|| ($chan) == 7));
    }
}
unless(defined(&SBP_DRQ_VALID)) {
    sub SBP_DRQ_VALID {
	local($chan) = @_;
	eval q((($chan) == 0|| ($chan) == 1|| ($chan) == 3));
    }
}
unless(defined(&SB_DRQ_VALID)) {
    sub SB_DRQ_VALID {
	local($chan) = @_;
	eval q((($chan) == 1));
    }
}
unless(defined(&SB_BASE_VALID)) {
    sub SB_BASE_VALID {
	local($base) = @_;
	eval q((($base) == 0x220 || ($base) == 0x240));
    }
}
unless(defined(&SB_INPUT_RATE)) {
    sub SB_INPUT_RATE () {	0;}
}
unless(defined(&SB_OUTPUT_RATE)) {
    sub SB_OUTPUT_RATE () {	1;}
}
1;
