require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&IPW_NTBD)) {
    sub IPW_NTBD () {	128;}
}
unless(defined(&IPW_TBD_SZ)) {
    sub IPW_TBD_SZ () {	( &IPW_NTBD * $sizeof{'struct ipw_bd'});}
}
unless(defined(&IPW_NDATA)) {
    sub IPW_NDATA () {	( &IPW_NTBD / 2);}
}
unless(defined(&IPW_NRBD)) {
    sub IPW_NRBD () {	128;}
}
unless(defined(&IPW_RBD_SZ)) {
    sub IPW_RBD_SZ () {	( &IPW_NRBD * $sizeof{'struct ipw_bd'});}
}
unless(defined(&IPW_STATUS_SZ)) {
    sub IPW_STATUS_SZ () {	( &IPW_NRBD * $sizeof{'struct ipw_status'});}
}
unless(defined(&IPW_CSR_INTR)) {
    sub IPW_CSR_INTR () {	0x8;}
}
unless(defined(&IPW_CSR_INTR_MASK)) {
    sub IPW_CSR_INTR_MASK () {	0xc;}
}
unless(defined(&IPW_CSR_INDIRECT_ADDR)) {
    sub IPW_CSR_INDIRECT_ADDR () {	0x10;}
}
unless(defined(&IPW_CSR_INDIRECT_DATA)) {
    sub IPW_CSR_INDIRECT_DATA () {	0x14;}
}
unless(defined(&IPW_CSR_AUTOINC_ADDR)) {
    sub IPW_CSR_AUTOINC_ADDR () {	0x18;}
}
unless(defined(&IPW_CSR_AUTOINC_DATA)) {
    sub IPW_CSR_AUTOINC_DATA () {	0x1c;}
}
unless(defined(&IPW_CSR_RST)) {
    sub IPW_CSR_RST () {	0x20;}
}
unless(defined(&IPW_CSR_CTL)) {
    sub IPW_CSR_CTL () {	0x24;}
}
unless(defined(&IPW_CSR_IO)) {
    sub IPW_CSR_IO () {	0x30;}
}
unless(defined(&IPW_CSR_TX_BD_BASE)) {
    sub IPW_CSR_TX_BD_BASE () {	0x200;}
}
unless(defined(&IPW_CSR_TX_BD_SIZE)) {
    sub IPW_CSR_TX_BD_SIZE () {	0x204;}
}
unless(defined(&IPW_CSR_RX_BD_BASE)) {
    sub IPW_CSR_RX_BD_BASE () {	0x240;}
}
unless(defined(&IPW_CSR_RX_STATUS_BASE)) {
    sub IPW_CSR_RX_STATUS_BASE () {	0x244;}
}
unless(defined(&IPW_CSR_RX_BD_SIZE)) {
    sub IPW_CSR_RX_BD_SIZE () {	0x248;}
}
unless(defined(&IPW_CSR_TX_READ_INDEX)) {
    sub IPW_CSR_TX_READ_INDEX () {	0x280;}
}
unless(defined(&IPW_CSR_RX_READ_INDEX)) {
    sub IPW_CSR_RX_READ_INDEX () {	0x2a0;}
}
unless(defined(&IPW_CSR_TABLE1_BASE)) {
    sub IPW_CSR_TABLE1_BASE () {	0x380;}
}
unless(defined(&IPW_CSR_TABLE2_BASE)) {
    sub IPW_CSR_TABLE2_BASE () {	0x384;}
}
unless(defined(&IPW_CSR_TX_WRITE_INDEX)) {
    sub IPW_CSR_TX_WRITE_INDEX () {	0xf80;}
}
unless(defined(&IPW_CSR_RX_WRITE_INDEX)) {
    sub IPW_CSR_RX_WRITE_INDEX () {	0xfa0;}
}
unless(defined(&IPW_INTR_TX_TRANSFER)) {
    sub IPW_INTR_TX_TRANSFER () {	0x1;}
}
unless(defined(&IPW_INTR_RX_TRANSFER)) {
    sub IPW_INTR_RX_TRANSFER () {	0x2;}
}
unless(defined(&IPW_INTR_STATUS_CHANGE)) {
    sub IPW_INTR_STATUS_CHANGE () {	0x10;}
}
unless(defined(&IPW_INTR_COMMAND_DONE)) {
    sub IPW_INTR_COMMAND_DONE () {	0x10000;}
}
unless(defined(&IPW_INTR_FW_INIT_DONE)) {
    sub IPW_INTR_FW_INIT_DONE () {	0x1000000;}
}
unless(defined(&IPW_INTR_FATAL_ERROR)) {
    sub IPW_INTR_FATAL_ERROR () {	0x40000000;}
}
unless(defined(&IPW_INTR_PARITY_ERROR)) {
    sub IPW_INTR_PARITY_ERROR () {	0x80000000;}
}
unless(defined(&IPW_INTR_MASK)) {
    sub IPW_INTR_MASK () {	( &IPW_INTR_TX_TRANSFER |  &IPW_INTR_RX_TRANSFER |  &IPW_INTR_STATUS_CHANGE |  &IPW_INTR_COMMAND_DONE |  &IPW_INTR_FW_INIT_DONE |  &IPW_INTR_FATAL_ERROR |  &IPW_INTR_PARITY_ERROR);}
}
unless(defined(&IPW_RST_PRINCETON_RESET)) {
    sub IPW_RST_PRINCETON_RESET () {	0x1;}
}
unless(defined(&IPW_RST_SW_RESET)) {
    sub IPW_RST_SW_RESET () {	0x80;}
}
unless(defined(&IPW_RST_MASTER_DISABLED)) {
    sub IPW_RST_MASTER_DISABLED () {	0x100;}
}
unless(defined(&IPW_RST_STOP_MASTER)) {
    sub IPW_RST_STOP_MASTER () {	0x200;}
}
unless(defined(&IPW_CTL_CLOCK_READY)) {
    sub IPW_CTL_CLOCK_READY () {	0x1;}
}
unless(defined(&IPW_CTL_ALLOW_STANDBY)) {
    sub IPW_CTL_ALLOW_STANDBY () {	0x2;}
}
unless(defined(&IPW_CTL_INIT)) {
    sub IPW_CTL_INIT () {	0x4;}
}
unless(defined(&IPW_IO_GPIO1_ENABLE)) {
    sub IPW_IO_GPIO1_ENABLE () {	0x8;}
}
unless(defined(&IPW_IO_GPIO1_MASK)) {
    sub IPW_IO_GPIO1_MASK () {	0xc;}
}
unless(defined(&IPW_IO_GPIO3_MASK)) {
    sub IPW_IO_GPIO3_MASK () {	0xc0;}
}
unless(defined(&IPW_IO_LED_OFF)) {
    sub IPW_IO_LED_OFF () {	0x2000;}
}
unless(defined(&IPW_IO_RADIO_DISABLED)) {
    sub IPW_IO_RADIO_DISABLED () {	0x10000;}
}
unless(defined(&IPW_STATE_ASSOCIATED)) {
    sub IPW_STATE_ASSOCIATED () {	0x4;}
}
unless(defined(&IPW_STATE_ASSOCIATION_LOST)) {
    sub IPW_STATE_ASSOCIATION_LOST () {	0x8;}
}
unless(defined(&IPW_STATE_SCAN_COMPLETE)) {
    sub IPW_STATE_SCAN_COMPLETE () {	0x20;}
}
unless(defined(&IPW_STATE_RADIO_DISABLED)) {
    sub IPW_STATE_RADIO_DISABLED () {	0x100;}
}
unless(defined(&IPW_STATE_DISABLED)) {
    sub IPW_STATE_DISABLED () {	0x200;}
}
unless(defined(&IPW_STATE_SCANNING)) {
    sub IPW_STATE_SCANNING () {	0x800;}
}
unless(defined(&IPW_INFO_LOCK)) {
    sub IPW_INFO_LOCK () {	480;}
}
unless(defined(&IPW_INFO_APS_CNT)) {
    sub IPW_INFO_APS_CNT () {	604;}
}
unless(defined(&IPW_INFO_APS_BASE)) {
    sub IPW_INFO_APS_BASE () {	608;}
}
unless(defined(&IPW_INFO_CARD_DISABLED)) {
    sub IPW_INFO_CARD_DISABLED () {	628;}
}
unless(defined(&IPW_INFO_CURRENT_CHANNEL)) {
    sub IPW_INFO_CURRENT_CHANNEL () {	756;}
}
unless(defined(&IPW_INFO_CURRENT_TX_RATE)) {
    sub IPW_INFO_CURRENT_TX_RATE () {	768;}
}
unless(defined(&IPW_INFO_CURRENT_SSID)) {
    sub IPW_INFO_CURRENT_SSID () {	48;}
}
unless(defined(&IPW_INFO_CURRENT_BSSID)) {
    sub IPW_INFO_CURRENT_BSSID () {	112;}
}
unless(defined(&IPW_RATE_DS1)) {
    sub IPW_RATE_DS1 () {	1;}
}
unless(defined(&IPW_RATE_DS2)) {
    sub IPW_RATE_DS2 () {	2;}
}
unless(defined(&IPW_RATE_DS5)) {
    sub IPW_RATE_DS5 () {	4;}
}
unless(defined(&IPW_RATE_DS11)) {
    sub IPW_RATE_DS11 () {	8;}
}
unless(defined(&IPW_BD_FLAG_TX_FRAME_802_3)) {
    sub IPW_BD_FLAG_TX_FRAME_802_3 () {	0x;}
}
unless(defined(&IPW_BD_FLAG_TX_NOT_LAST_FRAGMENT)) {
    sub IPW_BD_FLAG_TX_NOT_LAST_FRAGMENT () {	0x1;}
}
unless(defined(&IPW_BD_FLAG_TX_FRAME_COMMAND)) {
    sub IPW_BD_FLAG_TX_FRAME_COMMAND () {	0x2;}
}
unless(defined(&IPW_BD_FLAG_TX_FRAME_802_11)) {
    sub IPW_BD_FLAG_TX_FRAME_802_11 () {	0x4;}
}
unless(defined(&IPW_BD_FLAG_TX_LAST_FRAGMENT)) {
    sub IPW_BD_FLAG_TX_LAST_FRAGMENT () {	0x8;}
}
unless(defined(&IPW_STATUS_CODE_COMMAND)) {
    sub IPW_STATUS_CODE_COMMAND () {	0;}
}
unless(defined(&IPW_STATUS_CODE_NEWSTATE)) {
    sub IPW_STATUS_CODE_NEWSTATE () {	1;}
}
unless(defined(&IPW_STATUS_CODE_DATA_802_11)) {
    sub IPW_STATUS_CODE_DATA_802_11 () {	2;}
}
unless(defined(&IPW_STATUS_CODE_DATA_802_3)) {
    sub IPW_STATUS_CODE_DATA_802_3 () {	3;}
}
unless(defined(&IPW_STATUS_CODE_NOTIFICATION)) {
    sub IPW_STATUS_CODE_NOTIFICATION () {	4;}
}
unless(defined(&IPW_STATUS_FLAG_DECRYPTED)) {
    sub IPW_STATUS_FLAG_DECRYPTED () {	0x1;}
}
unless(defined(&IPW_STATUS_FLAG_WEP_ENCRYPTED)) {
    sub IPW_STATUS_FLAG_WEP_ENCRYPTED () {	0x2;}
}
unless(defined(&IPW_HDR_TYPE_SEND)) {
    sub IPW_HDR_TYPE_SEND () {	33;}
}
unless(defined(&IPW_CMD_ENABLE)) {
    sub IPW_CMD_ENABLE () {	2;}
}
unless(defined(&IPW_CMD_SET_CONFIGURATION)) {
    sub IPW_CMD_SET_CONFIGURATION () {	6;}
}
unless(defined(&IPW_CMD_SET_ESSID)) {
    sub IPW_CMD_SET_ESSID () {	8;}
}
unless(defined(&IPW_CMD_SET_MANDATORY_BSSID)) {
    sub IPW_CMD_SET_MANDATORY_BSSID () {	9;}
}
unless(defined(&IPW_CMD_SET_MAC_ADDRESS)) {
    sub IPW_CMD_SET_MAC_ADDRESS () {	11;}
}
unless(defined(&IPW_CMD_SET_MODE)) {
    sub IPW_CMD_SET_MODE () {	12;}
}
unless(defined(&IPW_CMD_SET_CHANNEL)) {
    sub IPW_CMD_SET_CHANNEL () {	14;}
}
unless(defined(&IPW_CMD_SET_RTS_THRESHOLD)) {
    sub IPW_CMD_SET_RTS_THRESHOLD () {	15;}
}
unless(defined(&IPW_CMD_SET_FRAG_THRESHOLD)) {
    sub IPW_CMD_SET_FRAG_THRESHOLD () {	16;}
}
unless(defined(&IPW_CMD_SET_POWER_MODE)) {
    sub IPW_CMD_SET_POWER_MODE () {	17;}
}
unless(defined(&IPW_CMD_SET_TX_RATES)) {
    sub IPW_CMD_SET_TX_RATES () {	18;}
}
unless(defined(&IPW_CMD_SET_BASIC_TX_RATES)) {
    sub IPW_CMD_SET_BASIC_TX_RATES () {	19;}
}
unless(defined(&IPW_CMD_SET_WEP_KEY)) {
    sub IPW_CMD_SET_WEP_KEY () {	20;}
}
unless(defined(&IPW_CMD_SET_WEP_KEY_INDEX)) {
    sub IPW_CMD_SET_WEP_KEY_INDEX () {	25;}
}
unless(defined(&IPW_CMD_SET_WEP_FLAGS)) {
    sub IPW_CMD_SET_WEP_FLAGS () {	26;}
}
unless(defined(&IPW_CMD_ADD_MULTICAST)) {
    sub IPW_CMD_ADD_MULTICAST () {	27;}
}
unless(defined(&IPW_CMD_SET_BEACON_INTERVAL)) {
    sub IPW_CMD_SET_BEACON_INTERVAL () {	29;}
}
unless(defined(&IPW_CMD_SET_TX_POWER_INDEX)) {
    sub IPW_CMD_SET_TX_POWER_INDEX () {	36;}
}
unless(defined(&IPW_CMD_BROADCAST_SCAN)) {
    sub IPW_CMD_BROADCAST_SCAN () {	43;}
}
unless(defined(&IPW_CMD_DISABLE)) {
    sub IPW_CMD_DISABLE () {	44;}
}
unless(defined(&IPW_CMD_SET_DESIRED_BSSID)) {
    sub IPW_CMD_SET_DESIRED_BSSID () {	45;}
}
unless(defined(&IPW_CMD_SET_SCAN_OPTIONS)) {
    sub IPW_CMD_SET_SCAN_OPTIONS () {	46;}
}
unless(defined(&IPW_CMD_PREPARE_POWER_DOWN)) {
    sub IPW_CMD_PREPARE_POWER_DOWN () {	58;}
}
unless(defined(&IPW_CMD_DISABLE_PHY)) {
    sub IPW_CMD_DISABLE_PHY () {	61;}
}
unless(defined(&IPW_CMD_SET_SECURITY_INFORMATION)) {
    sub IPW_CMD_SET_SECURITY_INFORMATION () {	67;}
}
unless(defined(&IPW_POWER_MODE_CAM)) {
    sub IPW_POWER_MODE_CAM () {	0;}
}
unless(defined(&IPW_POWER_AUTOMATIC)) {
    sub IPW_POWER_AUTOMATIC () {	6;}
}
unless(defined(&IPW_MODE_BSS)) {
    sub IPW_MODE_BSS () {	0;}
}
unless(defined(&IPW_MODE_IBSS)) {
    sub IPW_MODE_IBSS () {	1;}
}
unless(defined(&IPW_MODE_MONITOR)) {
    sub IPW_MODE_MONITOR () {	2;}
}
unless(defined(&IPW_WEPON)) {
    sub IPW_WEPON () {	0x8;}
}
unless(defined(&IPW_CIPHER_NONE)) {
    sub IPW_CIPHER_NONE () {	0x1;}
}
unless(defined(&IPW_CIPHER_WEP40)) {
    sub IPW_CIPHER_WEP40 () {	0x2;}
}
unless(defined(&IPW_CIPHER_WEP104)) {
    sub IPW_CIPHER_WEP104 () {	0x20;}
}
unless(defined(&IPW_AUTH_OPEN)) {
    sub IPW_AUTH_OPEN () {	0;}
}
unless(defined(&IPW_AUTH_SHARED)) {
    sub IPW_AUTH_SHARED () {	1;}
}
unless(defined(&IPW_SCAN_DO_NOT_ASSOCIATE)) {
    sub IPW_SCAN_DO_NOT_ASSOCIATE () {	0x1;}
}
unless(defined(&IPW_SCAN_PASSIVE)) {
    sub IPW_SCAN_PASSIVE () {	0x8;}
}
unless(defined(&IPW_CFG_PROMISCUOUS)) {
    sub IPW_CFG_PROMISCUOUS () {	0x4;}
}
unless(defined(&IPW_CFG_PREAMBLE_AUTO)) {
    sub IPW_CFG_PREAMBLE_AUTO () {	0x10;}
}
unless(defined(&IPW_CFG_IBSS_AUTO_START)) {
    sub IPW_CFG_IBSS_AUTO_START () {	0x20;}
}
unless(defined(&IPW_CFG_802_1x_ENABLE)) {
    sub IPW_CFG_802_1x_ENABLE () {	0x4000;}
}
unless(defined(&IPW_CFG_BSS_MASK)) {
    sub IPW_CFG_BSS_MASK () {	0x8000;}
}
unless(defined(&IPW_CFG_IBSS_MASK)) {
    sub IPW_CFG_IBSS_MASK () {	0x10000;}
}
unless(defined(&IPW_MEM_EEPROM_CTL)) {
    sub IPW_MEM_EEPROM_CTL () {	0x300040;}
}
unless(defined(&IPW_EEPROM_MAC)) {
    sub IPW_EEPROM_MAC () {	0x21;}
}
unless(defined(&IPW_EEPROM_DELAY)) {
    sub IPW_EEPROM_DELAY () {	1;}
}
unless(defined(&IPW_EEPROM_C)) {
    sub IPW_EEPROM_C () {	(1<< 0);}
}
unless(defined(&IPW_EEPROM_S)) {
    sub IPW_EEPROM_S () {	(1<< 1);}
}
unless(defined(&IPW_EEPROM_D)) {
    sub IPW_EEPROM_D () {	(1<< 2);}
}
unless(defined(&IPW_EEPROM_Q)) {
    sub IPW_EEPROM_Q () {	(1<< 4);}
}
unless(defined(&IPW_EEPROM_SHIFT_D)) {
    sub IPW_EEPROM_SHIFT_D () {	2;}
}
unless(defined(&IPW_EEPROM_SHIFT_Q)) {
    sub IPW_EEPROM_SHIFT_Q () {	4;}
}
unless(defined(&CSR_READ_1)) {
    sub CSR_READ_1 {
	local($sc, $reg) = @_;
	eval q( &bus_space_read_1(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg)));
    }
}
unless(defined(&CSR_READ_2)) {
    sub CSR_READ_2 {
	local($sc, $reg) = @_;
	eval q( &bus_space_read_2(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg)));
    }
}
unless(defined(&CSR_READ_4)) {
    sub CSR_READ_4 {
	local($sc, $reg) = @_;
	eval q( &bus_space_read_4(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg)));
    }
}
unless(defined(&CSR_WRITE_1)) {
    sub CSR_WRITE_1 {
	local($sc, $reg, $val) = @_;
	eval q( &bus_space_write_1(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg), ($val)));
    }
}
unless(defined(&CSR_WRITE_2)) {
    sub CSR_WRITE_2 {
	local($sc, $reg, $val) = @_;
	eval q( &bus_space_write_2(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg), ($val)));
    }
}
unless(defined(&CSR_WRITE_4)) {
    sub CSR_WRITE_4 {
	local($sc, $reg, $val) = @_;
	eval q( &bus_space_write_4(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg), ($val)));
    }
}
unless(defined(&CSR_WRITE_MULTI_1)) {
    sub CSR_WRITE_MULTI_1 {
	local($sc, $reg, $buf, $len) = @_;
	eval q( &bus_space_write_multi_1(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg), ($buf), ($len)));
    }
}
unless(defined(&MEM_WRITE_1)) {
    sub MEM_WRITE_1 {
	local($sc, $addr, $val) = @_;
	eval q( &do {  &CSR_WRITE_4(($sc),  &IPW_CSR_INDIRECT_ADDR, ($addr));  &CSR_WRITE_1(($sc),  &IPW_CSR_INDIRECT_DATA, ($val)); }  &while ( 0));
    }
}
unless(defined(&MEM_WRITE_2)) {
    sub MEM_WRITE_2 {
	local($sc, $addr, $val) = @_;
	eval q( &do {  &CSR_WRITE_4(($sc),  &IPW_CSR_INDIRECT_ADDR, ($addr));  &CSR_WRITE_2(($sc),  &IPW_CSR_INDIRECT_DATA, ($val)); }  &while ( 0));
    }
}
unless(defined(&MEM_WRITE_4)) {
    sub MEM_WRITE_4 {
	local($sc, $addr, $val) = @_;
	eval q( &do {  &CSR_WRITE_4(($sc),  &IPW_CSR_INDIRECT_ADDR, ($addr));  &CSR_WRITE_4(($sc),  &IPW_CSR_INDIRECT_DATA, ($val)); }  &while ( 0));
    }
}
unless(defined(&MEM_WRITE_MULTI_1)) {
    sub MEM_WRITE_MULTI_1 {
	local($sc, $addr, $buf, $len) = @_;
	eval q( &do {  &CSR_WRITE_4(($sc),  &IPW_CSR_INDIRECT_ADDR, ($addr));  &CSR_WRITE_MULTI_1(($sc),  &IPW_CSR_INDIRECT_DATA, ($buf), ($len)); }  &while ( 0));
    }
}
unless(defined(&IPW_EEPROM_CTL)) {
    sub IPW_EEPROM_CTL {
	local($sc, $val) = @_;
	eval q( &do {  &MEM_WRITE_4(($sc),  &IPW_MEM_EEPROM_CTL, ($val));  &DELAY( &IPW_EEPROM_DELAY); }  &while (0));
    }
}
1;
