require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__M88K_M8820X_H__)) {
    eval 'sub __M88K_M8820X_H__ () {1;}' unless defined(&__M88K_M8820X_H__);
    eval 'sub CMMU_IDR () {(0x / 4);}' unless defined(&CMMU_IDR);
    eval 'sub CMMU_SCR () {(0x4 / 4);}' unless defined(&CMMU_SCR);
    eval 'sub CMMU_SSR () {(0x8 / 4);}' unless defined(&CMMU_SSR);
    eval 'sub CMMU_SAR () {(0xc / 4);}' unless defined(&CMMU_SAR);
    eval 'sub CMMU_SCTR () {(0x104 / 4);}' unless defined(&CMMU_SCTR);
    eval 'sub CMMU_PFSR () {(0x108 / 4);}' unless defined(&CMMU_PFSR);
    eval 'sub CMMU_PFAR () {(0x10c / 4);}' unless defined(&CMMU_PFAR);
    eval 'sub CMMU_SAPR () {(0x200 / 4);}' unless defined(&CMMU_SAPR);
    eval 'sub CMMU_UAPR () {(0x204 / 4);}' unless defined(&CMMU_UAPR);
    eval 'sub CMMU_BWP0 () {(0x400 / 4);}' unless defined(&CMMU_BWP0);
    eval 'sub CMMU_BWP1 () {(0x404 / 4);}' unless defined(&CMMU_BWP1);
    eval 'sub CMMU_BWP2 () {(0x408 / 4);}' unless defined(&CMMU_BWP2);
    eval 'sub CMMU_BWP3 () {(0x40c / 4);}' unless defined(&CMMU_BWP3);
    eval 'sub CMMU_BWP4 () {(0x410 / 4);}' unless defined(&CMMU_BWP4);
    eval 'sub CMMU_BWP5 () {(0x414 / 4);}' unless defined(&CMMU_BWP5);
    eval 'sub CMMU_BWP6 () {(0x418 / 4);}' unless defined(&CMMU_BWP6);
    eval 'sub CMMU_BWP7 () {(0x41c / 4);}' unless defined(&CMMU_BWP7);
    eval 'sub CMMU_BWP {
        local($n) = @_;
	    eval q(( &CMMU_BWP0 + ($n)));
    }' unless defined(&CMMU_BWP);
    eval 'sub CMMU_CDP0 () {(0x800 / 4);}' unless defined(&CMMU_CDP0);
    eval 'sub CMMU_CDP1 () {(0x804 / 4);}' unless defined(&CMMU_CDP1);
    eval 'sub CMMU_CDP2 () {(0x808 / 4);}' unless defined(&CMMU_CDP2);
    eval 'sub CMMU_CDP3 () {(0x80c / 4);}' unless defined(&CMMU_CDP3);
    eval 'sub CMMU_CTP0 () {(0x840 / 4);}' unless defined(&CMMU_CTP0);
    eval 'sub CMMU_CTP1 () {(0x844 / 4);}' unless defined(&CMMU_CTP1);
    eval 'sub CMMU_CTP2 () {(0x848 / 4);}' unless defined(&CMMU_CTP2);
    eval 'sub CMMU_CTP3 () {(0x84c / 4);}' unless defined(&CMMU_CTP3);
    eval 'sub CMMU_CSSP0 () {(0x880 / 4);}' unless defined(&CMMU_CSSP0);
    eval 'sub CMMU_CSSP {
        local($n) = @_;
	    eval q(((0x880 + ($n * 0x10)) / 4));
    }' unless defined(&CMMU_CSSP);
    eval 'sub CMMU_CSSP1 () {(0x890 / 4);}' unless defined(&CMMU_CSSP1);
    eval 'sub CMMU_CSSP2 () {(0x8a0 / 4);}' unless defined(&CMMU_CSSP2);
    eval 'sub CMMU_CSSP3 () {(0x8b0 / 4);}' unless defined(&CMMU_CSSP3);
    eval 'sub CMMU_FLUSH_CACHE_INV_LINE () {0x14;}' unless defined(&CMMU_FLUSH_CACHE_INV_LINE);
    eval 'sub CMMU_FLUSH_CACHE_INV_PAGE () {0x15;}' unless defined(&CMMU_FLUSH_CACHE_INV_PAGE);
    eval 'sub CMMU_FLUSH_CACHE_INV_SEGMENT () {0x16;}' unless defined(&CMMU_FLUSH_CACHE_INV_SEGMENT);
    eval 'sub CMMU_FLUSH_CACHE_INV_ALL () {0x17;}' unless defined(&CMMU_FLUSH_CACHE_INV_ALL);
    eval 'sub CMMU_FLUSH_CACHE_CB_LINE () {0x18;}' unless defined(&CMMU_FLUSH_CACHE_CB_LINE);
    eval 'sub CMMU_FLUSH_CACHE_CB_PAGE () {0x19;}' unless defined(&CMMU_FLUSH_CACHE_CB_PAGE);
    eval 'sub CMMU_FLUSH_CACHE_CB_SEGMENT () {0x1a;}' unless defined(&CMMU_FLUSH_CACHE_CB_SEGMENT);
    eval 'sub CMMU_FLUSH_CACHE_CB_ALL () {0x1b;}' unless defined(&CMMU_FLUSH_CACHE_CB_ALL);
    eval 'sub CMMU_FLUSH_CACHE_CBI_LINE () {0x1c;}' unless defined(&CMMU_FLUSH_CACHE_CBI_LINE);
    eval 'sub CMMU_FLUSH_CACHE_CBI_PAGE () {0x1d;}' unless defined(&CMMU_FLUSH_CACHE_CBI_PAGE);
    eval 'sub CMMU_FLUSH_CACHE_CBI_SEGMENT () {0x1e;}' unless defined(&CMMU_FLUSH_CACHE_CBI_SEGMENT);
    eval 'sub CMMU_FLUSH_CACHE_CBI_ALL () {0x1f;}' unless defined(&CMMU_FLUSH_CACHE_CBI_ALL);
    eval 'sub CMMU_PROBE_USER () {0x20;}' unless defined(&CMMU_PROBE_USER);
    eval 'sub CMMU_PROBE_SUPER () {0x24;}' unless defined(&CMMU_PROBE_SUPER);
    eval 'sub CMMU_FLUSH_USER_LINE () {0x30;}' unless defined(&CMMU_FLUSH_USER_LINE);
    eval 'sub CMMU_FLUSH_USER_PAGE () {0x31;}' unless defined(&CMMU_FLUSH_USER_PAGE);
    eval 'sub CMMU_FLUSH_USER_SEGMENT () {0x32;}' unless defined(&CMMU_FLUSH_USER_SEGMENT);
    eval 'sub CMMU_FLUSH_USER_ALL () {0x33;}' unless defined(&CMMU_FLUSH_USER_ALL);
    eval 'sub CMMU_FLUSH_SUPER_LINE () {0x34;}' unless defined(&CMMU_FLUSH_SUPER_LINE);
    eval 'sub CMMU_FLUSH_SUPER_PAGE () {0x35;}' unless defined(&CMMU_FLUSH_SUPER_PAGE);
    eval 'sub CMMU_FLUSH_SUPER_SEGMENT () {0x36;}' unless defined(&CMMU_FLUSH_SUPER_SEGMENT);
    eval 'sub CMMU_FLUSH_SUPER_ALL () {0x37;}' unless defined(&CMMU_FLUSH_SUPER_ALL);
    eval 'sub CMMU_SCTR_PE () {0x8000;}' unless defined(&CMMU_SCTR_PE);
    eval 'sub CMMU_SCTR_SE () {0x4000;}' unless defined(&CMMU_SCTR_SE);
    eval 'sub CMMU_SCTR_PR () {0x2000;}' unless defined(&CMMU_SCTR_PR);
    eval 'sub CMMU_PFSR_FAULT {
        local($pfsr) = @_;
	    eval q(((($pfsr) >> 16) & 0x7));
    }' unless defined(&CMMU_PFSR_FAULT);
    eval 'sub CMMU_PFSR_SUCCESS () {0;}' unless defined(&CMMU_PFSR_SUCCESS);
    eval 'sub CMMU_PFSR_BERROR () {3;}' unless defined(&CMMU_PFSR_BERROR);
    eval 'sub CMMU_PFSR_SFAULT () {4;}' unless defined(&CMMU_PFSR_SFAULT);
    eval 'sub CMMU_PFSR_PFAULT () {5;}' unless defined(&CMMU_PFSR_PFAULT);
    eval 'sub CMMU_PFSR_SUPER () {6;}' unless defined(&CMMU_PFSR_SUPER);
    eval 'sub CMMU_PFSR_WRITE () {7;}' unless defined(&CMMU_PFSR_WRITE);
    eval 'sub CMMU_CSSP_L5 () {0x20000000;}' unless defined(&CMMU_CSSP_L5);
    eval 'sub CMMU_CSSP_L4 () {0x10000000;}' unless defined(&CMMU_CSSP_L4);
    eval 'sub CMMU_CSSP_L3 () {0x8000000;}' unless defined(&CMMU_CSSP_L3);
    eval 'sub CMMU_CSSP_L2 () {0x4000000;}' unless defined(&CMMU_CSSP_L2);
    eval 'sub CMMU_CSSP_L1 () {0x2000000;}' unless defined(&CMMU_CSSP_L1);
    eval 'sub CMMU_CSSP_L0 () {0x1000000;}' unless defined(&CMMU_CSSP_L0);
    eval 'sub CMMU_CSSP_D3 () {0x800000;}' unless defined(&CMMU_CSSP_D3);
    eval 'sub CMMU_CSSP_D2 () {0x400000;}' unless defined(&CMMU_CSSP_D2);
    eval 'sub CMMU_CSSP_D1 () {0x200000;}' unless defined(&CMMU_CSSP_D1);
    eval 'sub CMMU_CSSP_D0 () {0x100000;}' unless defined(&CMMU_CSSP_D0);
    eval 'sub CMMU_CSSP_VV {
        local($n,$v) = @_;
	    eval q(((($v) & 0x3) << (12+ 2* ($n))));
    }' unless defined(&CMMU_CSSP_VV);
    eval 'sub CMMU_VV_EXCLUSIVE () {0x;}' unless defined(&CMMU_VV_EXCLUSIVE);
    eval 'sub CMMU_VV_MODIFIED () {0x1;}' unless defined(&CMMU_VV_MODIFIED);
    eval 'sub CMMU_VV_SHARED () {0x2;}' unless defined(&CMMU_VV_SHARED);
    eval 'sub CMMU_VV_INVALID () {0x3;}' unless defined(&CMMU_VV_INVALID);
    eval 'sub CMMU_ID {
        local($idr) = @_;
	    eval q((($idr) >> 24));
    }' unless defined(&CMMU_ID);
    eval 'sub CMMU_TYPE {
        local($idr) = @_;
	    eval q(((($idr) >> 21) & 0x7));
    }' unless defined(&CMMU_TYPE);
    eval 'sub CMMU_VERSION {
        local($idr) = @_;
	    eval q(((($idr) >> 16) & 0x1f));
    }' unless defined(&CMMU_VERSION);
    eval 'sub M88200_ID () {5;}' unless defined(&M88200_ID);
    eval 'sub M88204_ID () {6;}' unless defined(&M88204_ID);
    eval 'sub CMMU_SSR_CE () {0x8000;}' unless defined(&CMMU_SSR_CE);
    eval 'sub CMMU_SSR_BE () {0x4000;}' unless defined(&CMMU_SSR_BE);
    eval 'sub CMMU_SSR_SO () {0x100;}' unless defined(&CMMU_SSR_SO);
    eval 'sub CMMU_SSR_M () {0x10;}' unless defined(&CMMU_SSR_M);
    eval 'sub CMMU_SSR_U () {0x8;}' unless defined(&CMMU_SSR_U);
    eval 'sub CMMU_SSR_PROT () {0x4;}' unless defined(&CMMU_SSR_PROT);
    eval 'sub CMMU_SSR_BH () {0x2;}' unless defined(&CMMU_SSR_BH);
    eval 'sub CMMU_SSR_V () {0x1;}' unless defined(&CMMU_SSR_V);
    eval 'sub MC88200_CACHE_SHIFT () {4;}' unless defined(&MC88200_CACHE_SHIFT);
    eval 'sub MC88200_CACHE_LINE () {(1<<  &MC88200_CACHE_SHIFT);}' unless defined(&MC88200_CACHE_LINE);
    eval 'sub NBSG () {(1<< ( &PDT_BITS +  &PG_BITS));}' unless defined(&NBSG);
    unless(defined(&_LOCORE)) {
	if(defined(&M88200_HAS_SPLIT_ADDRESS)) {
	}
	eval 'sub INST_CMMU () {0x;}' unless defined(&INST_CMMU);
	eval 'sub DATA_CMMU () {0x1;}' unless defined(&DATA_CMMU);
	eval 'sub CMMU_MODE {
	    local($num) = @_;
    	    eval q((($num) & 1));
	}' unless defined(&CMMU_MODE);
	eval 'sub MAX_CMMUS () {8;}' unless defined(&MAX_CMMUS);
    }
}
1;
