## Script (Python) "isIDAutoGenerated"
##bind container=container
##bind context=context
##bind namespace=
##bind script=script
##bind subpath=traverse_subpath
##parameters=id=None
##title=
##
#autogenerated Ids look like $portal_type.YYYY-MM-DD.integer(random number)

try:
    from DateTime.DateTime import SyntaxError
except ImportError:
    class SyntaxError: pass

from DateTime import DateTime

autogenerated=0

if id is None:
    id=context.getId()

try:
    obj_type, date_created, random_number = id.split('.')
    type=' '.join(obj_type.split('_'))
    portaltypes=context.portal_types.objectIds()
    # new autogenerated ids may have a lower case portal type
    if (type in portaltypes or type in [pt.lower() for pt in portaltypes] ) \
      and DateTime(date_created) and float(random_number):
        autogenerated=1
except (ValueError, AttributeError, IndexError, SyntaxError):
    pass

return autogenerated
