<?php

require_once 'Horde/iCalendar.php';

/**
 * Horde Kronolith free/busy driver for the Kolab IMAP Server.
 * Copyright 2004-2005 Horde Project (http://horde.org/)
 *
 * $Horde: kronolith/lib/Storage/kolab.php,v 1.4.10.1 2005/01/03 12:25:40 jan Exp $
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 *
 * @author  Stuart Binge <omicron@mighty.co.za>
 * @version $Revision: 1.4.10.1 $
 * @package Kronolith
 */
class Kronolith_Storage_kolab extends Kronolith_Storage {

    var $_params = array();

    function Kronolith_Storage_kolab($user, $params = array())
    {
        $this->_user = $user;
        $this->_params = $params;
    }

    function search($email, $private_only = false)
    {
        global $conf;

        $fb_url = 'http://' . $conf['kolab']['imap']['server'] . "/freebusy/$email.vfb";
        $vfb_text = file_get_contents($fb_url);
        if ($vfb_text === false) {
            return PEAR::raiseError(sprintf(_("Unable to retrieve free/busy information for %s"),
                                    $email), KRONOLITH_ERROR_FB_NOT_FOUND);
        }

        $iCal = new Horde_iCalendar;
        $iCal->parsevCalendar($vfb_text);

        $vfb = &$iCal->findComponent('VFREEBUSY');
        if ($vfb === false) {
            return PEAR::raiseError(sprintf(_("No free/busy information is available for %s"),
                                    $email), KRONOLITH_ERROR_FB_NOT_FOUND);
        }

        return $vfb;
    }

    function store($email, $vfb, $public = false)
    {
        // We don't care about storing FB info at the moment; we rather let
        // Kolab's freebusy.php script auto-generate it for us.
        return true;
    }

}
