/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.connector;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.apache.webapp.admin.ApplicationServlet;
import org.apache.webapp.admin.connector.ConnectorsForm;

public class DeleteConnectorAction
extends Action {
    private MBeanServer mBServer = null;
    private MessageResources resources = null;

    public ActionForward perform(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HttpSession session = request.getSession();
        Locale locale = (Locale)session.getAttribute("org.apache.struts.action.LOCALE");
        if (this.resources == null) {
            this.resources = this.getServlet().getResources();
        }
        try {
            this.mBServer = ((ApplicationServlet)this.getServlet()).getServer();
        }
        catch (Throwable t) {
            throw new ServletException("Cannot acquire MBeanServer reference", t);
        }
        String domain = null;
        ConnectorsForm connectorsForm = new ConnectorsForm();
        String select = request.getParameter("select");
        if (select != null) {
            String[] connectors = new String[]{select};
            connectorsForm.setConnectors(connectors);
            try {
                domain = new ObjectName(select).getDomain();
            }
            catch (Exception e) {
                throw new ServletException("Error extracting service name from the connector to be deleted", (Throwable)e);
            }
        }
        request.setAttribute("connectorsForm", (Object)connectorsForm);
        ArrayList<String> list = new ArrayList<String>();
        try {
            String pattern = domain + ":type=Connector" + ",*";
            Iterator<ObjectName> items = this.mBServer.queryNames(new ObjectName(pattern), null).iterator();
            while (items.hasNext()) {
                ObjectName item = items.next();
                list.add(((Object)item).toString());
            }
        }
        catch (Exception e) {
            this.getServlet().log(this.resources.getMessage(locale, "users.error.select"));
            response.sendError(500, this.resources.getMessage(locale, "users.error.select"));
            return null;
        }
        Collections.sort(list);
        request.setAttribute("connectorsList", list);
        return mapping.findForward("Connectors");
    }
}

