/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin;

import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Locale;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts.util.MessageResources;
import org.apache.webapp.admin.ApplicationServlet;
import org.apache.webapp.admin.Lists;
import org.apache.webapp.admin.TreeBuilder;
import org.apache.webapp.admin.TreeControl;
import org.apache.webapp.admin.TreeControlNode;

public class TomcatTreeBuilder
implements TreeBuilder {
    private static final String SERVER_LABEL = "Tomcat Server";
    public static final String DEFAULT_DOMAIN = "Catalina";
    public static final String SERVER_TYPE = ":type=Server";
    public static final String FACTORY_TYPE = "Catalina:type=MBeanFactory";
    public static final String SERVICE_TYPE = ":type=Service";
    public static final String ENGINE_TYPE = ":type=Engine";
    public static final String CONNECTOR_TYPE = ":type=Connector";
    public static final String HOST_TYPE = ":type=Host";
    public static final String CONTEXT_TYPE = ":type=Context";
    public static final String DEFAULTCONTEXT_TYPE = ":type=DefaultContext";
    public static final String LOADER_TYPE = ":type=Loader";
    public static final String MANAGER_TYPE = ":type=Manager";
    public static final String LOGGER_TYPE = ":type=Logger";
    public static final String REALM_TYPE = ":type=Realm";
    public static final String VALVE_TYPE = ":type=Valve";
    public static final String WILDCARD = ",*";
    private static MBeanServer mBServer = null;
    private MessageResources resources = null;
    private Locale locale = null;

    public void buildTree(TreeControl treeControl, ApplicationServlet servlet, HttpServletRequest request) {
        try {
            HttpSession session = request.getSession();
            this.locale = (Locale)session.getAttribute("org.apache.struts.action.LOCALE");
            mBServer = servlet.getServer();
            TreeControlNode root = treeControl.getRoot();
            this.resources = (MessageResources)servlet.getServletContext().getAttribute("org.apache.struts.action.MESSAGE");
            this.getServers(root);
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
        }
    }

    public static ObjectName getMBeanFactory() throws MalformedObjectNameException {
        return new ObjectName(FACTORY_TYPE);
    }

    public void getServers(TreeControlNode rootNode) throws Exception {
        String domain = rootNode.getDomain();
        Iterator serverNames = Lists.getServers(mBServer, domain).iterator();
        while (serverNames.hasNext()) {
            String serverName = (String)serverNames.next();
            ObjectName objectName = new ObjectName(serverName);
            String nodeLabel = SERVER_LABEL;
            TreeControlNode serverNode = new TreeControlNode(serverName, "Server.gif", nodeLabel, "EditServer.do?select=" + URLEncoder.encode(serverName) + "&nodeLabel=" + URLEncoder.encode(nodeLabel), "content", true, domain);
            rootNode.addChild(serverNode);
            this.getServices(serverNode, serverName);
        }
    }

    public void getServices(TreeControlNode serverNode, String serverName) throws Exception {
        String domain = serverNode.getDomain();
        Iterator serviceNames = Lists.getServices(mBServer, serverName).iterator();
        while (serviceNames.hasNext()) {
            String serviceName = (String)serviceNames.next();
            ObjectName objectName = new ObjectName(serviceName);
            String nodeLabel = this.resources.getMessage(this.locale, "server.service.treeBuilder.subtreeNode") + " (" + objectName.getKeyProperty("serviceName") + ")";
            TreeControlNode serviceNode = new TreeControlNode(serviceName, "Service.gif", nodeLabel, "EditService.do?select=" + URLEncoder.encode(serviceName) + "&nodeLabel=" + URLEncoder.encode(nodeLabel), "content", false, domain);
            serverNode.addChild(serviceNode);
            this.getConnectors(serviceNode, serviceName);
            this.getDefaultContexts(serviceNode, serviceName);
            this.getHosts(serviceNode, serviceName);
            this.getLoggers(serviceNode, serviceName);
            this.getRealms(serviceNode, serviceName);
            this.getValves(serviceNode, serviceName);
        }
    }

    public void getConnectors(TreeControlNode serviceNode, String serviceName) throws Exception {
        String domain = serviceNode.getDomain();
        Iterator connectorNames = Lists.getConnectors(mBServer, serviceName).iterator();
        while (connectorNames.hasNext()) {
            String connectorName = (String)connectorNames.next();
            ObjectName objectName = new ObjectName(connectorName);
            String nodeLabel = this.resources.getMessage(this.locale, "server.service.treeBuilder.connector") + " (" + objectName.getKeyProperty("port") + ")";
            TreeControlNode connectorNode = new TreeControlNode(connectorName, "Connector.gif", nodeLabel, "EditConnector.do?select=" + URLEncoder.encode(connectorName) + "&nodeLabel=" + URLEncoder.encode(nodeLabel), "content", false, domain);
            serviceNode.addChild(connectorNode);
        }
    }

    public void getHosts(TreeControlNode serviceNode, String serviceName) throws Exception {
        String domain = serviceNode.getDomain();
        Iterator hostNames = Lists.getHosts(mBServer, serviceName).iterator();
        while (hostNames.hasNext()) {
            String hostName = (String)hostNames.next();
            ObjectName objectName = new ObjectName(hostName);
            String nodeLabel = this.resources.getMessage(this.locale, "server.service.treeBuilder.host") + " (" + objectName.getKeyProperty("host") + ")";
            TreeControlNode hostNode = new TreeControlNode(hostName, "Host.gif", nodeLabel, "EditHost.do?select=" + URLEncoder.encode(hostName) + "&nodeLabel=" + URLEncoder.encode(nodeLabel), "content", false, domain);
            serviceNode.addChild(hostNode);
            this.getContexts(hostNode, hostName);
            this.getDefaultContexts(hostNode, hostName);
            this.getLoggers(hostNode, hostName);
            this.getRealms(hostNode, hostName);
            this.getValves(hostNode, hostName);
        }
    }

    public void getContexts(TreeControlNode hostNode, String hostName) throws Exception {
        String domain = hostNode.getDomain();
        Iterator contextNames = Lists.getContexts(mBServer, hostName).iterator();
        while (contextNames.hasNext()) {
            String contextName = (String)contextNames.next();
            ObjectName objectName = new ObjectName(contextName);
            String name = objectName.getKeyProperty("name");
            name = name.substring(2);
            int i = name.indexOf("/");
            String path = name.substring(i);
            String nodeLabel = this.resources.getMessage(this.locale, "server.service.treeBuilder.context") + " (" + path + ")";
            TreeControlNode contextNode = new TreeControlNode(contextName, "Context.gif", nodeLabel, "EditContext.do?select=" + URLEncoder.encode(contextName) + "&nodeLabel=" + URLEncoder.encode(nodeLabel), "content", false, domain);
            hostNode.addChild(contextNode);
            this.getResources(contextNode, contextName);
            this.getLoggers(contextNode, contextName);
            this.getRealms(contextNode, contextName);
            this.getValves(contextNode, contextName);
        }
    }

    public void getDefaultContexts(TreeControlNode hostNode, String containerName) throws Exception {
        String domain = hostNode.getDomain();
        Iterator defaultContextNames = Lists.getDefaultContexts(mBServer, containerName).iterator();
        while (defaultContextNames.hasNext()) {
            String defaultContextName = (String)defaultContextNames.next();
            ObjectName objectName = new ObjectName(defaultContextName);
            String nodeLabel = "DefaultContext";
            TreeControlNode defaultContextNode = new TreeControlNode(defaultContextName, "DefaultContext.gif", nodeLabel, "EditDefaultContext.do?select=" + URLEncoder.encode(defaultContextName) + "&nodeLabel=" + URLEncoder.encode(nodeLabel), "content", false, domain);
            hostNode.addChild(defaultContextNode);
            this.getResources(defaultContextNode, defaultContextName);
        }
    }

    public void getLoggers(TreeControlNode containerNode, String containerName) throws Exception {
        String domain = containerNode.getDomain();
        Iterator loggerNames = Lists.getLoggers(mBServer, containerName).iterator();
        while (loggerNames.hasNext()) {
            String loggerName = (String)loggerNames.next();
            ObjectName objectName = new ObjectName(loggerName);
            String nodeLabel = this.resources.getMessage(this.locale, "server.service.treeBuilder.loggerFor", (Object)containerNode.getLabel());
            TreeControlNode loggerNode = new TreeControlNode(loggerName, "Logger.gif", nodeLabel, "EditLogger.do?select=" + URLEncoder.encode(loggerName) + "&nodeLabel=" + URLEncoder.encode(nodeLabel), "content", false, domain);
            containerNode.addChild(loggerNode);
        }
    }

    public void getRealms(TreeControlNode containerNode, String containerName) throws Exception {
        String domain = containerNode.getDomain();
        Iterator realmNames = Lists.getRealms(mBServer, containerName).iterator();
        while (realmNames.hasNext()) {
            String realmName = (String)realmNames.next();
            ObjectName objectName = new ObjectName(realmName);
            try {
                mBServer.getAttribute(objectName, "validate");
            }
            catch (AttributeNotFoundException e) {
                String nodeLabel = this.resources.getMessage(this.locale, "server.service.treeBuilder.realmFor", (Object)containerNode.getLabel());
                TreeControlNode realmNode = new TreeControlNode(realmName, "Realm.gif", nodeLabel, "EditRealm.do?select=" + URLEncoder.encode(realmName) + "&nodeLabel=" + URLEncoder.encode(nodeLabel), "content", false, domain);
                containerNode.addChild(realmNode);
            }
        }
    }

    public void getResources(TreeControlNode containerNode, String containerName) throws Exception {
        String domain = containerNode.getDomain();
        ObjectName oname = new ObjectName(containerName);
        String type = oname.getKeyProperty("type");
        if (type == null) {
            type = oname.getKeyProperty("j2eeType");
            type = type.equals("WebModule") ? "Context" : "";
        }
        String path = "";
        String host = "";
        String name = oname.getKeyProperty("name");
        if (name != null && name.length() > 0) {
            name = name.substring(2);
            int i = name.indexOf("/");
            host = name.substring(0, i);
            path = name.substring(i);
        }
        TreeControlNode subtree = new TreeControlNode("Context Resource Administration " + containerName, "folder_16_pad.gif", this.resources.getMessage(this.locale, "resources.treeBuilder.subtreeNode"), null, "content", true, domain);
        containerNode.addChild(subtree);
        TreeControlNode datasources = new TreeControlNode("Context Data Sources " + containerName, "Datasource.gif", this.resources.getMessage(this.locale, "resources.treeBuilder.datasources"), "resources/listDataSources.do?resourcetype=" + URLEncoder.encode(type) + "&path=" + URLEncoder.encode(path) + "&host=" + URLEncoder.encode(host) + "&domain=" + URLEncoder.encode(domain) + "&forward=" + URLEncoder.encode("DataSources List Setup"), "content", false, domain);
        TreeControlNode mailsessions = new TreeControlNode("Context Mail Sessions " + containerName, "Mailsession.gif", this.resources.getMessage(this.locale, "resources.treeBuilder.mailsessions"), "resources/listMailSessions.do?resourcetype=" + URLEncoder.encode(type) + "&path=" + URLEncoder.encode(path) + "&host=" + URLEncoder.encode(host) + "&domain=" + URLEncoder.encode(domain) + "&forward=" + URLEncoder.encode("MailSessions List Setup"), "content", false, domain);
        TreeControlNode resourcelinks = new TreeControlNode("Resource Links " + containerName, "ResourceLink.gif", this.resources.getMessage(this.locale, "resources.treeBuilder.resourcelinks"), "resources/listResourceLinks.do?resourcetype=" + URLEncoder.encode(type) + "&path=" + URLEncoder.encode(path) + "&host=" + URLEncoder.encode(host) + "&domain=" + URLEncoder.encode(domain) + "&forward=" + URLEncoder.encode("ResourceLinks List Setup"), "content", false, domain);
        TreeControlNode envs = new TreeControlNode("Context Environment Entries " + containerName, "EnvironmentEntries.gif", this.resources.getMessage(this.locale, "resources.env.entries"), "resources/listEnvEntries.do?resourcetype=" + URLEncoder.encode(type) + "&path=" + URLEncoder.encode(path) + "&host=" + URLEncoder.encode(host) + "&domain=" + URLEncoder.encode(domain) + "&forward=" + URLEncoder.encode("EnvEntries List Setup"), "content", false, domain);
        subtree.addChild(datasources);
        subtree.addChild(mailsessions);
        subtree.addChild(resourcelinks);
        subtree.addChild(envs);
    }

    public void getValves(TreeControlNode containerNode, String containerName) throws Exception {
        String domain = containerNode.getDomain();
        Iterator valveNames = Lists.getValves(mBServer, containerName).iterator();
        while (valveNames.hasNext()) {
            String valveName = (String)valveNames.next();
            ObjectName objectName = new ObjectName(valveName);
            String nodeLabel = "Valve for " + containerNode.getLabel();
            TreeControlNode valveNode = new TreeControlNode(valveName, "Valve.gif", nodeLabel, "EditValve.do?select=" + URLEncoder.encode(valveName) + "&nodeLabel=" + URLEncoder.encode(nodeLabel) + "&parent=" + URLEncoder.encode(containerName), "content", false, domain);
            containerNode.addChild(valveNode);
        }
    }
}

