/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.webapp.admin.ApplicationServlet;
import org.apache.webapp.admin.TreeBuilder;
import org.apache.webapp.admin.TreeControl;
import org.apache.webapp.admin.TreeControlNode;

public class SetUpTreeAction
extends Action {
    public static final String DOMAIN_KEY = "domain";
    public static final int INIT_PLUGIN_MAX = 10;
    public static final String TREEBUILDER_KEY = "treebuilders";
    public static final String ROOTNODENAME_KEY = "rootnodename";

    public ActionForward perform(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ApplicationServlet servlet = (ApplicationServlet)this.getServlet();
        String rootnodeName = servlet.getServletConfig().getInitParameter(ROOTNODENAME_KEY);
        String treeBuildersStr = servlet.getServletConfig().getInitParameter(TREEBUILDER_KEY);
        String domain = servlet.getServletConfig().getInitParameter(DOMAIN_KEY);
        TreeControlNode root = new TreeControlNode("ROOT-NODE", null, rootnodeName, "setUpTree.do?select=ROOT-NODE", "content", true, domain);
        TreeControl control = new TreeControl(root);
        if (treeBuildersStr != null) {
            ArrayList<String> treeBuilders = new ArrayList<String>(10);
            int i = 0;
            StringTokenizer st = new StringTokenizer(treeBuildersStr, ",");
            while (st.hasMoreTokens()) {
                treeBuilders.add(st.nextToken().trim());
            }
            if (treeBuilders.size() == 0) {
                treeBuilders.add(treeBuildersStr.trim());
            }
            for (i = 0; i < treeBuilders.size(); ++i) {
                try {
                    Class<?> treeBuilderImpl = Class.forName((String)treeBuilders.get(i));
                    TreeBuilder treeBuilderBase = (TreeBuilder)treeBuilderImpl.newInstance();
                    treeBuilderBase.buildTree(control, servlet, request);
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace(System.out);
                }
            }
        }
        HttpSession session = request.getSession();
        session.setAttribute("treeControlTest", (Object)control);
        String name = request.getParameter("select");
        if (name != null) {
            control.selectNode(name);
            return mapping.findForward("Blank");
        }
        return mapping.findForward("Tree Control Test");
    }
}

