/*
 * Decompiled with CFR 0.152.
 */
package javax.management.modelmbean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.Descriptor;
import javax.management.RuntimeOperationsException;

public class DescriptorSupport
implements Descriptor {
    private static final long serialVersionUID = -6292969195866300415L;
    private HashMap descriptor = new HashMap();

    public DescriptorSupport() {
    }

    public DescriptorSupport(String[] pairs) {
        if (pairs == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid field pairs"));
        }
        int i = 0;
        while (i < pairs.length) {
            String pair = pairs[i];
            if (pair == null) {
                throw new RuntimeOperationsException(new IllegalArgumentException("Illegal pair: " + pair));
            }
            int equal = pair.indexOf(61);
            if (equal < 1) {
                throw new RuntimeOperationsException(new IllegalArgumentException("Illegal pair: " + pair));
            }
            String name = pair.substring(0, equal);
            String value = null;
            if (equal < pair.length() - 1) {
                value = pair.substring(equal + 1);
            }
            this.setField(name, value);
            ++i;
        }
    }

    public DescriptorSupport(String[] names, Object[] values) {
        this.setFields(names, values);
    }

    public Object clone() throws RuntimeOperationsException {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException x) {
            throw new RuntimeOperationsException("Clone operation not supported");
        }
    }

    public Object getFieldValue(String name) throws RuntimeOperationsException {
        if (name == null || name.trim().length() == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid field name"));
        }
        Object value = this.descriptor.get(name.toLowerCase());
        return value;
    }

    public void setField(String name, Object value) throws RuntimeOperationsException {
        this.checkField(name, value);
        this.descriptor.put(name.toLowerCase(), value);
    }

    public void removeField(String name) {
        this.descriptor.remove(name);
    }

    public String[] getFieldNames() {
        String[] names = this.descriptor.keySet().toArray(new String[0]);
        return names;
    }

    public Object[] getFieldValues(String[] names) {
        if (names == null) {
            Object[] values = this.descriptor.values().toArray(new Object[0]);
            return values;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while (i < names.length) {
            try {
                Object value = this.getFieldValue(names[i]);
                list.add(value);
            }
            catch (RuntimeOperationsException x) {
                list.add(null);
            }
            ++i;
        }
        Object[] values = list.toArray(new Object[list.size()]);
        return values;
    }

    public String[] getFields() {
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer buffer = new StringBuffer();
        Iterator i = this.descriptor.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            buffer.setLength(0);
            buffer.append(key);
            buffer.append("=");
            if (value != null) {
                if (value instanceof String) {
                    buffer.append(value.toString());
                } else {
                    buffer.append("(");
                    buffer.append(value.toString());
                    buffer.append(")");
                }
            }
            list.add(buffer.toString());
        }
        String[] fields = list.toArray(new String[list.size()]);
        return fields;
    }

    public void setFields(String[] names, Object[] values) throws RuntimeOperationsException {
        if (names == null || values == null || names.length != values.length) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid arguments"));
        }
        int i = 0;
        while (i < names.length) {
            this.setField(names[i], values[i]);
            ++i;
        }
    }

    public boolean isValid() throws RuntimeOperationsException {
        try {
            Iterator i = this.descriptor.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                String name = (String)entry.getKey();
                Object value = entry.getValue();
                this.checkField(name, value);
            }
            return true;
        }
        catch (RuntimeOperationsException x) {
            return false;
        }
    }

    private void checkField(String name, Object value) throws RuntimeOperationsException {
        if (name == null || name.trim().length() == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Illegal field name"));
        }
        boolean isValid = true;
        if (name.equalsIgnoreCase("name")) {
            isValid = value != null;
        } else if (name.equalsIgnoreCase("descriptorType")) {
            isValid = value != null && (value.equals("MBean") || value.equals("attribute") || value.equals("operation") || value.equals("notification"));
        } else if (name.equalsIgnoreCase("role")) {
            isValid = value != null && (value.equals("constructor") || value.equals("operation") || value.equals("getter") || value.equals("setter"));
        } else if (name.equalsIgnoreCase("persistPolicy")) {
            isValid = value != null && (value.equals("Never") || value.equals("OnTimer") || value.equals("OnUpdate") || value.equals("NoMoreOftenThan"));
        } else if (name.equalsIgnoreCase("persistPeriod")) {
            int v = this.objectToInt(value);
            isValid = v > 0;
        } else if (name.equalsIgnoreCase("currencyTimeLimit")) {
            int v = this.objectToInt(value);
            isValid = v >= -1;
        } else if (name.equalsIgnoreCase("export")) {
            isValid = value instanceof Serializable || value == null;
        } else if (name.equalsIgnoreCase("visibility")) {
            int v = this.objectToInt(value);
            isValid = v >= 1 && v <= 4;
        } else if (name.equalsIgnoreCase("getMethod") || name.equalsIgnoreCase("setMethod")) {
            isValid = value != null && value.toString().trim().length() > 0;
        } else if (name.equalsIgnoreCase("protocolMap")) {
            isValid = value instanceof Descriptor;
        } else if (name.equalsIgnoreCase("lastUpdatedTimeStamp")) {
            long v = this.objectToLong(value);
            isValid = v > 0L;
        } else if (name.equalsIgnoreCase("severity")) {
            int v = this.objectToInt(value);
            isValid = v >= 0 && v <= 6;
        } else if (name.equalsIgnoreCase("messageId")) {
            boolean bl = isValid = value != null;
        }
        if (!isValid) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid value '" + value + "' for field " + name));
        }
    }

    private int objectToInt(Object obj) throws RuntimeOperationsException {
        try {
            return Integer.parseInt(obj.toString());
        }
        catch (NumberFormatException x) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Illegal value '" + obj + "' for numeric field"));
        }
        catch (NullPointerException x) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Illegal value '" + obj + "' for numeric field"));
        }
    }

    private long objectToLong(Object obj) throws RuntimeOperationsException {
        try {
            return Long.parseLong(obj.toString());
        }
        catch (NumberFormatException x) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Illegal value '" + obj + "' for numeric field"));
        }
        catch (NullPointerException x) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Illegal value '" + obj + "' for numeric field"));
        }
    }
}

