'\"
'\" Generated from file '/usr/obj/i386/tcllib-1.4/tcllib-1.4/modules/struct/record.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2002, Brett Schwarz <brett_schwarz@yahoo.com>
'\"
'\" -*- tcl -*-
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2000/03/06 21:34:53 ericm Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "record" n 1.2.1 struct "Tcl Data Structures"
.BS
.SH "NAME"
record \- Define and create records (similar to 'C' structures)
.SH "SYNOPSIS"
package require \fBTcl  8.2\fR
.sp
package require \fBstruct  ?1.3?\fR
.sp
\fBrecord define\fR \fIrecordName\fR \fIrecordMembers\fR ?\fIinstanceName1 instanceName2 ...\fR?\fR
.sp
\fBrecord show\fR \fIrecord\fR\fR
.sp
\fBrecord show\fR \fIinstances\fR \fIrecordName\fR\fR
.sp
\fBrecord show\fR \fImembers\fR \fIrecordName\fR\fR
.sp
\fBrecord show\fR \fIvalues\fR \fIinstanceName\fR\fR
.sp
\fBrecord exists\fR \fIrecord\fR \fIrecordName\fR\fR
.sp
\fBrecord exists\fR \fIinstance\fR \fIinstanceName\fR\fR
.sp
\fBrecord delete\fR \fIrecord\fR \fIrecordName\fR\fR
.sp
\fBrecord delete\fR \fIinstance\fR \fIinstanceName\fR\fR
.sp
\fIrecordName\fR \fB\fIinstanceName|#auto\fR\fR ?\fI-member1 value1 -member2 value2 ...\fR?\fR
.sp
\fIinstanceName\fR \fBcget\fR ?\fI-member1 -member2 ...\fR?\fR
.sp
\fIinstanceName\fR \fBconfigure\fR ?\fI-member1 value1 -member2 value2 ...\fR?\fR
.sp
.BE
.SH "DESCRIPTION"
The \fB::struct::record\fR package provides a mechanism to group variables together
as one data structure, similar to a 'C' structure. The members of a
record can be variables or other records. However, a record can not contain circular
record, i.e. records that contain the same record as a
member.
.PP
This package was structured so that it is very similar to how Tk objects work. Each record
definition creates a record object that encompasses that definition. Subsequently, that
record object can create instances of that record. These instances can then
be manipulated with the \fBcget\fR and \fBconfigure\fR methods.
.PP
The package only contains one top level command, but several sub commands (see below). It also obeys the namespace in which the record was define, hence the objects returned are fully qualified.
.TP
\fBrecord define\fR \fIrecordName\fR \fIrecordMembers\fR ?\fIinstanceName1 instanceName2 ...\fR?\fR
Defines a record. \fIrecordName\fR is the name of the record, and is also
used as an object command. This object command is used to create instances of the
record definition. \fIrecordMembers\fR are the members of
the record that make up the record definition. These are variables
and other record. If optional \fIinstanceName\fR args are given, then an instance
is generated after the definition is created for each \fIinstanceName\fR.
.TP
\fBrecord show\fR \fIrecord\fR\fR
Returns a list of records that have been defined.
.TP
\fBrecord show\fR \fIinstances\fR \fIrecordName\fR\fR
Returns the instances that have been instantiated by
\fIrecordName\fR.
.TP
\fBrecord show\fR \fImembers\fR \fIrecordName\fR\fR
Returns the members that are defined for
record \fIrecordName\fR. It returns the same format as how the
records were defined.
.TP
\fBrecord show\fR \fIvalues\fR \fIinstanceName\fR\fR
Returns a list of values that are set for the instance
\fIinstanceName\fR. The output is a list of key/value pairs. If there
are nested records, then the values of the nested records will
itself be a list.
.TP
\fBrecord exists\fR \fIrecord\fR \fIrecordName\fR\fR
Tests for the existence of a \fIrecord\fR with the
name \fIrecordName\fR.
.TP
\fBrecord exists\fR \fIinstance\fR \fIinstanceName\fR\fR
Tests for the existence of a \fIinstance\fR with the
name \fIinstanceName\fR.
.TP
\fBrecord delete\fR \fIrecord\fR \fIrecordName\fR\fR
Deletes \fIrecordName\fR, and all instances of \fIrecordName\fR. It will return
an error if the record does not exist.
.TP
\fBrecord delete\fR \fIinstance\fR \fIinstanceName\fR\fR
Deletes \fIinstance\fR with the name of \fIinstanceName\fR. It
will return an error if the instance does not exist.
.PP
.SH "RECORD MEMBERS"
Record members can either be variables, or other records, However, the
same record can not be nested witin itself (circular). To define a
nested record, you need to specify the \fBrecord\fR keyword, along
the with name of the record, and the name of the instance of that
nested record. For example, it would look like this:
.PP
.nf
# this is the nested record
record define mynestedrecord {
    nest1
    nest2
}

# This is the main record
record define myrecord {
    mem1
    mem2
    {record mynestedrecord mem3}
}

.fi
You can also assign default or initial values to the members of a record,
by enclosing the member entry in braces:
.PP
.nf

record define myrecord {
    mem1
    {mem2 5}
}

.fi
All instances created from this record definition, will initially have 5 as
the value for \fImem2\fR. If no default is given, then the value will be the empty string.
.PP
\fIGetting Values\fR
.PP
To get a value of a member, there are several ways to do this.
.IP [1]
To get a member value, then use the instance built-in \fBcget\fR method:
.sp
\fIinstanceName\fR \fBcget\fR -mem1
.IP [2]
To get multiple member values, you can specify them all in one command:
.sp
\fIinstanceName\fR \fBcget\fR -mem1 -mem2
.IP [3]
To get a list of the key/value of all of the members, there are 3 ways:
.sp
- \fIinstanceName\fR \fBcget\fR
.sp
- \fIinstanceName\fR \fBconfigure\fR
.sp
- \fIinstanceName\fR
.IP [4]
To get a value of a nested member, then use the dot notation:
.sp
\fIinstanceName\fR \fBcget\fR -mem3.nest1
.PP
\fISetting Values\fR
.PP
To set a value of a member, there are several ways to do this.
.IP [1]
To set a member value, then use the instance built-in \fBconfigure\fR method:
.sp
\fIinstanceName\fR \fBconfigure\fR -mem1 val1
.IP [2]
To set multiple member values, you can specify them all in one command:
.sp
\fIinstanceName\fR \fBconfigure\fR -mem1 va1 -mem2 val2
.IP [3]
To set a value of a nested member, then use the dot notation:
.sp
\fIinstanceName\fR \fBconfigure\fR -mem3.nest1 value
.PP
\fIAlias access\fR
.PP
In the original implementation, access was done by using dot notation similar to how 'C' structures are accessed. However,
there was a concensus to make the interface more Tcl like, which made sense. However, the original alias access still
exists. It might prove to be helpful to some.
.PP
Basically, for every member of every instance, an alias is created. This alias is used to get and set values for that
member. An example will illustrate the point, using the above defined records:
.PP
.nf
# Create an instance first
% myrecord inst1
::inst1
% # To get a member of an instance, just use the
% # alias (it behaves like a Tcl command):
% inst1.mem1
%
% # To set a member via the alias, just include
% # a value (optionally the equal sign - syntactic sugar)
% inst1.mem1 = 5
5
% inst1.mem1
5
% # For nested records, just continue with the
% # dot notation (note no equal sign)
% inst1.mem3.nest1 10
10
% inst1.mem3.nest1
10
% # just the instance by itself gives all
% # member/values pairs for that instance
% inst1
-mem1 5 -mem2 {} -mem3 {-nest1 10 -nest2 {}}
% # and to get all members within the nested record
% inst1.mem3
-nest1 10 -nest2 {}
%

.fi
.SH "RECORD COMMAND"
The following subcommands and corresponding arguments are available to any
record command:
.TP
\fIrecordName\fR \fB\fIinstanceName|#auto\fR\fR ?\fI-member1 value1 -member2 value2 ...\fR?\fR
Using the \fIrecordName\fR object command that was created from the record definition,
instances of the record definition can be created. Once a instance is
created, then it inherits the members of the record definition, very
similar to how objects work. During instance generation, an object command for the instance
is created as well, using \fIinstanceName\fR. This object command is used
to access the data members of the instance. During the instantiation, values for
that instance can be given, \fIbut\fR all values must be given, and be given
in key/value pairs. Nested records, need to be in list format.
.sp
Optionally, \fI#auto\fR can be used in place of \fIinstanceName\fR. When #auto is used,
then a instance name will automatically be generated, of the form recordName<integer>, where
<integer> is a unique integer (starting at 0) that is generated.
.PP
.SH "INSTANCE COMMAND"
The following subcommands and corresponding arguments are available to
any record instance command:
.TP
\fIinstanceName\fR \fBcget\fR ?\fI-member1 -member2 ...\fR?\fR
Each instance has the sub command \fBcget\fR associated with it. This
is very similar to how Tk widget's cget command works. It queries
the values of the member for that particular instance. If
no arguments are given, then a key/value list is returned.
.TP
\fIinstanceName\fR \fBconfigure\fR ?\fI-member1 value1 -member2 value2 ...\fR?\fR
Each instance has the sub command \fBconfigure\fR associated with it. This
is very similar to how Tk widget's configure command works. It sets
the values of the particular member for that particular instance. If
no arguments are given, then a key/value list is returned.
.SH "EXAMPLES"
Two examples are provided to give an good illustration on how to use
this package.
.PP
\fIExample 1\fR
.PP
Probably the most obvious example would be to hold contact information,
such as addresses, phone numbers, comments, etc. Since a person can have
multiple phone numbers, multiple email addresses, etc, we will use nested
records to define these. So, the first thing we do is define the nested
records:
.PP
.nf

##
##  This is an interactive example, to see what is
##  returned by each command as well.
##

% namespace import ::struct::record::*

% # define a nested record. Notice that country has default 'USA'.
% record define locations {
    street
    street2
    city
    state
    zipcode
    {country USA}
    phone
}
::locations
% # Define the main record. Notice that it uses the location record twice.
% record define contacts {
    first
    middle
    last
    {record locations home}
    {record locations work}
}
::contacts
% # Create an instance for the contacts record.
% contacts cont1
::cont1
% # Display some introspection values
% record show records
::contacts ::locations
% #
% record show values cont1
-first {} -middle {} -last {} -home {-street {} -street2 {} -city {} -state {} -zipcode {} -country USA -phone {}} -work {-street {} -street2 {} -city {} -state {} -zipcode {} -country USA -phone {}}
% #
% record show instances contacts
::cont1
% #
% cont1 config
-first {} -middle {} -last {} -home {-street {} -street2 {} -city {} -state {} -zipcode {} -country USA -phone {}} -work {-street {} -street2 {} -city {} -state {} -zipcode {} -country USA -phone {}}
% #
% cont1 cget
-first {} -middle {} -last {} -home {-street {} -street2 {} -city {} -state {} -zipcode {} -country USA -phone {}} -work {-street {} -street2 {} -city {} -state {} -zipcode {} -country USA -phone {}}
% # copy one record to another record
% record define contacts2 [record show members contacts]
::contacts2
% record show members contacts2
first middle last {record locations home} {record locations work}
% record show members contacts
first middle last {record locations home} {record locations work}
%
.fi
.PP
\fIExample 1\fR
.PP
This next example just illustrates a simple linked list
.PP
.nf

% # define a very simple record for linked list
% record define llist {
    value
    next
}
::llist
% llist lstart
::lstart
% lstart config -value 1 -next [llist #auto]
% [lstart cget -next] config -value 2 -next [llist #auto]
% [[lstart cget -next] cget -next] config -value 3 -next "end"
% set next lstart
lstart
% while 1 {
lappend values [$next cget -value]
set next [$next cget -next]
if {[string match "end" $next]} {break}
}
% puts "$values"
1 2 3
% # cleanup linked list
% # We could just use delete record llist also
% foreach I [record show instances llist] {
record delete instance $I
}
% record show instances llist
%

.fi
.PP
.SH "KEYWORDS"
data structures, record, struct
.SH "COPYRIGHT"
.nf
Copyright (c) 2002, Brett Schwarz <brett_schwarz@yahoo.com>
.fi