/*

Copyright (C) 2000 - 2004 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifndef __libnd_main_h
#define __libnd_main_h

#include <libnd.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/**
 * libnd_init - initializes the library.
 *
 * The function initializes the data structures for the various
 * libnetdude components, such as the registries, plugins,
 * debugging settings etc. You MUST call this function before
 * you use other parts of libnetdude.
 */
gboolean  libnd_init(void);


/**
 * libnd_shutdown - shuts down the library.
 *
 * This function performs cleanup actions to shut down the
 * library.
 */
void      libnd_shutdown(void);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
     
