/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;

public class Random
implements Serializable {
    private static final long serialVersionUID = 3905348978240129619L;
    private long seed;
    private boolean haveNextNextGaussian;
    private double nextNextGaussian;
    private final long p1;
    private final long p2;
    private final long mask;

    protected int next(int n) {
        this.seed = 25214903917L * this.seed + 11L & 0xFFFFFFFFFFFFL;
        return (int)(this.seed >>> 48 - n);
    }

    public void nextBytes(byte[] byArray) {
        try {
            int n = 0;
            while (n < byArray.length) {
                int n2 = this.next(32);
                byArray[n] = (byte)n2;
                byArray[n + 1] = (byte)(n2 >> 8);
                byArray[n + 2] = (byte)(n2 >> 16);
                byArray[n + 3] = (byte)(n2 >> 24);
                n += 4;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public double nextDouble() {
        return (double)(((long)this.next(26) << 27) + (long)this.next(27)) / 9.007199254740992E15;
    }

    public boolean nextBoolean() {
        return this.next(1) != 0;
    }

    public float nextFloat() {
        return (float)this.next(24) / 1.6777216E7f;
    }

    public double nextGaussian() {
        double d;
        double d2;
        double d3;
        if (this.haveNextNextGaussian) {
            this.haveNextNextGaussian = false;
            return this.nextNextGaussian;
        }
        while ((d3 = (d2 = this.nextDouble() * 2.0 - 1.0) * d2 + (d = this.nextDouble() * 2.0 - 1.0) * d) >= 1.0) {
        }
        double d4 = Math.sqrt(-2.0 * Math.log(d3) / d3);
        this.nextNextGaussian = d * d4;
        this.haveNextNextGaussian = true;
        return d2 * d4;
    }

    public int nextInt() {
        return this.next(32);
    }

    public int nextInt(int n) {
        int n2;
        int n3;
        if (n <= 0) {
            throw new IllegalArgumentException("n must be positive: " + n);
        }
        if ((n & -n) == n) {
            return (int)((long)n * (long)this.next(31) >> 31);
        }
        while ((n3 = this.next(31)) - (n2 = n3 % n) + (n - 1) < 0) {
        }
        return n2;
    }

    public long nextLong() {
        return ((long)this.next(32) << 32) + (long)this.next(32);
    }

    public synchronized void setSeed(long l) {
        this.seed = (l ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
        this.haveNextNextGaussian = false;
    }

    public Random() {
        this(System.currentTimeMillis());
    }

    public Random(long l) {
        this.p1 = 25214903917L;
        this.p2 = 11L;
        this.mask = 0xFFFFFFFFFFFFL;
        this.setSeed(l);
    }
}

