/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Button;
import java.awt.Component;
import java.awt.Defaults;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Vector;

public class FileDialog
extends Dialog
implements ActionListener,
ItemListener,
FilenameFilter {
    private static final long serialVersionUID = 5035145889651310422L;
    public static final int LOAD = 0;
    public static final int SAVE = 1;
    static final String upDir = "..";
    int mode;
    FilenameFilter filter;
    Label lFilt = new Label("Filter:");
    Label lFile = new Label("File:");
    TextField tFilt = new TextField();
    TextField tFile = new TextField();
    Button bOk = new Button("~Ok");
    Button bCan = new Button("~Cancel");
    String filtExt;
    File dir;
    File tmpFile;
    List lDirs = new List();
    List lFiles = new List();

    public boolean accept(File file, String string) {
        if (this.filtExt.endsWith("*")) {
            return true;
        }
        return string.endsWith(this.filtExt);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.tFilt) {
            this.filtExt = this.tFilt.getText();
            this.loadFiles(this.dir);
        } else if (object == this.tFile) {
            this.setFile(actionEvent.getActionCommand());
            this.dispose();
        } else if (object == this.lDirs) {
            String string = this.lDirs.getSelectedItem();
            if (string == upDir) {
                this.loadSubs(new File(this.dir.getParent()));
            } else {
                this.loadSubs(new File(string));
            }
        } else if (object == this.lFiles) {
            this.dispose();
        } else if (object == this.bOk) {
            this.dispose();
        } else if (object == this.bCan) {
            this.tFile.setText("");
            this.dispose();
        }
    }

    public void addNotify() {
        if (this.width == 0 || this.height == 0) {
            this.setBounds((Defaults.ScreenWidth - 400) / 2, (Defaults.ScreenHeight - 300) / 2, 400, 300);
        }
        if (this.dir == null) {
            this.setUserDir();
        }
        super.addNotify();
    }

    static String getAbsolutePath(String string) {
        String string2 = System.getProperty("user.dir");
        if (string == null || string.equals(".")) {
            return string2;
        }
        if (string.startsWith(File.separator) || string.length() > 1 && string.charAt(1) == ':') {
            return string;
        }
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < cArray.length) {
            if (cArray[n3] == '.') {
                ++n;
            } else {
                if (cArray[n3] != File.separatorChar) break;
                if (n == 2) {
                    ++n2;
                }
                n = 0;
            }
            ++n3;
        }
        if (n == 2) {
            ++n2;
        }
        if (n2 == 0) {
            return string2 + File.separator + string;
        }
        int n4 = string2.length();
        while (n2 > 0) {
            n4 = string2.lastIndexOf(File.separatorChar, n4 - 1);
            --n2;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        return string2.substring(0, n4) + File.separator + string.substring(n3);
    }

    public String getDirectory() {
        File file;
        String string = this.tFile.getText();
        String string2 = string.length() == 0 ? "." : ((file = new File(string)).isDirectory() ? file.getPath() : file.getParent());
        return string2 + File.separator;
    }

    public String getFile() {
        String string = this.tFile.getText();
        if (string.length() == 0) {
            return null;
        }
        File file = new File(string);
        return file.getName();
    }

    public FilenameFilter getFilenameFilter() {
        return this.filter;
    }

    public int getMode() {
        return this.mode;
    }

    void initLayout() {
        int n = 5;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.left = n;
        gridBagConstraints.insets.right = n;
        this.add((Component)this.lFilt, gridBagConstraints);
        this.add((Component)this.tFilt, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.right = 0;
        this.add((Component)this.lDirs, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = n;
        this.add((Component)this.lFiles, gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets.left = n;
        this.add((Component)this.lFile, gridBagConstraints);
        this.add((Component)this.tFile, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.left = n;
        gridBagConstraints.insets.right = n;
        gridBagConstraints.insets.bottom = 10;
        this.add((Component)this.bOk, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.bCan, gridBagConstraints);
    }

    boolean isFiltered(File file, String string) {
        if (this.filter == null) {
            return false;
        }
        return !this.filter.accept(file, string);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 1) {
            return;
        }
        Object object = itemEvent.getSource();
        if (object == this.lDirs) {
            String string = this.lDirs.getSelectedItem();
            if (string != upDir) {
                this.dir = new File(string);
                this.tFile.setText(this.dir.getPath());
                this.loadFiles(this.dir);
            }
        } else if (object == this.lFiles) {
            String string = this.lFiles.getSelectedItem();
            if (this.dir.getPath().equals(File.separator)) {
                this.tFile.setText(File.separator + string);
            } else {
                this.tFile.setText(this.dir + File.separator + string);
            }
        }
    }

    void loadFiles(File file) {
        String[] stringArray = file.list(this.filter);
        this.lFiles.removeAll();
        this.lFiles.flags &= 0xFFFFFFFE;
        int n = 0;
        while (n < stringArray.length) {
            File file2 = new File(file + File.separator + stringArray[n]);
            if (!file2.isDirectory()) {
                this.lFiles.addItem(stringArray[n], FileDialog.sortIdx(this.lFiles.ip.rows, stringArray[n]));
            }
            ++n;
        }
        this.lFiles.setVisible(true);
    }

    void loadSubs(File file) {
        boolean bl;
        String string = file.getPath();
        boolean bl2 = bl = string.length() == 0;
        if (bl) {
            file = new File(File.separator);
        }
        String[] stringArray = file.list();
        this.lFiles.removeAll();
        this.lDirs.removeAll();
        this.lFiles.flags &= 0xFFFFFFFE;
        this.lDirs.flags &= 0xFFFFFFFE;
        this.dir = file;
        this.tFile.setText(file.getPath());
        if (!bl) {
            this.lDirs.add(upDir);
        }
        int n = 0;
        while (n < stringArray.length) {
            File file2;
            File file3 = file2 = bl ? new File(file + stringArray[n]) : new File(file + File.separator + stringArray[n]);
            if (file2.isDirectory()) {
                String string2 = file2.getPath();
                this.lDirs.addItem(string2, FileDialog.sortIdx(this.lDirs.ip.rows, string2));
            } else if (!this.isFiltered(file, stringArray[n])) {
                this.lFiles.addItem(stringArray[n], FileDialog.sortIdx(this.lFiles.ip.rows, stringArray[n]));
            }
            ++n;
        }
        this.lFiles.setVisible(true);
        this.lDirs.setVisible(true);
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame();
        frame.setBounds(100, 100, 100, 100);
        frame.setVisible(true);
        FileDialog fileDialog = new FileDialog(frame, "FileDialog");
        fileDialog.setFile(null);
        fileDialog.setVisible(true);
        System.out.println(fileDialog.getDirectory());
        System.out.println(fileDialog.getFile());
    }

    protected String paramString() {
        return super.paramString();
    }

    void selectFile(String string) {
        String[] stringArray = this.lFiles.getItems();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                this.lFiles.select(n);
                return;
            }
            ++n;
        }
    }

    public void setDirectory(String string) {
        File file = new File(FileDialog.getAbsolutePath(string));
        if (file.exists() && file.isDirectory()) {
            this.loadSubs(file);
        }
        if (this.tmpFile != null) {
            this.selectFile(this.tmpFile.getName());
            this.tmpFile = null;
        }
    }

    public void setFile(String string) {
        if (string == null) {
            if (this.dir == null) {
                this.setUserDir();
            }
            return;
        }
        File file = new File(string);
        if (file.isDirectory()) {
            this.loadSubs(file);
            return;
        }
        if (file.getParent() == null) {
            if (this.dir != null) {
                this.selectFile(file.getName());
                return;
            }
            this.tmpFile = file;
            file = new File(file.getAbsolutePath());
        }
        if (!file.exists()) {
            return;
        }
        File file2 = new File(file.getParent());
        this.loadSubs(file2);
        this.selectFile(file.getName());
    }

    public void setFilenameFilter(FilenameFilter filenameFilter) {
        this.filter = filenameFilter;
    }

    public void setMode(int n) throws IllegalArgumentException {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        this.mode = n;
    }

    void setUserDir() {
        this.setDirectory(System.getProperty("user.dir"));
    }

    static int sortIdx(Vector vector, String string) {
        int n = vector.size();
        if (n == 0) {
            return 0;
        }
        int n2 = n - 1;
        while (n2 >= 0) {
            String string2 = (String)vector.elementAt(n2);
            if (string.compareTo(string2) >= 0) {
                return n2 + 1;
            }
            --n2;
        }
        return 0;
    }

    public FileDialog(Frame frame) {
        this(frame, null, 0);
    }

    public FileDialog(Frame frame, String string) {
        this(frame, string, 0);
    }

    public FileDialog(Frame frame, String string, int n) {
        super(frame, string, true);
        this.mode = n;
        this.initLayout();
        this.tFilt.addActionListener(this);
        this.tFile.addActionListener(this);
        this.bOk.addActionListener(this);
        this.bCan.addActionListener(this);
        this.lDirs.addItemListener(this);
        this.lFiles.addItemListener(this);
        this.lDirs.addActionListener(this);
        this.lFiles.addActionListener(this);
        this.filtExt = ".*";
        this.tFilt.setText(this.filtExt);
        this.setFilenameFilter(this);
    }
}

