/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.connector;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Locale;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.apache.webapp.admin.ApplicationServlet;
import org.apache.webapp.admin.TomcatTreeBuilder;
import org.apache.webapp.admin.TreeControl;
import org.apache.webapp.admin.TreeControlNode;
import org.apache.webapp.admin.connector.ConnectorForm;

public final class SaveConnectorAction
extends Action {
    private String[] createStandardConnectorTypes = new String[]{"java.lang.String", "java.lang.String", "int"};
    private MBeanServer mBServer = null;
    private MessageResources resources = null;

    public ActionForward perform(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HttpSession session = request.getSession();
        Locale locale = (Locale)session.getAttribute("org.apache.struts.action.LOCALE");
        if (this.resources == null) {
            this.resources = this.getServlet().getResources();
        }
        try {
            this.mBServer = ((ApplicationServlet)this.getServlet()).getServer();
        }
        catch (Throwable t) {
            throw new ServletException("Cannot acquire MBeanServer reference", t);
        }
        ConnectorForm cform = (ConnectorForm)form;
        String adminAction = cform.getAdminAction();
        String cObjectName = cform.getObjectName();
        String connectorType = cform.getConnectorType();
        ObjectName coname = null;
        if ("Create".equals(adminAction)) {
            String operation = null;
            Object[] values = null;
            try {
                String serviceName = cform.getServiceName();
                ObjectName soname = new ObjectName(serviceName);
                String domain = soname.getDomain();
                StringBuffer sb = new StringBuffer(domain);
                StringBuffer searchSB = new StringBuffer("*");
                sb.append(":type=Connector");
                searchSB.append(":type=Connector");
                sb.append(",port=" + cform.getPortText());
                searchSB.append(",port=" + cform.getPortText());
                ObjectName search = new ObjectName(searchSB.toString() + ",*");
                String address = cform.getAddress();
                if (address != null && address.length() > 0 && !address.equalsIgnoreCase(" ")) {
                    sb.append(",address=" + address);
                } else {
                    address = null;
                }
                ObjectName oname = new ObjectName(sb.toString());
                if (this.mBServer.isRegistered(oname) || !this.mBServer.queryNames(search, null).isEmpty()) {
                    ActionErrors errors = new ActionErrors();
                    errors.add("connectorName", new ActionError("error.connectorName.exists"));
                    this.saveErrors(request, errors);
                    return new ActionForward(mapping.getInput());
                }
                ObjectName fname = TomcatTreeBuilder.getMBeanFactory();
                values = new Object[]{serviceName, address, new Integer(cform.getPortText())};
                operation = "HTTP".equalsIgnoreCase(connectorType) ? "createHttpConnector" : ("HTTPS".equalsIgnoreCase(connectorType) ? "createHttpsConnector" : "createAjpConnector");
                cObjectName = (String)this.mBServer.invoke(fname, operation, values, this.createStandardConnectorTypes);
                TreeControl control = (TreeControl)session.getAttribute("treeControlTest");
                if (control != null) {
                    String parentName = serviceName;
                    TreeControlNode parentNode = control.findNode(parentName);
                    if (parentNode != null) {
                        String nodeLabel = this.resources.getMessage(locale, "server.service.treeBuilder.connector") + " (" + cform.getPortText() + ")";
                        String encodedName = URLEncoder.encode(cObjectName);
                        TreeControlNode childNode = new TreeControlNode(cObjectName, "Connector.gif", nodeLabel, "EditConnector.do?select=" + encodedName, "content", true, domain);
                        parentNode.addChild(childNode);
                    } else {
                        this.getServlet().log("Cannot find parent node '" + parentName + "'");
                    }
                } else {
                    this.getServlet().log("Cannot find TreeControlNode!");
                }
            }
            catch (Exception e) {
                this.getServlet().log(this.resources.getMessage(locale, "users.error.invoke", operation), (Throwable)e);
                response.sendError(500, this.resources.getMessage(locale, "users.error.invoke", operation));
                return null;
            }
        }
        String attribute = null;
        try {
            coname = new ObjectName(cObjectName);
            attribute = "debug";
            int debug = 0;
            try {
                debug = Integer.parseInt(cform.getDebugLvl());
            }
            catch (Throwable t) {
                debug = 0;
            }
            this.mBServer.setAttribute(coname, new Attribute("debug", new Integer(debug)));
            attribute = "acceptCount";
            int acceptCount = 60000;
            try {
                acceptCount = Integer.parseInt(cform.getAcceptCountText());
            }
            catch (Throwable t) {
                acceptCount = 60000;
            }
            this.mBServer.setAttribute(coname, new Attribute("acceptCount", new Integer(acceptCount)));
            attribute = "compression";
            String compression = cform.getCompression();
            if (compression != null && compression.length() > 0) {
                this.mBServer.setAttribute(coname, new Attribute("compression", compression));
            }
            attribute = "connectionLinger";
            int connectionLinger = -1;
            try {
                connectionLinger = Integer.parseInt(cform.getConnLingerText());
            }
            catch (Throwable t) {
                connectionLinger = 0;
            }
            this.mBServer.setAttribute(coname, new Attribute("connectionLinger", new Integer(connectionLinger)));
            attribute = "connectionTimeout";
            int connectionTimeout = 0;
            try {
                connectionTimeout = Integer.parseInt(cform.getConnTimeOutText());
            }
            catch (Throwable t) {
                connectionTimeout = 0;
            }
            this.mBServer.setAttribute(coname, new Attribute("connectionTimeout", new Integer(connectionTimeout)));
            attribute = "connectionUploadTimeout";
            int connectionUploadTimeout = 0;
            try {
                connectionUploadTimeout = Integer.parseInt(cform.getConnUploadTimeOutText());
            }
            catch (Throwable t) {
                connectionUploadTimeout = 0;
            }
            this.mBServer.setAttribute(coname, new Attribute("connectionUploadTimeout", new Integer(connectionUploadTimeout)));
            attribute = "bufferSize";
            int bufferSize = 2048;
            try {
                bufferSize = Integer.parseInt(cform.getBufferSizeText());
            }
            catch (Throwable t) {
                bufferSize = 2048;
            }
            this.mBServer.setAttribute(coname, new Attribute("bufferSize", new Integer(bufferSize)));
            attribute = "disableUploadTimeout";
            this.mBServer.setAttribute(coname, new Attribute("disableUploadTimeout", new Boolean(cform.getDisableUploadTimeout())));
            attribute = "enableLookups";
            this.mBServer.setAttribute(coname, new Attribute("enableLookups", new Boolean(cform.getEnableLookups())));
            attribute = "redirectPort";
            int redirectPort = 0;
            try {
                redirectPort = Integer.parseInt(cform.getRedirectPortText());
            }
            catch (Throwable t) {
                redirectPort = 0;
            }
            this.mBServer.setAttribute(coname, new Attribute("redirectPort", new Integer(redirectPort)));
            attribute = "minProcessors";
            int minProcessors = 5;
            try {
                minProcessors = Integer.parseInt(cform.getMinProcessorsText());
            }
            catch (Throwable t) {
                minProcessors = 5;
            }
            attribute = "maxProcessors";
            int maxProcessors = 20;
            try {
                maxProcessors = Integer.parseInt(cform.getMaxProcessorsText());
            }
            catch (Throwable t) {
                maxProcessors = 20;
            }
            attribute = "maxKeepAliveRequests";
            int maxKeepAliveRequests = 100;
            try {
                maxKeepAliveRequests = Integer.parseInt(cform.getMaxKeepAliveText());
            }
            catch (Throwable t) {
                maxKeepAliveRequests = 100;
            }
            this.mBServer.setAttribute(coname, new Attribute("maxKeepAliveRequests", new Integer(maxKeepAliveRequests)));
            attribute = "maxSpareThreads";
            int maxSpare = 50;
            try {
                maxSpare = Integer.parseInt(cform.getMaxSpare());
            }
            catch (Throwable t) {
                maxSpare = 50;
            }
            this.mBServer.setAttribute(coname, new Attribute(attribute, new Integer(maxSpare).toString()));
            attribute = "maxThreads";
            int maxThreads = 200;
            try {
                maxThreads = Integer.parseInt(cform.getMaxThreads());
            }
            catch (Throwable t) {
                maxThreads = 200;
            }
            this.mBServer.setAttribute(coname, new Attribute(attribute, new Integer(maxThreads).toString()));
            attribute = "minSpareThreads";
            int minSpare = 4;
            try {
                minSpare = Integer.parseInt(cform.getMinSpare());
            }
            catch (Throwable t) {
                minSpare = 4;
            }
            this.mBServer.setAttribute(coname, new Attribute(attribute, new Integer(minSpare).toString()));
            attribute = "threadPriority";
            int threadPriority = 5;
            try {
                threadPriority = Integer.parseInt(cform.getThreadPriority());
            }
            catch (Throwable t) {
                threadPriority = 5;
            }
            this.mBServer.setAttribute(coname, new Attribute(attribute, new Integer(threadPriority)));
            attribute = "secure";
            this.mBServer.setAttribute(coname, new Attribute("secure", new Boolean(cform.getSecure())));
            attribute = "tcpNoDelay";
            this.mBServer.setAttribute(coname, new Attribute("tcpNoDelay", new Boolean(cform.getTcpNoDelay())));
            attribute = "xpoweredBy";
            this.mBServer.setAttribute(coname, new Attribute("xpoweredBy", new Boolean(cform.getXpoweredBy())));
            attribute = "URIEncoding";
            String uriEnc = cform.getURIEncodingText();
            if (uriEnc != null && uriEnc.length() == 0) {
                uriEnc = null;
            }
            this.mBServer.setAttribute(coname, new Attribute(attribute, uriEnc));
            attribute = "useBodyEncodingForURI";
            this.mBServer.setAttribute(coname, new Attribute(attribute, new Boolean(cform.getUseBodyEncodingForURIText())));
            attribute = "allowTrace";
            this.mBServer.setAttribute(coname, new Attribute(attribute, new Boolean(cform.getAllowTraceText())));
            if (!"AJP".equalsIgnoreCase(connectorType)) {
                attribute = "proxyName";
                String proxyName = cform.getProxyName();
                if (proxyName != null && proxyName.length() > 0) {
                    this.mBServer.setAttribute(coname, new Attribute("proxyName", proxyName));
                }
                attribute = "proxyPort";
                int proxyPort = 0;
                try {
                    proxyPort = Integer.parseInt(cform.getProxyPortText());
                }
                catch (Throwable t) {
                    proxyPort = 0;
                }
                this.mBServer.setAttribute(coname, new Attribute("proxyPort", new Integer(proxyPort)));
            }
            if ("HTTPS".equalsIgnoreCase(connectorType)) {
                attribute = "algorithm";
                String algorithm = cform.getAlgorithm();
                if (algorithm != null && algorithm.length() > 0) {
                    this.mBServer.setAttribute(coname, new Attribute("algorithm", algorithm));
                }
                attribute = "clientAuth";
                this.mBServer.setAttribute(coname, new Attribute("clientAuth", cform.getClientAuthentication()));
                attribute = "ciphers";
                String ciphers = cform.getCiphers();
                if (ciphers != null && ciphers.length() > 0) {
                    this.mBServer.setAttribute(coname, new Attribute("ciphers", ciphers));
                }
                attribute = "keystoreFile";
                String keyFile = cform.getKeyStoreFileName();
                if (keyFile != null && keyFile.length() > 0) {
                    this.mBServer.setAttribute(coname, new Attribute("keystoreFile", keyFile));
                }
                attribute = "keystorePass";
                String keyPass = cform.getKeyStorePassword();
                if (keyPass != null && keyPass.length() > 0) {
                    this.mBServer.setAttribute(coname, new Attribute("keystorePass", keyPass));
                }
                attribute = "keystoreType";
                String keyType = cform.getKeyStoreType();
                if (keyType != null && keyType.length() > 0) {
                    this.mBServer.setAttribute(coname, new Attribute("keystoreType", keyType));
                }
                attribute = "sslProtocol";
                String sslProtocol = cform.getSslProtocol();
                if (sslProtocol != null && sslProtocol.length() > 0) {
                    this.mBServer.setAttribute(coname, new Attribute("sslProtocol", sslProtocol));
                }
            }
        }
        catch (Exception e) {
            this.getServlet().log(this.resources.getMessage(locale, "users.error.attribute.set", (Object)attribute), (Throwable)e);
            response.sendError(500, this.resources.getMessage(locale, "users.error.attribute.set", (Object)attribute));
            return null;
        }
        session.removeAttribute(mapping.getAttribute());
        return mapping.findForward("Save Successful");
    }
}

