/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.util;

import java.util.regex.Pattern;

public class PatternConstructor {
    private static final Pattern PATTERN_BACK_SLASH = Pattern.compile("\\\\");
    private static final Pattern PATTERN_QUESTION = Pattern.compile("\\?");
    private static final Pattern PATTERN_STAR = Pattern.compile("\\*");

    private static String asRegEx(String pattern) {
        String result1 = PATTERN_BACK_SLASH.matcher(pattern).replaceAll("\\\\E\\\\\\\\\\\\Q");
        String result2 = PATTERN_STAR.matcher(result1).replaceAll("\\\\E.*\\\\Q");
        String result3 = PATTERN_QUESTION.matcher(result2).replaceAll("\\\\E.\\\\Q");
        return "\\Q" + result3 + "\\E";
    }

    public static Pattern createPattern(String pattern, boolean isCaseSensitive) {
        if (isCaseSensitive) {
            return Pattern.compile(PatternConstructor.asRegEx(pattern));
        }
        return Pattern.compile(PatternConstructor.asRegEx(pattern), 66);
    }

    private PatternConstructor() {
    }
}

