/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.variables;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.debug.internal.ui.views.IDebugExceptionHandler;
import org.eclipse.debug.internal.ui.views.RemoteTreeContentManager;
import org.eclipse.debug.internal.ui.views.RemoteTreeViewer;
import org.eclipse.debug.internal.ui.views.variables.RemoteVariableContentManager;
import org.eclipse.debug.internal.ui.views.variables.VariablesView;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;

public class RemoteVariablesContentProvider
extends BaseWorkbenchContentProvider {
    private HashMap fParentCache;
    private IDebugExceptionHandler fExceptionHandler = null;
    private boolean fUseObjectBrowsers;
    private RemoteVariableContentManager fManager;

    public RemoteVariablesContentProvider(RemoteTreeViewer viewer, IWorkbenchPartSite site, VariablesView view) {
        this.fManager = (RemoteVariableContentManager)this.createContentManager(viewer, site, view);
        this.fParentCache = new HashMap(10);
    }

    protected RemoteTreeContentManager createContentManager(RemoteTreeViewer viewer, IWorkbenchPartSite site, VariablesView view) {
        return new RemoteVariableContentManager((ITreeContentProvider)this, viewer, site, view);
    }

    public Object[] getChildren(Object parent) {
        Object[] children = this.fManager.getChildren(parent);
        if (children == null) {
            children = super.getChildren(parent);
        }
        if (children != null) {
            this.cache(parent, children);
            return children;
        }
        return new Object[0];
    }

    protected void cache(Object parent, Object[] children) {
        int i = 0;
        while (i < children.length) {
            Object child = children[i];
            if (!this.fParentCache.containsKey(child)) {
                this.fParentCache.put(child, parent);
            }
            ++i;
        }
    }

    public Object getParent(Object item) {
        return this.fParentCache.get(item);
    }

    public void dispose() {
        this.fManager.clearHasChildrenCache();
        this.fManager.cancel();
        this.fParentCache = null;
        this.setExceptionHandler(null);
    }

    protected void clearCache() {
        if (this.fParentCache != null) {
            this.fParentCache.clear();
        }
    }

    public void removeCache(Object[] children) {
        if (this.fParentCache == null) {
            return;
        }
        int i = 0;
        while (i < children.length) {
            this.fParentCache.remove(children[i]);
            ++i;
        }
    }

    public boolean hasChildren(Object element) {
        return this.fManager.mayHaveChildren(element);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.clearCache();
        this.fManager.cancel();
        this.fManager.clearHasChildrenCache();
    }

    public List getCachedDecendants(Object parent) {
        Iterator children = this.fParentCache.keySet().iterator();
        ArrayList cachedChildren = new ArrayList(10);
        while (children.hasNext()) {
            Object child = children.next();
            if (!this.isCachedDecendant(child, parent)) continue;
            cachedChildren.add(child);
        }
        return cachedChildren;
    }

    protected boolean isCachedDecendant(Object child, Object parent) {
        Object p = this.getParent(child);
        while (p != null) {
            if (p.equals(parent)) {
                return true;
            }
            p = this.getParent(p);
        }
        return false;
    }

    protected void setExceptionHandler(IDebugExceptionHandler handler) {
        this.fExceptionHandler = handler;
    }

    protected IDebugExceptionHandler getExceptionHandler() {
        return this.fExceptionHandler;
    }

    public void setShowLogicalStructure(boolean flag) {
        this.fUseObjectBrowsers = flag;
    }

    public boolean isShowLogicalStructure() {
        return this.fUseObjectBrowsers;
    }

    public RemoteVariableContentManager getContentManager() {
        return this.fManager;
    }
}

