/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory.renderings;

import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.memory.AbstractTableRendering;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.PlatformUI;

public class FormatColumnAction
extends Action {
    AbstractTableRendering fRendering;
    int fNumBytesPerCol;

    public FormatColumnAction(int numUnits, int addressableSize, AbstractTableRendering rendering) {
        String label = numUnits == 1 ? String.valueOf(String.valueOf(numUnits)) + " " + DebugUIMessages.FormatColumnAction_unit : String.valueOf(String.valueOf(numUnits)) + " " + DebugUIMessages.FormatColumnAction_units;
        super.setText(label);
        this.fRendering = rendering;
        if (numUnits * addressableSize == this.fRendering.getBytesPerColumn()) {
            this.setChecked(true);
        }
        this.fNumBytesPerCol = numUnits * addressableSize;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, String.valueOf(IDebugUIConstants.PLUGIN_ID) + ".FormatColumnAction_context");
    }

    public void run() {
        this.fRendering.format(this.fRendering.getBytesPerLine(), this.fNumBytesPerCol);
    }

    public int getColumnSize() {
        return this.fNumBytesPerCol;
    }
}

