/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.expression;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IErrorReportingExpression;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.elements.adapters.DeferredExpressionLogicalStructure;
import org.eclipse.debug.internal.ui.views.RemoteTreeViewer;
import org.eclipse.debug.internal.ui.views.variables.RemoteVariableContentManager;
import org.eclipse.debug.internal.ui.views.variables.VariablesView;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;

public class RemoteExpressionContentManager
extends RemoteVariableContentManager {
    private IDeferredWorkbenchAdapter fExpressionLogicalStructureAdapter = new DeferredExpressionLogicalStructure();

    public RemoteExpressionContentManager(ITreeContentProvider provider, RemoteTreeViewer viewer, IWorkbenchPartSite site, VariablesView view) {
        super(provider, viewer, site, view);
    }

    protected IDeferredWorkbenchAdapter getAdapter(Object element) {
        if (element instanceof IExpression && this.fView != null && this.fView.isShowLogicalStructure()) {
            return this.fExpressionLogicalStructureAdapter;
        }
        return super.getAdapter(element);
    }

    public boolean mayHaveChildren(Object element) {
        IExpression expression;
        IValue value;
        IErrorReportingExpression iere;
        if (element instanceof IErrorReportingExpression && (iere = (IErrorReportingExpression)element).hasErrors()) {
            return true;
        }
        if (element instanceof IExpression && (value = (expression = (IExpression)element).getValue()) != null) {
            try {
                IVariable[] variables = value.getVariables();
                return variables.length > 0;
            }
            catch (DebugException debugException) {}
        }
        return super.mayHaveChildren(element);
    }
}

