/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.breakpoints;

import java.util.ArrayList;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointsListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IInternalDebugUIConstants;
import org.eclipse.debug.internal.ui.views.breakpoints.WorkingSetCategory;
import org.eclipse.debug.ui.AbstractBreakpointOrganizerDelegate;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;

public class BreakpointSetOrganizer
extends AbstractBreakpointOrganizerDelegate
implements IPropertyChangeListener,
IBreakpointsListener {
    IWorkingSetManager fWorkingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();

    public BreakpointSetOrganizer() {
        this.fWorkingSetManager.addPropertyChangeListener((IPropertyChangeListener)this);
        DebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointsListener)this);
    }

    public IAdaptable[] getCategories(IBreakpoint breakpoint) {
        ArrayList<WorkingSetCategory> result = new ArrayList<WorkingSetCategory>();
        IWorkingSet[] workingSets = this.fWorkingSetManager.getWorkingSets();
        int i = 0;
        while (i < workingSets.length) {
            IWorkingSet set = workingSets[i];
            if ("org.eclipse.debug.ui.breakpointWorkingSet".equals(set.getId())) {
                IAdaptable[] elements = set.getElements();
                int j = 0;
                while (j < elements.length) {
                    IAdaptable adaptable = elements[j];
                    if (adaptable.equals(breakpoint)) {
                        result.add(new WorkingSetCategory(set));
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result.toArray(new IAdaptable[result.size()]);
    }

    public void dispose() {
        this.fWorkingSetManager.removePropertyChangeListener((IPropertyChangeListener)this);
        this.fWorkingSetManager = null;
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointsListener)this);
        DebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    public void propertyChange(PropertyChangeEvent event) {
        IWorkingSet set = null;
        if (event.getNewValue() instanceof IWorkingSet) {
            set = (IWorkingSet)event.getNewValue();
        } else if (event.getOldValue() instanceof IWorkingSet) {
            set = (IWorkingSet)event.getOldValue();
        }
        if (set != null && "org.eclipse.debug.ui.breakpointWorkingSet".equals(set.getId())) {
            this.fireCategoryChanged((IAdaptable)new WorkingSetCategory(set));
        }
        if (event.getProperty().equals(IInternalDebugUIConstants.MEMENTO_BREAKPOINT_WORKING_SET_NAME)) {
            IWorkingSet defaultWorkingSet = BreakpointSetOrganizer.getDefaultWorkingSet();
            if (defaultWorkingSet != null) {
                this.fireCategoryChanged((IAdaptable)new WorkingSetCategory(defaultWorkingSet));
            } else {
                this.fireCategoryChanged(null);
            }
        }
    }

    public void breakpointsAdded(IBreakpoint[] breakpoints) {
        IWorkingSet set = BreakpointSetOrganizer.getDefaultWorkingSet();
        if (set != null) {
            IAdaptable[] elements = set.getElements();
            IAdaptable[] newElements = new IAdaptable[elements.length + breakpoints.length];
            System.arraycopy(elements, 0, newElements, 0, elements.length);
            System.arraycopy(breakpoints, 0, newElements, elements.length, breakpoints.length);
            set.setElements(newElements);
        }
    }

    public void breakpointsRemoved(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        IWorkingSet[] workingSets = this.fWorkingSetManager.getWorkingSets();
        int i = 0;
        while (i < workingSets.length) {
            IWorkingSet set = workingSets[i];
            if ("org.eclipse.debug.ui.breakpointWorkingSet".equals(set.getId())) {
                this.clean(set);
            }
            ++i;
        }
    }

    private void clean(IWorkingSet workingSet) {
        IAdaptable[] elements = workingSet.getElements();
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        boolean update = false;
        int i = 0;
        while (i < elements.length) {
            IBreakpoint breakpoint;
            IAdaptable adaptable = elements[i];
            if (adaptable instanceof IBreakpoint && !manager.isRegistered(breakpoint = (IBreakpoint)adaptable)) {
                update = true;
                elements[i] = null;
            }
            ++i;
        }
        if (update) {
            ArrayList<IAdaptable> newElements = new ArrayList<IAdaptable>(elements.length);
            int i2 = 0;
            while (i2 < elements.length) {
                IAdaptable adaptable = elements[i2];
                if (adaptable != null) {
                    newElements.add(adaptable);
                }
                ++i2;
            }
            workingSet.setElements(newElements.toArray(new IAdaptable[newElements.size()]));
        }
    }

    public void breakpointsChanged(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
    }

    public static IWorkingSet getDefaultWorkingSet() {
        IPreferenceStore preferenceStore = DebugUIPlugin.getDefault().getPreferenceStore();
        String name = preferenceStore.getString(IInternalDebugUIConstants.MEMENTO_BREAKPOINT_WORKING_SET_NAME);
        if (name != null) {
            return PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(name);
        }
        return null;
    }

    public static void setDefaultWorkingSet(IWorkingSet set) {
        String name = "";
        if (set != null && "org.eclipse.debug.ui.breakpointWorkingSet".equals(set.getId())) {
            name = set.getName();
        }
        DebugUIPlugin.getDefault().getPluginPreferences().setValue(IInternalDebugUIConstants.MEMENTO_BREAKPOINT_WORKING_SET_NAME, name);
    }

    public boolean canRemove(IBreakpoint breakpoint, IAdaptable category) {
        if (category instanceof WorkingSetCategory) {
            WorkingSetCategory wsc = (WorkingSetCategory)category;
            return "org.eclipse.debug.ui.breakpointWorkingSet".equals(wsc.getWorkingSet().getId());
        }
        return super.canRemove(breakpoint, category);
    }

    public boolean canAdd(IBreakpoint breakpoint, IAdaptable category) {
        if (category instanceof WorkingSetCategory) {
            WorkingSetCategory wsc = (WorkingSetCategory)category;
            return "org.eclipse.debug.ui.breakpointWorkingSet".equals(wsc.getWorkingSet().getId());
        }
        return super.canAdd(breakpoint, category);
    }

    public void addBreakpoint(IBreakpoint breakpoint, IAdaptable category) {
        if (category instanceof WorkingSetCategory) {
            IWorkingSet workingSet = ((WorkingSetCategory)category).getWorkingSet();
            IAdaptable[] elements = workingSet.getElements();
            IAdaptable[] newElements = new IAdaptable[elements.length + 1];
            System.arraycopy(elements, 0, newElements, 0, elements.length);
            newElements[elements.length] = breakpoint;
            workingSet.setElements(newElements);
        }
    }

    public void removeBreakpoint(IBreakpoint breakpoint, IAdaptable category) {
        if (category instanceof WorkingSetCategory) {
            IWorkingSet workingSet = ((WorkingSetCategory)category).getWorkingSet();
            IAdaptable[] elements = workingSet.getElements();
            ArrayList<IAdaptable> list = new ArrayList<IAdaptable>();
            int i = 0;
            while (i < elements.length) {
                IAdaptable adaptable = elements[i];
                if (!adaptable.equals(breakpoint)) {
                    list.add(adaptable);
                }
                ++i;
            }
            workingSet.setElements(list.toArray(new IAdaptable[list.size()]));
        }
    }

    public IAdaptable[] getCategories() {
        IWorkingSet[] workingSets = this.fWorkingSetManager.getWorkingSets();
        ArrayList<WorkingSetCategory> all = new ArrayList<WorkingSetCategory>();
        int i = 0;
        while (i < workingSets.length) {
            IWorkingSet set = workingSets[i];
            if ("org.eclipse.debug.ui.breakpointWorkingSet".equals(set.getId())) {
                all.add(new WorkingSetCategory(set));
            }
            ++i;
        }
        return all.toArray(new IAdaptable[all.size()]);
    }
}

