/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.dialogs.InstallCapabilityStep;
import org.eclipse.ui.internal.ide.dialogs.MultiStepCapabilityWizard;
import org.eclipse.ui.internal.ide.dialogs.RemoveCapabilityStep;
import org.eclipse.ui.internal.ide.dialogs.WizardStep;
import org.eclipse.ui.internal.ide.registry.Capability;
import org.eclipse.ui.internal.ide.registry.CapabilityRegistry;

public class UpdateProjectCapabilityWizard
extends MultiStepCapabilityWizard {
    private IProject project;
    private Capability[] addCapabilities;
    private Capability[] removeCapabilities;

    public UpdateProjectCapabilityWizard(IProject project, Capability[] addCapabilities, Capability[] removeCapabilities) {
        this.project = project;
        this.addCapabilities = addCapabilities;
        this.removeCapabilities = removeCapabilities;
        this.initializeDefaultPageImageDescriptor();
        this.setWindowTitle(IDEWorkbenchMessages.UpdateProjectCapabilityWizard_windowTitle);
    }

    private void buildSteps() {
        int stepNumber = 1;
        ArrayList<WizardStep> steps = new ArrayList<WizardStep>(this.removeCapabilities.length + this.addCapabilities.length);
        if (this.removeCapabilities.length > 0) {
            int i = this.removeCapabilities.length - 1;
            while (i >= 0) {
                if (this.removeCapabilities[i] != null) {
                    ArrayList<String> natureIds = new ArrayList<String>();
                    natureIds.add(this.removeCapabilities[i].getNatureId());
                    ArrayList uiIds = this.removeCapabilities[i].getHandleUIs();
                    if (uiIds != null) {
                        Iterator it = uiIds.iterator();
                        while (it.hasNext()) {
                            String id = (String)it.next();
                            int j = 0;
                            while (j < this.removeCapabilities.length) {
                                if (this.removeCapabilities[j] != null && this.removeCapabilities[j].getId().equals(id)) {
                                    natureIds.add(this.removeCapabilities[j].getNatureId());
                                    this.removeCapabilities[j] = null;
                                }
                                ++j;
                            }
                        }
                    }
                    String[] ids = new String[natureIds.size()];
                    natureIds.toArray(ids);
                    steps.add(new RemoveCapabilityStep(stepNumber, this.removeCapabilities[i], ids, this.project));
                    ++stepNumber;
                }
                --i;
            }
        }
        if (this.addCapabilities.length > 0) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            CapabilityRegistry reg = IDEWorkbenchPlugin.getDefault().getCapabilityRegistry();
            Capability[] results = reg.pruneCapabilities(this.addCapabilities);
            int i = 0;
            while (i < results.length) {
                steps.add(new InstallCapabilityStep(stepNumber, results[i], workbench, this));
                ++i;
                ++stepNumber;
            }
        }
        WizardStep[] results = new WizardStep[steps.size()];
        steps.toArray(results);
        this.setSteps(results);
    }

    protected void addCustomPages() {
    }

    protected boolean canFinishOnReviewPage() {
        WizardStep[] steps = this.getSteps();
        return steps.length == 1 && steps[0] instanceof RemoveCapabilityStep;
    }

    protected String getConfigurePageTitle() {
        return IDEWorkbenchMessages.UpdateProjectCapabilityWizard_title;
    }

    protected String getConfigurePageDescription() {
        return IDEWorkbenchMessages.WizardProjectConfigurePage_description;
    }

    protected String getFinishStepLabel(WizardStep[] steps) {
        int count = 0;
        int i = 0;
        while (i < steps.length) {
            if (!(steps[i] instanceof RemoveCapabilityStep) && ++count > 1) {
                return super.getFinishStepLabel(steps);
            }
            ++i;
        }
        return null;
    }

    protected String[] getPerspectiveChoices() {
        ArrayList<String> results = new ArrayList<String>();
        int i = 0;
        while (i < this.addCapabilities.length) {
            ArrayList ids = this.addCapabilities[i].getPerspectiveChoices();
            if (ids != null) {
                Iterator it = ids.iterator();
                while (it.hasNext()) {
                    String id = (String)it.next();
                    if (results.contains(id)) continue;
                    results.add(id);
                }
            }
            ++i;
        }
        String[] ids = new String[results.size()];
        results.toArray(ids);
        return ids;
    }

    public IProject getProject() {
        return this.project;
    }

    protected String getReviewPageTitle() {
        return IDEWorkbenchMessages.UpdateProjectCapabilityWizard_title;
    }

    protected String getReviewPageDescription() {
        return IDEWorkbenchMessages.WizardProjectReviewPage_description;
    }

    public IWizardPage getStartingPage() {
        IWizardPage page = super.getStartingPage();
        this.buildSteps();
        return page;
    }

    boolean handleMissingStepWizard(WizardStep step) {
        MessageDialog.openError((Shell)this.getShell(), (String)IDEWorkbenchMessages.UpdateProjectCapabilityWizard_errorTitle, (String)NLS.bind((String)IDEWorkbenchMessages.UpdateProjectCapabilityWizard_noWizard, (Object)step.getLabel()));
        return false;
    }

    protected void initializeDefaultPageImageDescriptor() {
        ImageDescriptor desc = IDEWorkbenchPlugin.getIDEImageDescriptor("wizban/newprj_wiz.gif");
        this.setDefaultPageImageDescriptor(desc);
    }
}

