/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.syncinfo;

import java.util.Date;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.Assert;

public class MutableResourceSyncInfo
extends ResourceSyncInfo {
    protected MutableResourceSyncInfo(ResourceSyncInfo info) {
        this.name = info.getName();
        this.setRevision(info.getRevision());
        this.setTag(info.getTag());
        this.timeStamp = info.getTimeStamp();
        this.isDirectory = info.isDirectory();
        this.keywordMode = info.getKeywordMode();
        this.isDeleted = info.isDeleted();
        if (info.isMergedWithConflicts()) {
            this.setSyncType(3);
        } else if (info.isMerged()) {
            this.setSyncType(2);
        } else {
            this.setSyncType(1);
        }
    }

    public MutableResourceSyncInfo(String name, String revision) {
        Assert.isNotNull(name);
        this.name = name;
        this.setRevision(revision);
    }

    public void setRevision(String revision) {
        super.setRevision(revision);
    }

    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    public void setTimeStamp(Date timeStamp, boolean clearMerged) {
        this.setTimeStamp(timeStamp);
        if (clearMerged) {
            this.setSyncType(1);
        }
    }

    public void setKeywordMode(Command.KSubstOption keywordMode) {
        this.keywordMode = keywordMode;
    }

    public void setTag(CVSTag tag) {
        super.setTag(tag);
    }

    public void setDeleted(boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    public void setAdded() {
        this.setRevision("0");
    }

    public void setMerged() {
        if (this.syncType == 1) {
            this.syncType = 2;
        }
    }

    public void setEntryLine(String entryLine) throws CVSException {
        super.setEntryLine(entryLine);
    }
}

