/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.model;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.Field;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.debug.core.IJavaClassObject;
import org.eclipse.jdt.debug.core.IJavaFieldVariable;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaReferenceType;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugModelMessages;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIFieldVariable;
import org.eclipse.jdt.internal.debug.core.model.JDIType;
import org.eclipse.jdt.internal.debug.core.model.JDIValue;

public abstract class JDIReferenceType
extends JDIType
implements IJavaReferenceType {
    private String[] fDeclaredFields = null;
    private String[] fAllFields = null;

    public JDIReferenceType(JDIDebugTarget target, Type type) {
        super(target, type);
    }

    public String[] getAvailableStrata() {
        List<String> strata = this.getReferenceType().availableStrata();
        return strata.toArray(new String[strata.size()]);
    }

    protected ReferenceType getReferenceType() {
        return (ReferenceType)this.getUnderlyingType();
    }

    public String getDefaultStratum() throws DebugException {
        try {
            return this.getReferenceType().defaultStratum();
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(JDIDebugModelMessages.JDIReferenceType_1, e);
            return null;
        }
    }

    public IJavaFieldVariable getField(String name) throws DebugException {
        try {
            ReferenceType type = (ReferenceType)this.getUnderlyingType();
            Field field = type.fieldByName(name);
            if (field != null && field.isStatic()) {
                return new JDIFieldVariable(this.getDebugTarget(), field, type);
            }
        }
        catch (RuntimeException e) {
            this.getDebugTarget().targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIClassType_exception_while_retrieving_field, e.toString(), name), e);
        }
        return null;
    }

    public IJavaClassObject getClassObject() throws DebugException {
        try {
            ReferenceType type = (ReferenceType)this.getUnderlyingType();
            return (IJavaClassObject)((Object)JDIValue.createValue(this.getDebugTarget(), type.classObject()));
        }
        catch (RuntimeException e) {
            this.getDebugTarget().targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIClassType_exception_while_retrieving_class_object, e.toString()), e);
            return null;
        }
    }

    public String[] getAllFieldNames() throws DebugException {
        if (this.fAllFields == null) {
            try {
                List<Field> fields = ((ReferenceType)this.getUnderlyingType()).allFields();
                this.fAllFields = new String[fields.size()];
                Iterator<Field> iterator = fields.iterator();
                int i = 0;
                while (iterator.hasNext()) {
                    Field field = iterator.next();
                    this.fAllFields[i] = field.name();
                    ++i;
                }
            }
            catch (RuntimeException e) {
                this.getDebugTarget().targetRequestFailed(JDIDebugModelMessages.JDIReferenceType_2, e);
            }
        }
        return this.fAllFields;
    }

    public String[] getDeclaredFieldNames() throws DebugException {
        if (this.fDeclaredFields == null) {
            try {
                List<Field> fields = ((ReferenceType)this.getUnderlyingType()).fields();
                this.fDeclaredFields = new String[fields.size()];
                Iterator<Field> iterator = fields.iterator();
                int i = 0;
                while (iterator.hasNext()) {
                    Field field = iterator.next();
                    this.fDeclaredFields[i] = field.name();
                    ++i;
                }
            }
            catch (RuntimeException e) {
                this.getDebugTarget().targetRequestFailed(JDIDebugModelMessages.JDIReferenceType_3, e);
            }
        }
        return this.fDeclaredFields;
    }

    public String[] getSourcePaths(String stratum) {
        try {
            List<String> sourcePaths = this.getReferenceType().sourcePaths(stratum);
            return sourcePaths.toArray(new String[sourcePaths.size()]);
        }
        catch (AbsentInformationException absentInformationException) {
            return new String[0];
        }
    }

    public IJavaObject getClassLoaderObject() throws DebugException {
        try {
            ReferenceType type = (ReferenceType)this.getUnderlyingType();
            return (IJavaObject)((Object)JDIValue.createValue(this.getDebugTarget(), type.classLoader()));
        }
        catch (RuntimeException e) {
            this.getDebugTarget().targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIReferenceType_0, e.toString()), e);
            return null;
        }
    }

    public static String getGenericName(ReferenceType type) throws DebugException {
        String[] typeParameters;
        if (type instanceof ArrayType) {
            try {
                Type componentType = ((ArrayType)type).componentType();
                if (componentType instanceof ReferenceType) {
                    return String.valueOf(JDIReferenceType.getGenericName((ReferenceType)componentType)) + "[]";
                }
                return type.name();
            }
            catch (ClassNotLoadedException classNotLoadedException) {}
        }
        String signature = type.signature();
        StringBuffer res = new StringBuffer(JDIReferenceType.getTypeName(signature));
        String genericSignature = type.genericSignature();
        if (genericSignature != null && (typeParameters = Signature.getTypeParameters((String)genericSignature)).length > 0) {
            res.append('<').append(Signature.getTypeVariable((String)typeParameters[0]));
            int i = 1;
            while (i < typeParameters.length) {
                res.append(',').append(Signature.getTypeVariable((String)typeParameters[i]));
                ++i;
            }
            res.append('>');
        }
        return res.toString();
    }

    public static String getTypeName(String genericTypeSignature) {
        int arrayDimension = 0;
        while (genericTypeSignature.charAt(arrayDimension) == '[') {
            ++arrayDimension;
        }
        int parameterStart = genericTypeSignature.indexOf(60);
        StringBuffer name = new StringBuffer();
        if (parameterStart < 0) {
            name.append(genericTypeSignature.substring(arrayDimension + 1, genericTypeSignature.length() - 1).replace('/', '.'));
        } else {
            name.append(genericTypeSignature.substring(arrayDimension + 1, parameterStart).replace('/', '.'));
            name.append(Signature.toString((String)genericTypeSignature).substring(parameterStart - 1 - arrayDimension).replace('/', '.'));
        }
        int i = 0;
        while (i < arrayDimension) {
            name.append("[]");
            ++i;
        }
        return name.toString();
    }

    public String getGenericSignature() throws DebugException {
        return this.getReferenceType().genericSignature();
    }
}

