/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.logicalstructures;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ILogicalStructureTypeDelegate;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.jdt.debug.core.IEvaluationRunnable;
import org.eclipse.jdt.debug.core.IJavaClassType;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaInterfaceType;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.core.logicalstructures.LogicalStructuresMessages;

public abstract class LogicalObjectStructureInterfaceType
implements ILogicalStructureTypeDelegate {
    private IJavaObject fObject;
    private IValue fResult;
    private boolean fDone = false;
    private static IStatus fgNeedThread = new Status(1, JDIDebugPlugin.getUniqueIdentifier(), 110, "Provides thread context for an evaluation", null);
    private static IStatusHandler fgThreadProvider;
    public static final int INFO_EVALUATION_THREAD = 110;
    static /* synthetic */ Class class$0;

    public boolean providesLogicalStructure(IValue value) {
        if (value instanceof IJavaObject) {
            IJavaObject object = (IJavaObject)value;
            try {
                IJavaType type = object.getJavaType();
                if (type instanceof IJavaClassType) {
                    IJavaClassType classType = (IJavaClassType)type;
                    IJavaInterfaceType[] interfaceTypes = classType.getAllInterfaces();
                    String targetInterface = this.getTargetInterfaceName();
                    int i = 0;
                    while (i < interfaceTypes.length) {
                        IJavaInterfaceType inter = interfaceTypes[i];
                        if (inter.getName().equals(targetInterface)) {
                            return true;
                        }
                        ++i;
                    }
                }
            }
            catch (DebugException debugException) {}
        }
        return false;
    }

    protected abstract String getTargetInterfaceName();

    protected abstract IEvaluationRunnable getEvaluation();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized IValue getLogicalStructure(IValue value) throws CoreException {
        final IJavaThread thread = this.getThread(value);
        if (thread == null) {
            throw new CoreException((IStatus)new Status(4, JDIDebugPlugin.getUniqueIdentifier(), 120, LogicalStructuresMessages.LogicalObjectStructureType_1, null));
        }
        this.setObject((IJavaObject)value);
        final IEvaluationRunnable evaluation = this.getEvaluation();
        final CoreException[] ex = new CoreException[1];
        final LogicalObjectStructureInterfaceType lock = this;
        this.fDone = false;
        if (thread.isPerformingEvaluation() && thread.isSuspended()) {
            return value;
        }
        thread.queueRunnable(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    thread.runEvaluation(evaluation, null, 128, false);
                }
                catch (DebugException e) {
                    ex[0] = e;
                }
                Object object = lock;
                synchronized (object) {
                    LogicalObjectStructureInterfaceType.this.fDone = true;
                    lock.notifyAll();
                }
            }
        });
        try {
            LogicalObjectStructureInterfaceType logicalObjectStructureInterfaceType = lock;
            synchronized (logicalObjectStructureInterfaceType) {
                if (!this.fDone) {
                    lock.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {}
        if (ex[0] != null) {
            throw ex[0];
        }
        return this.fResult;
    }

    private IJavaThread getThread(IValue value) throws CoreException {
        IJavaDebugTarget javaTarget;
        IJavaThread thread;
        IStatusHandler handler = LogicalObjectStructureInterfaceType.getThreadProvider();
        if (handler != null && (thread = (IJavaThread)handler.handleStatus(fgNeedThread, (Object)value)) != null) {
            return thread;
        }
        IDebugTarget target = value.getDebugTarget();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.debug.core.IJavaDebugTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((javaTarget = (IJavaDebugTarget)target.getAdapter((Class)clazz)) != null) {
            IThread[] threads = javaTarget.getThreads();
            int i = 0;
            while (i < threads.length) {
                IThread thread2 = threads[i];
                if (thread2.isSuspended()) {
                    return (IJavaThread)thread2;
                }
                ++i;
            }
        }
        return null;
    }

    private static IStatusHandler getThreadProvider() {
        if (fgThreadProvider == null) {
            fgThreadProvider = DebugPlugin.getDefault().getStatusHandler(fgNeedThread);
        }
        return fgThreadProvider;
    }

    private void setObject(IJavaObject object) {
        this.fObject = object;
    }

    protected IJavaObject getObject() {
        return this.fObject;
    }

    protected void setLogicalStructure(IValue result) {
        this.fResult = result;
    }
}

