/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.wizards;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.wizards.GlobalRefreshWizardSelectionPage;
import org.eclipse.team.ui.TeamImages;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantReference;
import org.eclipse.ui.IWorkbench;

public class GlobalSynchronizeWizard
extends Wizard {
    private static final String DIALOG_SETTINGS_SECTION = "SynchronizeWizard";
    protected IWorkbench workbench;
    protected GlobalRefreshWizardSelectionPage mainPage;
    protected ISynchronizeParticipantReference participant;

    public GlobalSynchronizeWizard() {
        this.setWindowTitle(TeamUIMessages.GlobalSynchronizeWizard_11);
        this.setDefaultPageImageDescriptor(TeamImages.getImageDescriptor("wizban/share_wizban.gif"));
        this.setForcePreviousAndNextButtons(true);
        this.setNeedsProgressMonitor(false);
        IDialogSettings pluginSettings = TeamUIPlugin.getPlugin().getDialogSettings();
        IDialogSettings wizardSettings = pluginSettings.getSection(DIALOG_SETTINGS_SECTION);
        if (wizardSettings == null) {
            pluginSettings.addNewSection(DIALOG_SETTINGS_SECTION);
            wizardSettings = pluginSettings.getSection(DIALOG_SETTINGS_SECTION);
        }
        this.setDialogSettings(wizardSettings);
    }

    public void addPages() {
        this.mainPage = new GlobalRefreshWizardSelectionPage();
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean canFinish() {
        if (this.getContainer().getCurrentPage() == this.mainPage) {
            return this.mainPage.getSelectedWizard() != null && this.mainPage.getNextPage() == null;
        }
        return super.canFinish();
    }

    public boolean performFinish() {
        IWizard noPageWizard;
        if (this.getContainer().getCurrentPage() == this.mainPage && (noPageWizard = this.mainPage.getSelectedWizard()) != null && noPageWizard.canFinish()) {
            this.mainPage.savePageSettings();
            return noPageWizard.performFinish();
        }
        this.mainPage.savePageSettings();
        return true;
    }
}

