/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.actions;

import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.internal.core.Assert;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageSite;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.SyncInfoCompareInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class OpenInCompareAction
extends Action {
    private ISynchronizePageSite site;
    private final ISynchronizeParticipant participant;

    public OpenInCompareAction(ISynchronizePageSite site, ISynchronizeParticipant participant) {
        this.participant = participant;
        this.site = site;
        Utils.initAction((IAction)this, "action.openInCompareEditor.");
    }

    public void run() {
        SyncInfo info;
        Object obj;
        ISelection selection = this.site.getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof SyncInfoModelElement && (info = ((SyncInfoModelElement)obj).getSyncInfo()) != null) {
            OpenInCompareAction.openCompareEditor(this.participant, info, !OpenStrategy.activateOnOpen(), this.site);
        }
    }

    public static SyncInfoCompareInput openCompareEditor(ISynchronizeParticipant participant, SyncInfo info, boolean keepFocus, ISynchronizePageSite site) {
        Assert.isNotNull((Object)info);
        Assert.isNotNull((Object)participant);
        if (info.getLocal().getType() != 1) {
            return null;
        }
        SyncInfoCompareInput input = new SyncInfoCompareInput(participant, info);
        IWorkbenchPage page = null;
        if (site == null) {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null) {
                page = window.getActivePage();
            }
        } else {
            page = site.getWorkbenchSite().getPage();
        }
        if (page != null) {
            OpenInCompareAction.openCompareEditor(input, page);
            if (site != null && keepFocus) {
                site.setFocus();
            }
            return input;
        }
        return null;
    }

    public static void openCompareEditor(SyncInfoCompareInput input, IWorkbenchPage page) {
        if (page == null || input == null) {
            return;
        }
        IEditorPart editor = OpenInCompareAction.findReusableCompareEditor(page);
        if (editor != null) {
            IEditorInput otherInput = editor.getEditorInput();
            if (otherInput.equals((Object)input)) {
                page.activate((IWorkbenchPart)editor);
            } else {
                CompareUI.reuseCompareEditor((CompareEditorInput)input, (IReusableEditor)((IReusableEditor)editor));
                page.activate((IWorkbenchPart)editor);
            }
        } else {
            CompareUI.openCompareEditor((CompareEditorInput)input);
        }
    }

    public static IEditorPart findReusableCompareEditor(IWorkbenchPage page) {
        IEditorReference[] editorRefs = page.getEditorReferences();
        int i = 0;
        while (i < editorRefs.length) {
            IEditorPart part = editorRefs[i].getEditor(false);
            if (part != null && part.getEditorInput() instanceof SyncInfoCompareInput && part instanceof IReusableEditor && !part.isDirty()) {
                return part;
            }
            ++i;
        }
        return null;
    }

    public static IEditorPart findOpenCompareEditor(IWorkbenchPartSite site, IResource resource) {
        IWorkbenchPage page = site.getPage();
        IEditorReference[] editorRefs = page.getEditorReferences();
        int i = 0;
        while (i < editorRefs.length) {
            IEditorPart part = editorRefs[i].getEditor(false);
            if (part != null) {
                SyncInfo inputInfo;
                IEditorInput input = part.getEditorInput();
                if (part != null && input instanceof SyncInfoCompareInput && (inputInfo = ((SyncInfoCompareInput)input).getSyncInfo()).getLocal().equals((Object)resource)) {
                    return part;
                }
            }
            ++i;
        }
        return null;
    }
}

