/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.ITeamStatus;
import org.eclipse.team.core.synchronize.ISyncInfoSetChangeEvent;
import org.eclipse.team.core.synchronize.ISyncInfoSetChangeListener;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.internal.core.subscribers.ChangeSetCollector;
import org.eclipse.team.internal.ui.synchronize.ChangeSetModelProvider;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public abstract class SyncInfoSetChangeSetCollector
extends ChangeSetCollector {
    private final ISynchronizePageConfiguration configuration;
    private ChangeSetModelProvider provider;
    ISyncInfoSetChangeListener changeSetListener = new ISyncInfoSetChangeListener(){

        public void syncInfoSetReset(SyncInfoSet set, IProgressMonitor monitor) {
            this.handleChangeEvent(set);
        }

        public void syncInfoChanged(ISyncInfoSetChangeEvent event, IProgressMonitor monitor) {
            this.handleChangeEvent(event.getSet());
        }

        public void syncInfoSetErrors(SyncInfoSet set, ITeamStatus[] errors, IProgressMonitor monitor) {
        }

        private void handleChangeEvent(SyncInfoSet set) {
            ChangeSet changeSet;
            if (set.isEmpty() && (changeSet = SyncInfoSetChangeSetCollector.this.getChangeSet(set)) != null) {
                SyncInfoSetChangeSetCollector.this.remove(changeSet);
            }
        }
    };

    public SyncInfoSetChangeSetCollector(ISynchronizePageConfiguration configuration) {
        this.configuration = configuration;
    }

    protected abstract void add(SyncInfo[] var1);

    protected void remove(IResource[] resources) {
        ChangeSet[] sets = this.getSets();
        int i = 0;
        while (i < sets.length) {
            ChangeSet set = sets[i];
            set.remove(resources);
            ++i;
        }
    }

    protected ISyncInfoSetChangeListener getChangeSetChangeListener() {
        return this.changeSetListener;
    }

    public void reset(SyncInfoSet seedSet) {
        ChangeSet[] sets = this.getSets();
        int i = 0;
        while (i < sets.length) {
            ChangeSet set2 = sets[i];
            this.remove(set2);
            ++i;
        }
        if (seedSet != null) {
            this.add(seedSet.getSyncInfos());
        }
    }

    public void handleChange(ISyncInfoSetChangeEvent event) {
        ArrayList<IResource> removals = new ArrayList<IResource>();
        ArrayList<SyncInfo> additions = new ArrayList<SyncInfo>();
        removals.addAll(Arrays.asList(event.getRemovedResources()));
        additions.addAll(Arrays.asList(event.getAddedResources()));
        SyncInfo[] changed = event.getChangedResources();
        int i = 0;
        while (i < changed.length) {
            SyncInfo info = changed[i];
            additions.add(info);
            removals.add(info.getLocal());
            ++i;
        }
        if (!removals.isEmpty()) {
            this.remove(removals.toArray(new IResource[removals.size()]));
        }
        if (!additions.isEmpty()) {
            this.add(additions.toArray(new SyncInfo[additions.size()]));
        }
    }

    public final ISynchronizePageConfiguration getConfiguration() {
        return this.configuration;
    }

    protected final void performUpdate(IWorkspaceRunnable runnable, boolean preserveExpansion, IProgressMonitor monitor) {
        this.provider.performUpdate(runnable, preserveExpansion, false);
    }

    public final void setProvider(ChangeSetModelProvider provider) {
        this.provider = provider;
    }

    public void waitUntilDone(IProgressMonitor monitor) {
    }
}

