/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.workingsets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetUpdater;

public class JavaWorkingSetUpdater
implements IWorkingSetUpdater,
IElementChangedListener {
    public static final String ID = "org.eclipse.jdt.ui.JavaWorkingSetPage";
    private List fWorkingSets = new ArrayList();

    public JavaWorkingSetUpdater() {
        JavaCore.addElementChangedListener((IElementChangedListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(IWorkingSet workingSet) {
        this.checkElementExistence(workingSet);
        List list = this.fWorkingSets;
        synchronized (list) {
            this.fWorkingSets.add(workingSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(IWorkingSet workingSet) {
        boolean result;
        List list = this.fWorkingSets;
        synchronized (list) {
            result = this.fWorkingSets.remove(workingSet);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(IWorkingSet workingSet) {
        List list = this.fWorkingSets;
        synchronized (list) {
            return this.fWorkingSets.contains(workingSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        List list = this.fWorkingSets;
        synchronized (list) {
            this.fWorkingSets.clear();
        }
        JavaCore.removeElementChangedListener((IElementChangedListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void elementChanged(ElementChangedEvent event) {
        IWorkingSet[] workingSets;
        List list = this.fWorkingSets;
        synchronized (list) {
            workingSets = this.fWorkingSets.toArray(new IWorkingSet[this.fWorkingSets.size()]);
        }
        int w = 0;
        while (w < workingSets.length) {
            WorkingSetDelta workingSetDelta = new WorkingSetDelta(workingSets[w]);
            this.processJavaDelta(workingSetDelta, event.getDelta());
            IResourceDelta[] resourceDeltas = event.getDelta().getResourceDeltas();
            if (resourceDeltas != null) {
                int r = 0;
                while (r < resourceDeltas.length) {
                    this.processResourceDelta(workingSetDelta, resourceDeltas[r]);
                    ++r;
                }
            }
            workingSetDelta.process();
            ++w;
        }
    }

    private void processJavaDelta(WorkingSetDelta result, IJavaElementDelta delta) {
        IResourceDelta[] resourceDeltas;
        IJavaElement jElement = delta.getElement();
        int index = result.indexOf(jElement);
        int type = jElement.getElementType();
        int kind = delta.getKind();
        int flags = delta.getFlags();
        if (type == 2 && kind == 4) {
            if (index != -1 && (flags & 0x400) != 0) {
                result.set(index, ((IJavaProject)jElement).getProject());
            } else if ((flags & 0x200) != 0 && (index = result.indexOf(((IJavaProject)jElement).getProject())) != -1) {
                result.set(index, jElement);
            }
        }
        if (index != -1 && kind == 2) {
            if ((flags & 0x20) != 0) {
                result.set(index, delta.getMovedToElement());
            } else {
                result.remove(index);
            }
        }
        if ((resourceDeltas = delta.getResourceDeltas()) != null) {
            int i = 0;
            while (i < resourceDeltas.length) {
                this.processResourceDelta(result, resourceDeltas[i]);
                ++i;
            }
        }
        IJavaElementDelta[] children = delta.getAffectedChildren();
        int i = 0;
        while (i < children.length) {
            this.processJavaDelta(result, children[i]);
            ++i;
        }
    }

    private void processResourceDelta(WorkingSetDelta result, IResourceDelta delta) {
        IResource resource = delta.getResource();
        int type = resource.getType();
        int index = result.indexOf(resource);
        int kind = delta.getKind();
        int flags = delta.getFlags();
        if (kind == 4 && type == 4 && index != -1 && (flags & 0x4000) != 0) {
            result.set(index, resource);
        }
        if (index != -1 && kind == 2) {
            if ((flags & 0x2000) != 0) {
                result.set(index, ResourcesPlugin.getWorkspace().getRoot().findMember(delta.getMovedToPath()));
            } else {
                result.remove(index);
            }
        }
        IResourceDelta[] children = delta.getAffectedChildren();
        int i = 0;
        while (i < children.length) {
            this.processResourceDelta(result, children[i]);
            ++i;
        }
    }

    private void checkElementExistence(IWorkingSet workingSet) {
        ArrayList<IAdaptable> elements = new ArrayList<IAdaptable>(Arrays.asList(workingSet.getElements()));
        boolean changed = false;
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            IProject project;
            IAdaptable element = (IAdaptable)iter.next();
            boolean remove = false;
            if (element instanceof IJavaElement) {
                IJavaElement jElement = (IJavaElement)element;
                project = jElement.getJavaProject().getProject();
                remove = (project == null || project.isOpen()) && !jElement.exists();
            } else if (element instanceof IResource) {
                IResource resource = (IResource)element;
                project = resource.getProject();
                boolean bl = remove = (project == null || project.isOpen()) && !resource.exists();
            }
            if (!remove) continue;
            iter.remove();
            changed = true;
        }
        if (changed) {
            workingSet.setElements(elements.toArray(new IAdaptable[elements.size()]));
        }
    }

    private static class WorkingSetDelta {
        private IWorkingSet fWorkingSet;
        private List fElements;
        private boolean fChanged;

        public WorkingSetDelta(IWorkingSet workingSet) {
            this.fWorkingSet = workingSet;
            this.fElements = new ArrayList<IAdaptable>(Arrays.asList(workingSet.getElements()));
        }

        public int indexOf(Object element) {
            return this.fElements.indexOf(element);
        }

        public void set(int index, Object element) {
            this.fElements.set(index, element);
            this.fChanged = true;
        }

        public void remove(int index) {
            if (this.fElements.remove(index) != null) {
                this.fChanged = true;
            }
        }

        public void process() {
            if (this.fChanged) {
                this.fWorkingSet.setElements(this.fElements.toArray(new IAdaptable[this.fElements.size()]));
            }
        }
    }
}

