/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ArchiveFileFilter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.jdt.launching.JavaRuntime;

public class CPListElement {
    public static final String SOURCEATTACHMENT = "sourcepath";
    public static final String OUTPUT = "output";
    public static final String EXCLUSION = "exclusion";
    public static final String INCLUSION = "inclusion";
    public static final String ACCESSRULES = "accessrules";
    public static final String COMBINE_ACCESSRULES = "combineaccessrules";
    public static final String JAVADOC = "javadoc_location";
    public static final String NATIVE_LIB_PATH = JavaRuntime.CLASSPATH_ATTR_LIBRARY_PATH_ENTRY;
    private IJavaProject fProject;
    private int fEntryKind;
    private IPath fPath;
    private IResource fResource;
    private boolean fIsExported;
    private boolean fIsMissing;
    private Object fParentContainer;
    private IClasspathEntry fCachedEntry;
    private ArrayList fChildren;

    public CPListElement(IJavaProject project, int entryKind, IPath path, IResource res) {
        this(null, project, entryKind, path, res);
    }

    public CPListElement(Object parent, IJavaProject project, int entryKind, IPath path, IResource res) {
        this.fProject = project;
        this.fEntryKind = entryKind;
        this.fPath = path;
        this.fChildren = new ArrayList();
        this.fResource = res;
        this.fIsExported = false;
        this.fIsMissing = false;
        this.fCachedEntry = null;
        this.fParentContainer = parent;
        switch (entryKind) {
            case 3: {
                this.createAttributeElement(OUTPUT, null, true);
                this.createAttributeElement(INCLUSION, new Path[0], true);
                this.createAttributeElement(EXCLUSION, new Path[0], true);
                break;
            }
            case 1: 
            case 4: {
                this.createAttributeElement(SOURCEATTACHMENT, null, true);
                this.createAttributeElement(JAVADOC, null, false);
                this.createAttributeElement(NATIVE_LIB_PATH, null, false);
                this.createAttributeElement(ACCESSRULES, new IAccessRule[0], true);
                break;
            }
            case 2: {
                this.createAttributeElement(ACCESSRULES, new IAccessRule[0], true);
                this.createAttributeElement(COMBINE_ACCESSRULES, Boolean.FALSE, true);
                break;
            }
            case 5: {
                this.createAttributeElement(ACCESSRULES, new IAccessRule[0], true);
                try {
                    IClasspathContainer container = JavaCore.getClasspathContainer((IPath)this.fPath, (IJavaProject)this.fProject);
                    if (container == null) break;
                    IClasspathEntry[] entries = container.getClasspathEntries();
                    int i = 0;
                    while (i < entries.length) {
                        IClasspathEntry entry = entries[i];
                        if (entry != null) {
                            CPListElement curr = CPListElement.createFromExisting(this, entry, this.fProject);
                            this.fChildren.add(curr);
                        } else {
                            JavaPlugin.logErrorMessage("Null entry in container '" + this.fPath + "'");
                        }
                        ++i;
                    }
                    break;
                }
                catch (JavaModelException javaModelException) {}
            }
        }
    }

    public IClasspathEntry getClasspathEntry() {
        if (this.fCachedEntry == null) {
            this.fCachedEntry = this.newClasspathEntry();
        }
        return this.fCachedEntry;
    }

    private IClasspathAttribute[] getClasspathAttributes() {
        ArrayList<IClasspathAttribute> res = new ArrayList<IClasspathAttribute>();
        int i = 0;
        while (i < this.fChildren.size()) {
            CPListElementAttribute elem;
            Object curr = this.fChildren.get(i);
            if (curr instanceof CPListElementAttribute && !(elem = (CPListElementAttribute)curr).isBuiltIn() && elem.getValue() != null) {
                res.add(elem.newClasspathAttribute());
            }
            ++i;
        }
        return res.toArray(new IClasspathAttribute[res.size()]);
    }

    private IClasspathEntry newClasspathEntry() {
        IClasspathAttribute[] extraAttributes = this.getClasspathAttributes();
        switch (this.fEntryKind) {
            case 3: {
                IPath[] inclusionPattern = (IPath[])this.getAttribute(INCLUSION);
                IPath[] exclusionPattern = (IPath[])this.getAttribute(EXCLUSION);
                IPath outputLocation = (IPath)this.getAttribute(OUTPUT);
                return JavaCore.newSourceEntry((IPath)this.fPath, (IPath[])inclusionPattern, (IPath[])exclusionPattern, (IPath)outputLocation, (IClasspathAttribute[])extraAttributes);
            }
            case 1: {
                IPath attach = (IPath)this.getAttribute(SOURCEATTACHMENT);
                IAccessRule[] accesRules = (IAccessRule[])this.getAttribute(ACCESSRULES);
                return JavaCore.newLibraryEntry((IPath)this.fPath, (IPath)attach, null, (IAccessRule[])accesRules, (IClasspathAttribute[])extraAttributes, (boolean)this.isExported());
            }
            case 2: {
                IAccessRule[] accesRules = (IAccessRule[])this.getAttribute(ACCESSRULES);
                boolean combineAccessRules = (Boolean)this.getAttribute(COMBINE_ACCESSRULES);
                return JavaCore.newProjectEntry((IPath)this.fPath, (IAccessRule[])accesRules, (boolean)combineAccessRules, (IClasspathAttribute[])extraAttributes, (boolean)this.isExported());
            }
            case 5: {
                IAccessRule[] accesRules = (IAccessRule[])this.getAttribute(ACCESSRULES);
                return JavaCore.newContainerEntry((IPath)this.fPath, (IAccessRule[])accesRules, (IClasspathAttribute[])extraAttributes, (boolean)this.isExported());
            }
            case 4: {
                IPath varAttach = (IPath)this.getAttribute(SOURCEATTACHMENT);
                IAccessRule[] accesRules = (IAccessRule[])this.getAttribute(ACCESSRULES);
                return JavaCore.newVariableEntry((IPath)this.fPath, (IPath)varAttach, null, (IAccessRule[])accesRules, (IClasspathAttribute[])extraAttributes, (boolean)this.isExported());
            }
        }
        return null;
    }

    public IPath getPath() {
        return this.fPath;
    }

    public int getEntryKind() {
        return this.fEntryKind;
    }

    public IResource getResource() {
        return this.fResource;
    }

    public CPListElementAttribute setAttribute(String key, Object value) {
        CPListElementAttribute attribute = this.findAttributeElement(key);
        if (attribute == null) {
            return null;
        }
        if (key.equals(EXCLUSION) || key.equals(INCLUSION)) {
            Assert.isTrue(value != null || this.fEntryKind != 3);
        }
        if (key.equals(ACCESSRULES)) {
            Assert.isTrue(value != null || this.fEntryKind == 3);
        }
        if (key.equals(COMBINE_ACCESSRULES)) {
            Assert.isTrue(value instanceof Boolean);
        }
        attribute.setValue(value);
        this.attributeChanged(key);
        return attribute;
    }

    public CPListElementAttribute findAttributeElement(String key) {
        int i = 0;
        while (i < this.fChildren.size()) {
            CPListElementAttribute elem;
            Object curr = this.fChildren.get(i);
            if (curr instanceof CPListElementAttribute && key.equals((elem = (CPListElementAttribute)curr).getKey())) {
                return elem;
            }
            ++i;
        }
        return null;
    }

    public Object getAttribute(String key) {
        CPListElementAttribute attrib = this.findAttributeElement(key);
        if (attrib != null) {
            return attrib.getValue();
        }
        return null;
    }

    private void createAttributeElement(String key, Object value, boolean builtIn) {
        this.fChildren.add(new CPListElementAttribute(this, key, value, builtIn));
    }

    private static boolean isFiltered(Object entry, String[] filteredKeys) {
        if (entry instanceof CPListElementAttribute) {
            String key = ((CPListElementAttribute)entry).getKey();
            int i = 0;
            while (i < filteredKeys.length) {
                if (key.equals(filteredKeys[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private Object[] getFilteredChildren(String[] filteredKeys) {
        int nChildren = this.fChildren.size();
        ArrayList res = new ArrayList(nChildren);
        int i = 0;
        while (i < nChildren) {
            Object curr = this.fChildren.get(i);
            if (!CPListElement.isFiltered(curr, filteredKeys)) {
                res.add(curr);
            }
            ++i;
        }
        return res.toArray();
    }

    public Object[] getChildren(boolean hideOutputFolder) {
        Path jreContainerPath;
        if (hideOutputFolder && this.fEntryKind == 3) {
            return this.getFilteredChildren(new String[]{OUTPUT});
        }
        if (this.fParentContainer instanceof CPListElement && (jreContainerPath = new Path(JavaRuntime.JRE_CONTAINER)).isPrefixOf(((CPListElement)this.fParentContainer).getPath())) {
            return this.getFilteredChildren(new String[]{ACCESSRULES, COMBINE_ACCESSRULES, NATIVE_LIB_PATH});
        }
        if (this.fEntryKind == 2) {
            return this.getFilteredChildren(new String[]{COMBINE_ACCESSRULES});
        }
        return this.fChildren.toArray();
    }

    public Object getParentContainer() {
        return this.fParentContainer;
    }

    private void attributeChanged(String key) {
        this.fCachedEntry = null;
    }

    private boolean canUpdateContainer() {
        if (this.fEntryKind == 5 && this.fProject != null) {
            ClasspathContainerInitializer initializer = JavaCore.getClasspathContainerInitializer((String)this.fPath.segment(0));
            return initializer != null && initializer.canUpdateClasspathContainer(this.fPath, this.fProject);
        }
        return false;
    }

    public boolean isInNonModifiableContainer() {
        if (this.fParentContainer instanceof CPListElement) {
            return !((CPListElement)this.fParentContainer).canUpdateContainer();
        }
        return false;
    }

    public boolean equals(Object other) {
        if (other != null && other.getClass().equals(this.getClass())) {
            CPListElement elem = (CPListElement)other;
            return this.getClasspathEntry().equals(elem.getClasspathEntry());
        }
        return false;
    }

    public int hashCode() {
        return this.fPath.hashCode() + this.fEntryKind;
    }

    public String toString() {
        return this.getClasspathEntry().toString();
    }

    public boolean isMissing() {
        return this.fIsMissing;
    }

    public void setIsMissing(boolean isMissing) {
        this.fIsMissing = isMissing;
    }

    public boolean isExported() {
        return this.fIsExported;
    }

    public void setExported(boolean isExported) {
        if (isExported != this.fIsExported) {
            this.fIsExported = isExported;
            this.attributeChanged(null);
        }
    }

    public IJavaProject getJavaProject() {
        return this.fProject;
    }

    public static CPListElement createFromExisting(IClasspathEntry curr, IJavaProject project) {
        return CPListElement.createFromExisting(null, curr, project);
    }

    public static CPListElement createFromExisting(Object parent, IClasspathEntry curr, IJavaProject project) {
        IPath path = curr.getPath();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource res = null;
        boolean isMissing = false;
        switch (curr.getEntryKind()) {
            case 5: {
                res = null;
                try {
                    isMissing = project != null && JavaCore.getClasspathContainer((IPath)path, (IJavaProject)project) == null;
                }
                catch (JavaModelException javaModelException) {
                    isMissing = true;
                }
                break;
            }
            case 4: {
                IPath resolvedPath = JavaCore.getResolvedVariablePath((IPath)path);
                res = null;
                isMissing = root.findMember(resolvedPath) == null && !resolvedPath.toFile().isFile();
                break;
            }
            case 1: {
                res = root.findMember(path);
                if (res != null) break;
                if (!ArchiveFileFilter.isArchivePath(path) && root.getWorkspace().validatePath(path.toString(), 2).isOK() && root.getProject(path.segment(0)).exists()) {
                    res = root.getFolder(path);
                }
                isMissing = !path.toFile().isFile();
                break;
            }
            case 3: {
                path = path.removeTrailingSeparator();
                res = root.findMember(path);
                if (res != null) break;
                if (root.getWorkspace().validatePath(path.toString(), 2).isOK()) {
                    res = root.getFolder(path);
                }
                isMissing = true;
                break;
            }
            case 2: {
                res = root.findMember(path);
                isMissing = res == null;
            }
        }
        CPListElement elem = new CPListElement(parent, project, curr.getEntryKind(), path, res);
        elem.setExported(curr.isExported());
        elem.setAttribute(SOURCEATTACHMENT, curr.getSourceAttachmentPath());
        elem.setAttribute(OUTPUT, curr.getOutputLocation());
        elem.setAttribute(EXCLUSION, curr.getExclusionPatterns());
        elem.setAttribute(INCLUSION, curr.getInclusionPatterns());
        elem.setAttribute(ACCESSRULES, curr.getAccessRules());
        elem.setAttribute(COMBINE_ACCESSRULES, new Boolean(curr.combineAccessRules()));
        IClasspathAttribute[] extraAttributes = curr.getExtraAttributes();
        int i = 0;
        while (i < extraAttributes.length) {
            IClasspathAttribute attrib = extraAttributes[i];
            elem.setAttribute(attrib.getName(), attrib.getValue());
            ++i;
        }
        if (project != null && project.exists()) {
            elem.setIsMissing(isMissing);
        }
        return elem;
    }

    public static StringBuffer appendEncodePath(IPath path, StringBuffer buf) {
        if (path != null) {
            String str = path.toString();
            buf.append('[').append(str.length()).append(']').append(str);
        } else {
            buf.append('[').append(']');
        }
        return buf;
    }

    public static StringBuffer appendEncodedString(String str, StringBuffer buf) {
        if (str != null) {
            buf.append('[').append(str.length()).append(']').append(str);
        } else {
            buf.append('[').append(']');
        }
        return buf;
    }

    public static StringBuffer appendEncodedFilter(IPath[] filters, StringBuffer buf) {
        if (filters != null) {
            buf.append('[').append(filters.length).append(']');
            int i = 0;
            while (i < filters.length) {
                CPListElement.appendEncodePath(filters[i], buf).append(';');
                ++i;
            }
        } else {
            buf.append('[').append(']');
        }
        return buf;
    }

    public static StringBuffer appendEncodedAccessRules(IAccessRule[] rules, StringBuffer buf) {
        if (rules != null) {
            buf.append('[').append(rules.length).append(']');
            int i = 0;
            while (i < rules.length) {
                CPListElement.appendEncodePath(rules[i].getPattern(), buf).append(';');
                buf.append(rules[i].getKind()).append(';');
                ++i;
            }
        } else {
            buf.append('[').append(']');
        }
        return buf;
    }

    public StringBuffer appendEncodedSettings(StringBuffer buf) {
        buf.append(this.fEntryKind).append(';');
        CPListElement.appendEncodePath(this.fPath, buf).append(';');
        buf.append((Object)this.fIsExported).append(';');
        int i = 0;
        while (i < this.fChildren.size()) {
            Object curr = this.fChildren.get(i);
            if (curr instanceof CPListElementAttribute) {
                CPListElementAttribute elem = (CPListElementAttribute)curr;
                if (elem.isBuiltIn()) {
                    String key = elem.getKey();
                    if (OUTPUT.equals(key) || SOURCEATTACHMENT.equals(key)) {
                        CPListElement.appendEncodePath((IPath)elem.getValue(), buf).append(';');
                    } else if (EXCLUSION.equals(key) || INCLUSION.equals(key)) {
                        CPListElement.appendEncodedFilter((IPath[])elem.getValue(), buf).append(';');
                    } else if (ACCESSRULES.equals(key)) {
                        CPListElement.appendEncodedAccessRules((IAccessRule[])elem.getValue(), buf).append(';');
                    } else if (COMBINE_ACCESSRULES.equals(key)) {
                        buf.append((Boolean)elem.getValue()).append(';');
                    }
                } else {
                    CPListElement.appendEncodedString((String)elem.getValue(), buf);
                }
            }
            ++i;
        }
        return buf;
    }
}

